package p2pmpi.ft;

import p2pmpi.common.*;
import p2pmpi.message.*;
import java.net.*;
import java.io.*;
import java.util.*;


public class FileTransferServer { 
	private int serverPort; 
	private int mpdPort;
	private String baseDir;

	public FileTransferServer(int serverPort, int mpdPort, String dir)
	{
		this.serverPort = serverPort;
		this.mpdPort	= mpdPort;
		this.baseDir	= dir;
	}

	public void start() {
		ServerSocket servSocket = null;
		Socket socket = null;
		try {
			servSocket = new ServerSocket(serverPort);
		} catch (Exception e) {
			System.err.println("** [Error] FT: Can't bind port.");
			e.printStackTrace();
			System.exit(1);
		}

		while(true) {
			try {
				socket = servSocket.accept();
				FileTransfer ft = new FileTransfer(socket);
				ft.start();
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
	}

	public class FileTransfer extends Thread {
		Socket socket;

		public FileTransfer(Socket socket) {
			this.socket = socket;
		}

		public void run() { 
			InputStream in = null;
			ObjectInputStream ois =  null;
			Object oMsg = null;
			FTMessage ftMsg = null;
			Socket soc = null;

			try {
				in = socket.getInputStream();
				ois = new ObjectInputStream(in);
				oMsg = ois.readObject();
			} catch (Exception e) {
				e.printStackTrace();
				return;
			}
			if(oMsg instanceof RequestQuitMessage) {
				System.exit(0);
			} else if (oMsg instanceof FTMessage) {
				ftMsg = (FTMessage)oMsg;

				switch(ftMsg.getCmd()) {
					case MessageCmd.FT_REGISTER :
						int numPeers = ftMsg.size();
						//URI[] uriList = ftMsg.getURIList();
						OutputStream out = null;
						ObjectOutputStream oos = null;

						for(int i = 0; i < numPeers; i++) {
							// Create a transfer message
							FTMessage sendMsg = new FTMessage(MessageCmd.FT_TRANSFER,
										  	ftMsg.getID());
							sendMsg.setKey(ftMsg.getKey(i));

							sendMsg.setFileNames(ftMsg.getFileNameList());

							//-- load file contents into the message
							sendMsg.setFileContent(ftMsg.getFileNameList());
							
							URI destination = ftMsg.getURI(i);
							try {
								soc = new Socket(destination.getHost(), destination.getPort());
								out = soc.getOutputStream();
								oos = new ObjectOutputStream(out);
								oos.writeObject(sendMsg);
								oos.flush();
								oos.close();
								out.close();
								soc.close();
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
						break;

					case MessageCmd.FT_TRANSFER :
						File appDir = new File(baseDir, (ftMsg.getID() + "--" + ftMsg.getKey()));
						appDir.mkdirs();
						File appFile;
						FileOutputStream fileOut;
						//-- get short filenames to write out
						String[] fileList = ftMsg.getOnlyFileNameList();
						String jarDep = "";
						String osname = OsInfo.getName();
						for (int i = 0; i < fileList.length; i++) {
							if(fileList[i].endsWith(".jar")) {
								//-- pathSeparator is OS variable
								jarDep = jarDep + File.pathSeparator + fileList[i];
							}
							//-- if filename is an http:// URL, download file 
							if (fileList[i].startsWith("http://")) {
								String parts [] = fileList[i].split(File.separator);
								//-- load remote contents into local mem.
								try {
									RemoteData remoteFile = new RemoteData(fileList[i]);
									if (remoteFile.setContent()) {
										System.out.println("md5sum :"
													+ parts[parts.length-1] 
													+ "\t" 
													+ remoteFile.getMD5Sum());
										remoteFile.writeToFile(appDir + File.separator + parts[parts.length-1]);
									}
	  								else {
										System.err.println("** [Error] could not fetch contents hosted at "+fileList[i]);
	  								}
								} catch (Exception e) { e.printStackTrace(); }
							}
							//-- otherwise, it is a file whose contents is contained in the message
							else {	
								appFile = new File(appDir, fileList[i]);

								try {
									fileOut = new FileOutputStream(appFile);
									fileOut.write(ftMsg.getFileContent(i));
									fileOut.flush();
									fileOut.close();
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
						}

						if (jarDep.equals("")) {
							jarDep = "_";
						} else {
							if (OsInfo.isWindows(osname)) {
								jarDep = "_" + jarDep;
							}
						}
						//System.out.println(">> Done transfer file for ID = " + ftMsg.getID() + "<<");

						// Construct message to tell local MPD to spawn an MPI application
						MPDMessage doneMsg = new MPDMessage(MessageCmd.FT_DONE, ftMsg.getID());
						doneMsg.setKey(ftMsg.getKey());
						doneMsg.setRunDir(appDir);
						//set dependance .jar for CLASSPATH
						doneMsg.setJars(jarDep);


						// Send a message to the local MPD	
						try {
							soc = new Socket("127.0.0.1", mpdPort);
							out = soc.getOutputStream();
							oos = new ObjectOutputStream(out);
							oos.writeObject(doneMsg);
							oos.flush();
							oos.close();
							out.close();
							soc.close();
						} catch (Exception e) {
							e.printStackTrace();
						}
						//System.out.println(">> Done notify my local MPD on MPDPORT = " + mpdPort);
						break;
	
					default :
						System.err.println("** [Error] FTMessage: Unknown Command.");
						break;
				}
			}
		}
	}


	static public void main(String[] args) {
		File tmpDir = new File(System.getProperty("P2PMPI_HOME"), "tmp");
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		FileTransferServer ftServer = new FileTransferServer(
							ppConf.getFTPort(), // FT port
							ppConf.getMPDPort(), // MPD port
							tmpDir.toString()
							//ppConf.getTempDirectory() //tmp dir
						);
		ftServer.start();
		System.out.println("Starting FT ...");
	}
}

