package p2pmpi.fd;

import java.util.*;
import java.io.*;
import java.net.*;

public class GossipInfo implements Serializable {
	private static final long serialVersionUID = 3000000L;
	private int numPeer;
	private URI[] uri;
	private boolean[] alive;
	private long[] heartbeat;

	public GossipInfo(int numPeer) {
		this.numPeer = numPeer;
		alive = new boolean[numPeer];
		heartbeat = new long[numPeer];
	}

	public boolean isAlive(int rank) {
		if((rank > numPeer) || (rank < 0))
			return false;

		return alive[rank];
	}

	public void setAlive(int rank, boolean value) {
		if((rank > numPeer) || (rank < 0))
			return;

		alive[rank] = value;
	}

	public long getHeartBeat(int rank) {
		if((rank > numPeer) || (rank < 0))
			return 0;

		return heartbeat[rank];
	}

	public void setHeartBeat(int rank, long value) {
		if((rank > numPeer) || (rank < 0))
			return;

		heartbeat[rank] = value;
	}

	public int getNumPeer() {
		return numPeer;
	}
}
