package p2pmpi.common;

import java.io.*;
public class TempFile {
	FileOutputStream fout;
	PrintStream ps;

	public int open(String filename) {
		try {
			fout = new FileOutputStream(filename);
			ps   = new PrintStream(fout);
		} catch (Exception e) {
			System.out.println( "** [Error]" + filename + ": Unable to open file");
			return -1;
		}
		return 1;
	}

	public int print(String msg) {
		try {
			ps.println(msg);
		} catch (Exception e) {
			System.out.print("** [Error] Unable to write to file");
			return -1;
		}
		return 1;
	}

	public int println(String msg) {
		try {
			ps.println(msg);
		} catch (Exception e) {
			System.out.println("** [Error] Unable to write to file");
			return -1;
		}
		return 1;
	}

	public void close() {
		try {
			fout.close();
		} catch (IOException e) {
		}
	}
}
