package p2pmpi.common;
import java.io.*;

public class HostEntry implements Serializable {
	private static final long serialVersionUID = 1000002L;
	String ip;
	int fdPort;
	int ftPort;
	int mpdPort;
	int rsPort;
	int numProcPerJob;
	boolean alive;
	int rtt;
	long lastUpdate;

	public HostEntry(String ip, int mpdPort, int fdPort, int ftPort, int rsPort, int numProcPerJob) {
		this.ip = ip;
		this.mpdPort = mpdPort;
		this.fdPort = fdPort;
		this.ftPort = ftPort;
		this.rsPort = rsPort;
		alive = true;
		rtt   = Integer.MAX_VALUE;
		this.numProcPerJob = numProcPerJob;
		lastUpdate = System.currentTimeMillis();
	}

	public void setLastUpdate() {
		lastUpdate = System.currentTimeMillis();
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public void setFdPort(int fdPort) {
		this.fdPort = fdPort;
	}

	public void setFtPort(int ftPort) {
		this.ftPort = ftPort;
	}

	public void setMpdPort(int mpdPort) {
		this.mpdPort = mpdPort;
	}

	public void setAlive(boolean alive) {
		this.alive = alive;
	}

	public void setRtt(int rtt) {
		if(rtt < this.rtt)
			this.rtt = rtt;
	}

	public void setNumProcPerJob(int numProcPerJob) {
		this.numProcPerJob = numProcPerJob;
	}

	public String getIp() {
		return ip;
	}

	public int getFdPort() {
		return fdPort;
	}
	public int getFtPort() {
		return ftPort;
	}

	public int getMpdPort() {
		return mpdPort;
	}
	public boolean isAlive() {
		return alive;
	}

	public int getRtt() {
		return rtt;
	}

	public int getNumProcPerJob() {
		return numProcPerJob;
	}

	public long getLastUpdate() {
		return (System.currentTimeMillis() - lastUpdate);
	}

	public boolean isUpdate() {
		return ((System.currentTimeMillis() - lastUpdate) < 240000);
	}

	public int getRsPort() {
		return rsPort;
	}

	public String toString() {
		return ip + ":" + mpdPort + ":" + fdPort + ":" + ftPort + ":" + rsPort + ":" + numProcPerJob;
	}
}
