/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.rs;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.HostEntry;
import p2pmpi.common.JobInfo;
import p2pmpi.common.NetIface;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.Version;
import p2pmpi.message.RSMessage;
import p2pmpi.message.ReplyJobInfoMessage;
import p2pmpi.message.RequestJobInfoMessage;
import p2pmpi.message.RequestQuitMessage;

public class ReservationServer {
    protected static Logger logRS;
    protected String mpdVer;
    protected int mpdPort;
    protected int rsPort;
    protected int numProcPerJob;
    protected int maxJob;
    protected volatile Vector<JobInfo> jobList;
    protected String hostAllow;
    protected String[] hostDeny;
    protected String usingIP;
    public static final int RESERVATION_OK = 0;
    public static final int RESERVATION_NOK = 1;
    public static final int RESERVATION_FAIL = 2;

    public ReservationServer(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        logRS = Logger.getLogger((String)"MPD");
        this.mpdVer = string3;
        this.mpdPort = n;
        this.rsPort = n2;
        this.maxJob = n4;
        this.numProcPerJob = n3;
        this.hostAllow = string2;
        logRS.debug((Object)("[RS] Host deny list = " + string));
        this.hostDeny = this.parseHostDenyList(string);
        this.jobList = new Vector();
        NetIface netIface = new NetIface();
        this.usingIP = netIface.getExternalIfIpv4();
        if (this.usingIP == null) {
            logRS.error((Object)"[RS] Error: could not determine a working network interface. Exiting.");
            System.err.println("[RS] Error: could not determine a working network interface. Exiting.");
            System.exit(1);
        }
    }

    protected String[] parseHostDenyList(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        logRS.info((Object)("[RS] Deny List specified in config. file:" + string));
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = stringArray[i].trim();
                URI uRI = new URI(string2);
                stringArray2[n] = new String(string2);
                logRS.info((Object)("[RS] - Requests from " + stringArray2[n] + " will be ignored."));
                ++n;
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                logRS.debug((Object)(" [RS] [Error] " + stringArray[i] + " is not a valid URI in configuration file."));
            }
        }
        logRS.info((Object)("[RS] Deny List parsed: " + stringArray2.length + " hosts or networks."));
        return stringArray2;
    }

    protected boolean isAllowed(String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            logRS.info((Object)(" [Denied] " + string + " is not allowed (from configuration file)."));
            return false;
        }
        return true;
    }

    public void start() {
        ServerSocket serverSocket = null;
        Socket socket = null;
        try {
            serverSocket = new ServerSocket(this.rsPort);
        }
        catch (Exception exception) {
            logRS.info((Object)("** [RS Error] " + exception.toString()));
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    socket = serverSocket.accept();
                    Reservation reservation = new Reservation(socket, this.mpdVer);
                    reservation.start();
                }
            }
            catch (Exception exception) {
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger((String)"MPD");
        String string = Version.MAINVERSION + "." + Version.SUBVERSION;
        logger.info((Object)("[RS] Starting reservation service (version " + string + "). Reading configuration ..."));
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(logger);
        ReservationServer reservationServer = new ReservationServer(p2PMPI_ConfigFile.getMPDPort(), p2PMPI_ConfigFile.getRSPort(), p2PMPI_ConfigFile.getNumProcPerJob(), p2PMPI_ConfigFile.getMaxJob(), p2PMPI_ConfigFile.getHostDeny(), p2PMPI_ConfigFile.getHostAllow(), string);
        reservationServer.start();
    }

    public class Reservation
    extends Thread {
        Socket socket;
        String mpdVer;

        public Reservation(Socket socket, String string) {
            this.socket = socket;
            this.mpdVer = string;
        }

        public synchronized void cleanupJobList() {
            int n;
            int n2 = ReservationServer.this.jobList.size();
            int[] nArray = new int[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                JobInfo jobInfo = ReservationServer.this.jobList.elementAt(n);
                if (jobInfo.getStatus() != 0 && jobInfo.getStatus() != 1 || !jobInfo.isOverReservePeriod()) continue;
                nArray[n3] = n;
                ++n3;
            }
            for (n = 0; n < n3; ++n) {
                ReservationServer.this.jobList.remove(nArray[n]);
            }
        }

        public synchronized boolean canReserve(String string, String string2) {
            if (!ReservationServer.this.isAllowed(string, ReservationServer.this.hostDeny)) {
                return false;
            }
            if (!this.mpdVer.equals(string2)) {
                return false;
            }
            this.cleanupJobList();
            if (ReservationServer.this.maxJob <= 0) {
                return true;
            }
            return ReservationServer.this.jobList.size() + 1 <= ReservationServer.this.maxJob;
        }

        public synchronized void cancelReservation(String string) {
            int n = ReservationServer.this.jobList.size();
            for (int i = 0; i < n; ++i) {
                JobInfo jobInfo = ReservationServer.this.jobList.elementAt(i);
                if (!jobInfo.getHashID().equals(string)) continue;
                ReservationServer.this.jobList.remove(i);
                break;
            }
        }

        public synchronized void updateStatus(String string) {
            int n = ReservationServer.this.jobList.size();
            for (int i = 0; i < n; ++i) {
                JobInfo jobInfo = ReservationServer.this.jobList.elementAt(i);
                if (!jobInfo.getHashID().equals(string)) continue;
                jobInfo.setStatus(2);
                break;
            }
        }

        public synchronized boolean checkAndUpdateProcessStatus(String string) {
            boolean bl = false;
            int n = ReservationServer.this.jobList.size();
            for (int i = 0; i < n; ++i) {
                JobInfo jobInfo = ReservationServer.this.jobList.elementAt(i);
                if (!jobInfo.getHashID().equals(string)) continue;
                jobInfo.setStatus(1);
                bl = true;
                break;
            }
            return bl;
        }

        public void run() {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            Object object = null;
            RSMessage rSMessage = null;
            try {
                inputStream = this.socket.getInputStream();
                outputStream = this.socket.getOutputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
                if (object instanceof RequestQuitMessage) {
                    System.exit(0);
                } else if (object instanceof RequestJobInfoMessage) {
                    this.cleanupJobList();
                    ReplyJobInfoMessage replyJobInfoMessage = new ReplyJobInfoMessage(ReservationServer.this.jobList);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(replyJobInfoMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                } else if (object instanceof RSMessage) {
                    rSMessage = (RSMessage)object;
                    switch (rSMessage.getCommand()) {
                        case 0: {
                            Vector<HostEntry> vector = rSMessage.getList();
                            String string = rSMessage.getHashID();
                            long l = rSMessage.getReservePeriod();
                            int n = vector.size();
                            Vector<HostEntry> vector2 = new Vector<HostEntry>();
                            Vector<HostEntry> vector3 = new Vector<HostEntry>();
                            logRS.info((Object)("[RS] RSMessage have list to reserver = " + n));
                            block15: for (int i = 0; i < n; ++i) {
                                HostEntry hostEntry = vector.elementAt(i);
                                int n2 = this.reserve(string, hostEntry, l);
                                switch (n2) {
                                    case 0: {
                                        vector2.add(hostEntry);
                                        continue block15;
                                    }
                                    case 1: {
                                        continue block15;
                                    }
                                    case 2: {
                                        vector3.add(hostEntry);
                                    }
                                }
                            }
                            logRS.info((Object)("[RS] Done reserved with = " + vector2.size()));
                            RSMessage rSMessage2 = new RSMessage();
                            rSMessage2.setList(vector2);
                            rSMessage2.setDeadList(vector3);
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(rSMessage2);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                            this.selfReserve(string, l);
                            break;
                        }
                        case 1: {
                            RSMessage rSMessage3 = new RSMessage();
                            String string = rSMessage.getHashID();
                            String string2 = rSMessage.getIp();
                            String string3 = rSMessage.getMpdVer();
                            long l = rSMessage.getReservePeriod();
                            if (this.canReserve(string2, this.mpdVer)) {
                                JobInfo jobInfo = new JobInfo(string, 0, l);
                                ReservationServer.this.jobList.add(jobInfo);
                                rSMessage3.setReservationReply(0);
                            } else {
                                rSMessage3.setReservationReply(1);
                            }
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(rSMessage3);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                            break;
                        }
                        case 7: {
                            String string = rSMessage.getHashID();
                            this.updateStatus(string);
                            break;
                        }
                        case 4: {
                            RSMessage rSMessage4 = new RSMessage();
                            rSMessage4.setReserved(this.checkAndUpdateProcessStatus(rSMessage.getHashID()));
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(rSMessage4);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                            break;
                        }
                        case 5: {
                            String string = rSMessage.getHashID();
                            Vector<HostEntry> vector = rSMessage.getList();
                            if (vector == null) break;
                            int n = vector.size();
                            for (int i = 0; i < n; ++i) {
                                this.cancelReservationToRS(string, vector.elementAt(i));
                            }
                            break;
                        }
                        case 6: {
                            this.cancelReservation(rSMessage.getHashID());
                        }
                    }
                }
                objectInputStream.close();
                inputStream.close();
                this.socket.close();
            }
            catch (Exception exception) {
                logRS.info((Object)("[RS] [Error]: " + exception.toString() + ", " + exception.getCause()));
                return;
            }
        }

        public void cancelReservationToRS(String string, HostEntry hostEntry) {
            RSMessage rSMessage = new RSMessage(6, string, ReservationServer.this.usingIP, this.mpdVer);
            try {
                Socket socket = new Socket(hostEntry.getIp(), hostEntry.getRsPort());
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(rSMessage);
                objectOutputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void selfReserve(String string, long l) {
            JobInfo jobInfo = new JobInfo(string, 0, l);
            ReservationServer.this.jobList.add(jobInfo);
        }

        public int reserve(String string, HostEntry hostEntry, long l) {
            RSMessage rSMessage = new RSMessage(1, string, ReservationServer.this.usingIP, this.mpdVer);
            rSMessage.setReservePeriod(l);
            RSMessage rSMessage2 = new RSMessage();
            try {
                Socket socket = new Socket(hostEntry.getIp(), hostEntry.getRsPort());
                socket.setSoTimeout(1000);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(rSMessage);
                objectOutputStream.flush();
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (rSMessage2 instanceof RSMessage) {
                    rSMessage2 = (RSMessage)object;
                    int n = rSMessage2.getReservationReply();
                    objectOutputStream.close();
                    objectInputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                    return n;
                }
                objectOutputStream.close();
                objectInputStream.close();
                outputStream.close();
                inputStream.close();
                socket.close();
                return 2;
            }
            catch (Exception exception) {
                return 2;
            }
        }
    }
}

