/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

public class Datatype {
    public static final int NULL = 0;
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int BOOLEAN = 4;
    public static final int INT = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int PACKED = 9;
    public static final int STRING = 10;
    public static final int OBJECT = 11;
    public static final int[] typeSize = new int[]{0, 1, 2, 2, 1, 4, 8, 4, 8, 0, 1, 1};
    int[] dispSeq;
    int baseType;
    int baseSize;

    public Datatype(int n) {
        this.dispSeq = new int[1];
        this.dispSeq[0] = 0;
        this.baseType = n;
        this.baseSize = typeSize[n];
    }

    public Datatype(int n, int[] nArray) {
        int n2 = nArray.length;
        this.dispSeq = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.dispSeq[i] = nArray[i];
        }
        this.baseType = n;
        this.baseSize = typeSize[n];
    }

    public int Lb() {
        int n = this.dispSeq.length;
        int n2 = this.dispSeq[0];
        for (int i = 1; i < n; ++i) {
            if (this.dispSeq[i] >= n2) continue;
            n2 = this.dispSeq[i];
        }
        return n2;
    }

    public int Ub() {
        int n = this.dispSeq.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.dispSeq[i] + 1;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int Extent() {
        return this.Ub() - this.Lb();
    }

    public int Size() {
        return this.Ub() - this.Lb();
    }

    public Datatype Contiguous(int n) {
        int n2 = this.dispSeq.length;
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i * n2 + j] = this.dispSeq[j] + i;
            }
        }
        return new Datatype(this.baseType, nArray);
    }

    public int[] getDisplacementSequence() {
        return this.dispSeq;
    }

    public int getBaseType() {
        return this.baseType;
    }

    public int getBaseSize() {
        return this.baseSize;
    }
}

