/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.HostEntry;
import p2pmpi.common.OsInfo;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.RankTable;
import p2pmpi.common.ReservationResult;
import p2pmpi.common.ReservedHost;
import p2pmpi.common.StreamGobbler;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.NotifyMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.PingRequestMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.message.ReplyHostCacheMessage;
import p2pmpi.message.RequestHostCacheMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.AppInfo;
import p2pmpi.mpd.P2PMPI_MPD;
import p2pmpi.p2p.message.UnregisterMessage;

public class MPD_Interface
extends Thread {
    P2PMPI_MPD parent;
    Logger log = null;
    protected Hashtable<String, AppInfo> hashTable;

    MPD_Interface(P2PMPI_MPD p2PMPI_MPD) {
        this.parent = p2PMPI_MPD;
        this.hashTable = new Hashtable();
        this.log = Logger.getLogger((String)"MPD");
    }

    public boolean recursiveRemove(File file) {
        try {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.recursiveRemove(fileArray[i]);
                    continue;
                }
                if (fileArray[i].delete()) continue;
                this.log.error((Object)("Failed: removing " + fileArray[i].toString() + "failed"));
            }
            if (!file.delete()) {
                this.log.error((Object)("Failed: removing " + file.toString() + "failed"));
                return false;
            }
        }
        catch (Exception exception) {
            this.log.debug((Object)exception.toString());
            return false;
        }
        return true;
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            this.log.info((Object)("Listen MPD Socket at " + this.parent.mpdPort));
            serverSocket = new ServerSocket(this.parent.mpdPort);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        while (true) {
            try {
                Socket socket = serverSocket.accept();
                MPD_InterfaceThread mPD_InterfaceThread = new MPD_InterfaceThread(serverSocket, socket);
                mPD_InterfaceThread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            System.gc();
        }
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class MPD_InterfaceThread
    extends Thread {
        ServerSocket serverSocket = null;
        Socket socket = null;
        Object oMsg;
        MPDMessage msg;
        AppRegisterMessage appRegMsg;
        AppInfo appInfo;

        MPD_InterfaceThread(ServerSocket serverSocket, Socket socket) {
            this.serverSocket = serverSocket;
            this.socket = socket;
        }

        public void unRegisterRsService(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "--");
            String string2 = stringTokenizer.nextToken();
            try {
                RSMessage rSMessage = new RSMessage(6, string2, null, null);
                Socket socket = new Socket("127.0.0.1", MPD_Interface.this.parent.rsPort);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(rSMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isReserved(String string) {
            boolean bl = false;
            try {
                RSMessage rSMessage = new RSMessage(4, string);
                Socket socket = new Socket("127.0.0.1", MPD_Interface.this.parent.rsPort);
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(rSMessage);
                objectOutputStream.flush();
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                rSMessage = (RSMessage)objectInputStream.readObject();
                bl = rSMessage.isReserved();
                objectOutputStream.close();
                objectInputStream.close();
                outputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public void run() {
            ObjectInputStream objectInputStream;
            InputStream inputStream;
            block53: {
                block60: {
                    ObjectOutputStream objectOutputStream;
                    OutputStream outputStream;
                    block59: {
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        block54: {
                                            Object object;
                                            block52: {
                                                inputStream = null;
                                                outputStream = null;
                                                objectInputStream = null;
                                                objectOutputStream = null;
                                                try {
                                                    inputStream = this.socket.getInputStream();
                                                    outputStream = this.socket.getOutputStream();
                                                    objectInputStream = new ObjectInputStream(inputStream);
                                                    this.oMsg = objectInputStream.readObject();
                                                }
                                                catch (Exception exception) {
                                                    return;
                                                }
                                                if (!(this.oMsg instanceof NotifyMessage)) break block52;
                                                NotifyMessage notifyMessage = (NotifyMessage)this.oMsg;
                                                MPD_Interface.this.log.debug((Object)"Got a notify message");
                                                String string = notifyMessage.getAppID();
                                                int n = notifyMessage.getRankInList();
                                                MPD_Interface.this.log.debug((Object)("Key = " + string));
                                                MPD_Interface.this.log.debug((Object)("DEADNODE = " + n));
                                                ProcessInfo processInfo = MPD_Interface.this.parent.procTab.getInfo(string);
                                                RankTable rankTable = processInfo.getRankTable();
                                                rankTable.setAlive(n, false);
                                                MPD_Interface.this.log.info((Object)("MPD got notify message deadnode =" + n));
                                                break block53;
                                            }
                                            if (!(this.oMsg instanceof RequestQuitMessage)) break block54;
                                            MPD_Interface.this.log.info((Object)"----->> Request shutdown MPD ---------<<<");
                                            RequestQuitMessage requestQuitMessage = new RequestQuitMessage();
                                            UnregisterMessage unregisterMessage = new UnregisterMessage(MPD_Interface.this.parent.myHost);
                                            try {
                                                MPD_Interface.this.log.info((Object)("Connect to " + MPD_Interface.this.parent.superNode.getHost() + ":" + MPD_Interface.this.parent.superNode.getPort()));
                                                object = new Socket(MPD_Interface.this.parent.superNode.getHost(), MPD_Interface.this.parent.superNode.getPort());
                                                outputStream = ((Socket)object).getOutputStream();
                                                objectOutputStream = new ObjectOutputStream(outputStream);
                                                objectOutputStream.writeObject(unregisterMessage);
                                                objectOutputStream.flush();
                                                objectOutputStream.close();
                                                outputStream.close();
                                                ((Socket)object).close();
                                            }
                                            catch (Exception exception) {
                                                MPD_Interface.this.log.info((Object)("ERROR: " + exception.toString()));
                                            }
                                            object = MPD_Interface.this.parent.procTab.elements();
                                            while (object.hasMoreElements()) {
                                                ProcessInfo processInfo = (ProcessInfo)object.nextElement();
                                                int n = processInfo.getPort();
                                                int n2 = processInfo.getRank();
                                                String string = processInfo.getRunDir();
                                                try {
                                                    Socket socket = new Socket("127.0.0.1", n);
                                                    outputStream = socket.getOutputStream();
                                                    objectOutputStream = new ObjectOutputStream(outputStream);
                                                    objectOutputStream.writeObject(requestQuitMessage);
                                                    objectOutputStream.flush();
                                                    objectOutputStream.close();
                                                    outputStream.close();
                                                    socket.close();
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                if (n2 == 0) continue;
                                                MPD_Interface.this.recursiveRemove(new File(string));
                                            }
                                            System.gc();
                                            MPD_Interface.this.recursiveRemove(MPD_Interface.this.parent.runPath);
                                            System.exit(0);
                                            break block53;
                                        }
                                        if (!(this.oMsg instanceof AppUnregisterMessage)) break block55;
                                        try {
                                            objectInputStream.close();
                                            inputStream.close();
                                            this.socket.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        AppUnregisterMessage appUnregisterMessage = (AppUnregisterMessage)this.oMsg;
                                        String string = appUnregisterMessage.getKey();
                                        String string2 = MPD_Interface.this.parent.procTab.getRunDir(string);
                                        int n = MPD_Interface.this.parent.procTab.getRank(string);
                                        MPD_Interface.this.log.debug((Object)("[MPD]: recieve unregister application of key = " + string));
                                        MPD_Interface.this.parent.procTab.removeProcess(string);
                                        if (n != 0) {
                                            try {
                                                Thread.sleep(1000L);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            MPD_Interface.this.recursiveRemove(new File(string2));
                                        }
                                        this.unRegisterRsService(string);
                                        break block53;
                                    }
                                    if (!(this.oMsg instanceof AppRegisterMessage)) break block56;
                                    this.appRegMsg = (AppRegisterMessage)this.oMsg;
                                    ProcessInfo processInfo = new ProcessInfo();
                                    processInfo.setID(this.appRegMsg.getID());
                                    processInfo.setRunCmd(this.appRegMsg.getRunCmd());
                                    processInfo.setIPRank0(this.appRegMsg.getIpRank0());
                                    processInfo.setRunDir(this.appRegMsg.getRunDir());
                                    processInfo.setRank(this.appRegMsg.getRank());
                                    processInfo.setPort(this.appRegMsg.getPort());
                                    processInfo.setMPISize(this.appRegMsg.getMPISize());
                                    processInfo.setRealSize(this.appRegMsg.getRealSize());
                                    processInfo.setRankTable(this.appRegMsg.getRankTable());
                                    MPD_Interface.this.parent.procTab.addProcess(processInfo);
                                    PingReplyMessage pingReplyMessage = new PingReplyMessage();
                                    try {
                                        objectOutputStream = new ObjectOutputStream(outputStream);
                                        objectOutputStream.writeObject(pingReplyMessage);
                                        objectOutputStream.flush();
                                        objectOutputStream.close();
                                        outputStream.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    break block53;
                                }
                                if (!(this.oMsg instanceof StatQueryMessage)) break block57;
                                StatInfoMessage statInfoMessage = new StatInfoMessage(MPD_Interface.this.parent.usingIP, MPD_Interface.this.parent.mpdPort);
                                Enumeration enumeration = MPD_Interface.this.parent.procTab.elements();
                                while (enumeration.hasMoreElements()) {
                                    statInfoMessage.addInfo((ProcessInfo)enumeration.nextElement());
                                }
                                try {
                                    objectOutputStream = new ObjectOutputStream(outputStream);
                                    objectOutputStream.writeObject(statInfoMessage);
                                    objectOutputStream.flush();
                                    objectOutputStream.close();
                                    outputStream.close();
                                }
                                catch (Exception exception) {}
                                break block53;
                            }
                            if (!(this.oMsg instanceof RequestHostCacheMessage)) break block58;
                            Vector<HostEntry> vector = new Vector<HostEntry>();
                            ArrayList arrayList = new ArrayList(MPD_Interface.this.parent.hostCache.entrySet());
                            Collections.sort(arrayList, new Comparator(){

                                public int compare(Object object, Object object2) {
                                    Map.Entry entry = (Map.Entry)object;
                                    Map.Entry entry2 = (Map.Entry)object2;
                                    int n = ((HostEntry)entry.getValue()).getRtt();
                                    int n2 = ((HostEntry)entry2.getValue()).getRtt();
                                    return n - n2;
                                }
                            });
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                vector.add((HostEntry)iterator.next().getValue());
                            }
                            ReplyHostCacheMessage replyHostCacheMessage = new ReplyHostCacheMessage(vector);
                            try {
                                objectOutputStream = new ObjectOutputStream(outputStream);
                                objectOutputStream.writeObject(replyHostCacheMessage);
                                objectOutputStream.flush();
                                objectOutputStream.close();
                                outputStream.close();
                            }
                            catch (Exception exception) {}
                            break block53;
                        }
                        if (!(this.oMsg instanceof PingRequestMessage)) break block59;
                        PingReplyMessage pingReplyMessage = new PingReplyMessage();
                        try {
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(pingReplyMessage);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block53;
                    }
                    if (!(this.oMsg instanceof MPDMessage)) break block60;
                    this.msg = (MPDMessage)this.oMsg;
                    block16 : switch (this.msg.getCmd()) {
                        case 7: {
                            int n;
                            int n3 = this.msg.getOptionN();
                            int n4 = n = this.msg.getOptionR();
                            int n5 = n3 * n;
                            int n6 = this.msg.getWaitTime();
                            URI uRI = this.msg.getIp();
                            String string = this.msg.getID();
                            String string3 = this.msg.getRunCmd();
                            String string4 = this.msg.getAllocationMode();
                            ReservationResult reservationResult = MPD_Interface.this.parent.searchMPD(string, n3, n, n6, string4);
                            int n7 = reservationResult.getStatus();
                            switch (n7) {
                                case 1: {
                                    MPD_Interface.this.log.info((Object)("[JOB] Can not Running " + (n5 + 1) + " processes on " + reservationResult.getNumNodeFound() + " machines"));
                                    FoundNodeMessage foundNodeMessage = new FoundNodeMessage(reservationResult.getNumNodeFound(), reservationResult.getNumSlotAvailable(), false);
                                    try {
                                        objectOutputStream = new ObjectOutputStream(outputStream);
                                        objectOutputStream.writeObject(foundNodeMessage);
                                        objectOutputStream.flush();
                                        objectOutputStream.close();
                                        outputStream.close();
                                    }
                                    catch (Exception exception) {
                                        MPD_Interface.this.log.info((Object)exception.toString());
                                    }
                                    break block16;
                                }
                                case 2: {
                                    MPD_Interface.this.log.info((Object)("[JOB] Can not Running " + (n5 + 1) + " processes on " + reservationResult.getNumNodeFound() + " machines that provide only " + (reservationResult.getNumSlotAvailable() + 1) + " slots"));
                                    FoundNodeMessage foundNodeMessage = new FoundNodeMessage(reservationResult.getNumNodeFound(), reservationResult.getNumSlotAvailable() + 1, false);
                                    try {
                                        objectOutputStream = new ObjectOutputStream(outputStream);
                                        objectOutputStream.writeObject(foundNodeMessage);
                                        objectOutputStream.flush();
                                        objectOutputStream.close();
                                        outputStream.close();
                                    }
                                    catch (Exception exception) {
                                        MPD_Interface.this.log.info((Object)exception.toString());
                                    }
                                    break block16;
                                }
                                case 0: {
                                    MPD_Interface.this.log.info((Object)"[JOB] Reservation successful");
                                    FoundNodeMessage foundNodeMessage = new FoundNodeMessage(reservationResult.getNumNodeFound(), reservationResult.getNumSlotAvailable(), true);
                                    try {
                                        objectOutputStream = new ObjectOutputStream(outputStream);
                                        objectOutputStream.writeObject(foundNodeMessage);
                                        objectOutputStream.flush();
                                        objectOutputStream.close();
                                        outputStream.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    Vector<ReservedHost> vector = reservationResult.getReservedHosts();
                                    HostEntry hostEntry = reservationResult.getMyHost();
                                    int n8 = vector.size();
                                    MPDMessage mPDMessage = new MPDMessage(8, string);
                                    mPDMessage.setIP(uRI.getHost(), uRI.getPort());
                                    mPDMessage.setRunCmd(string3);
                                    int n9 = 1;
                                    this.isReserved(string);
                                    MPD_Interface.this.log.info((Object)("->> Try to assign rank to " + n8 + "nodes <---"));
                                    for (int i = 0; i < n8; ++i) {
                                        HostEntry hostEntry2 = vector.elementAt(i).getHostEntry();
                                        int n10 = vector.elementAt(i).getNumUsedSlot();
                                        if (hostEntry2.getIp().equals(hostEntry.getIp())) {
                                            --n10;
                                        }
                                        for (int j = 0; j < n10; ++j) {
                                            if (n9 > n3) {
                                                n9 = 1;
                                            }
                                            MPD_Interface.this.log.info((Object)("Request assign rank " + n9 + " to " + hostEntry2.getIp() + ":" + hostEntry2.getMpdPort()));
                                            mPDMessage.setRank(n9);
                                            MPD_Interface.this.parent.requestPeer(hostEntry2.getIp(), hostEntry2.getMpdPort(), mPDMessage);
                                            ++n9;
                                        }
                                    }
                                    break;
                                }
                            }
                            break;
                        }
                        case 8: {
                            URI uRI = this.msg.getIp();
                            String string = this.msg.getID();
                            String string5 = this.msg.getRunCmd();
                            int n = this.msg.getRank();
                            MPDMessage mPDMessage = null;
                            MPD_Interface.this.log.info((Object)"======= I have a peer request message =======");
                            MPD_Interface.this.log.info((Object)(" ID     = " + string));
                            MPD_Interface.this.log.info((Object)(" myRank = " + n));
                            MPD_Interface.this.log.info((Object)(" URI    = " + uRI.getHost() + ":" + uRI.getPort()));
                            MPD_Interface.this.log.info((Object)(" runCmd = " + string5));
                            MPD_Interface.this.log.info((Object)"==============================================");
                            if (!this.isReserved(string)) {
                                MPD_Interface.this.log.info((Object)"This request has never been reserved before, we can not let it run");
                                break;
                            }
                            this.appInfo = new AppInfo();
                            this.appInfo.setRunCmd(string5);
                            this.appInfo.setRank0(uRI);
                            String string6 = string + "--" + n;
                            MPD_Interface.this.hashTable.put(string6, this.appInfo);
                            mPDMessage = new MPDMessage(9, string);
                            mPDMessage.setFTPort(MPD_Interface.this.parent.ftPort);
                            mPDMessage.setFDPort(MPD_Interface.this.parent.fdPort);
                            mPDMessage.setRank(n);
                            mPDMessage.setMyHost(MPD_Interface.this.parent.usingIP);
                            Socket socket = null;
                            for (int i = 0; i < 10; ++i) {
                                try {
                                    socket = new Socket(uRI.getHost(), uRI.getPort());
                                    outputStream = socket.getOutputStream();
                                    objectOutputStream = new ObjectOutputStream(outputStream);
                                    objectOutputStream.writeObject(mPDMessage);
                                    objectOutputStream.flush();
                                    objectOutputStream.close();
                                    outputStream.close();
                                    socket.close();
                                    break block16;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                            }
                            break block53;
                        }
                        case 6: {
                            String string = this.msg.getID() + "--" + this.msg.getKey();
                            String string7 = this.msg.getJars();
                            this.appInfo = MPD_Interface.this.hashTable.remove(string);
                            URI uRI = this.appInfo.getRank0();
                            MPD_Interface.this.log.info((Object)"Running MPI application");
                            MPD_Interface.this.log.info((Object)("Rank 0 : " + this.appInfo.getRank0().toString()));
                            MPD_Interface.this.log.info((Object)("RunCmd : " + this.appInfo.getRunCmd()));
                            String string8 = OsInfo.getName();
                            try {
                                String string9 = null;
                                String string10 = string7 + " " + uRI.getHost() + " " + uRI.getPort() + " " + this.msg.getID() + " " + this.msg.getKey() + " " + this.appInfo.getRunCmd();
                                string9 = OsInfo.isLinux(string8) || OsInfo.isMacosx(string8) ? "p2pclient " + string10 : (OsInfo.isWindows(string8) ? "p2pclient.bat " + string10 : "p2pclient " + string10);
                                MPD_Interface.this.log.debug((Object)("ExeCmd = " + string9));
                                MPD_Interface.this.log.debug((Object)("RunDir = " + this.msg.getRunDir()));
                                Process process = Runtime.getRuntime().exec(string9, null, this.msg.getRunDir());
                                InputStream inputStream2 = process.getErrorStream();
                                InputStream inputStream3 = process.getInputStream();
                                StreamGobbler streamGobbler = new StreamGobbler(inputStream2, true, uRI.getHost(), uRI.getPort());
                                streamGobbler.start();
                                StreamGobbler streamGobbler2 = new StreamGobbler(inputStream3, true, uRI.getHost(), uRI.getPort());
                                streamGobbler2.start();
                                process.waitFor();
                                inputStream2.close();
                                inputStream3.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        default: {
                            MPD_Interface.this.log.debug((Object)"Unknown Command");
                        }
                    }
                    break block53;
                }
                MPD_Interface.this.log.debug((Object)"***************** Unknown  Messsage *****************");
            }
            try {
                objectInputStream.close();
                inputStream.close();
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
        }
    }
}

