/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.ft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RemoteData {
    private URL url;
    private byte[] data = null;
    private String mimeType = null;

    RemoteData(String string) throws MalformedURLException, IOException {
        this.url = new URL(string);
    }

    public void setMimeType(String string) throws MalformedURLException, IOException {
        URLConnection uRLConnection = this.url.openConnection();
        this.mimeType = uRLConnection.getContentType();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean setContent() throws MalformedURLException, IOException {
        boolean bl;
        URLConnection uRLConnection = this.url.openConnection();
        int n = uRLConnection.getContentLength();
        System.err.println(n);
        if (n >= 0) {
            this.data = new byte[n];
            InputStream inputStream = uRLConnection.getInputStream();
            inputStream.read(this.data, 0, n);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public byte[] getContent() {
        return this.data;
    }

    public void writeToFile(String string) {
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.data);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getMD5Sum() {
        if (this.data == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(this.data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("** [Error] MD5sum is not implemented by the JVM.");
        }
        BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
        return bigInteger.toString(16);
    }

    public static void main(String[] stringArray) throws MalformedURLException, IOException {
        RemoteData remoteData = new RemoteData(stringArray[0]);
        if (remoteData.setContent()) {
            remoteData.writeToFile("./fetched_data");
        } else {
            System.err.println("** [Error] could not fetch contents hosted at " + stringArray[0]);
        }
    }
}

