/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.ft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import p2pmpi.common.OsInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.ft.RemoteData;
import p2pmpi.message.FTMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.RequestQuitMessage;

public class FileTransferServer {
    private int serverPort;
    private int mpdPort;
    private String baseDir;

    public FileTransferServer(int n, int n2, String string) {
        this.serverPort = n;
        this.mpdPort = n2;
        this.baseDir = string;
    }

    public void start() {
        ServerSocket serverSocket = null;
        Socket socket = null;
        try {
            serverSocket = new ServerSocket(this.serverPort);
        }
        catch (Exception exception) {
            System.err.println("** [Error] FT: Can't bind port.");
            exception.printStackTrace();
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    socket = serverSocket.accept();
                    FileTransfer fileTransfer = new FileTransfer(socket);
                    fileTransfer.start();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        FileTransferServer fileTransferServer = new FileTransferServer(p2PMPI_ConfigFile.getFTPort(), p2PMPI_ConfigFile.getMPDPort(), file.toString());
        fileTransferServer.start();
        System.out.println("Starting FT ...");
    }

    public class FileTransfer
    extends Thread {
        Socket socket;

        public FileTransfer(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            Object object = null;
            FTMessage fTMessage = null;
            Socket socket = null;
            try {
                inputStream = this.socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (object instanceof RequestQuitMessage) {
                System.exit(0);
            } else if (object instanceof FTMessage) {
                fTMessage = (FTMessage)object;
                switch (fTMessage.getCmd()) {
                    case 4: {
                        int n = fTMessage.size();
                        OutputStream outputStream = null;
                        ObjectOutputStream objectOutputStream = null;
                        for (int i = 0; i < n; ++i) {
                            FTMessage fTMessage2 = new FTMessage(5, fTMessage.getID());
                            fTMessage2.setKey(fTMessage.getKey(i));
                            fTMessage2.setFileNames(fTMessage.getFileNameList());
                            fTMessage2.setFileContent(fTMessage.getFileNameList());
                            URI uRI = fTMessage.getURI(i);
                            try {
                                socket = new Socket(uRI.getHost(), uRI.getPort());
                                outputStream = socket.getOutputStream();
                                objectOutputStream = new ObjectOutputStream(outputStream);
                                objectOutputStream.writeObject(fTMessage2);
                                objectOutputStream.flush();
                                objectOutputStream.close();
                                outputStream.close();
                                socket.close();
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        break;
                    }
                    case 5: {
                        File file = new File(FileTransferServer.this.baseDir, fTMessage.getID() + "--" + fTMessage.getKey());
                        file.mkdirs();
                        String[] stringArray = fTMessage.getOnlyFileNameList();
                        String string = "";
                        String string2 = OsInfo.getName();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].endsWith(".jar")) {
                                string = string + File.pathSeparator + stringArray[i];
                            }
                            if (stringArray[i].startsWith("http://")) {
                                String[] stringArray2 = stringArray[i].split(File.separator);
                                try {
                                    RemoteData remoteData = new RemoteData(stringArray[i]);
                                    if (remoteData.setContent()) {
                                        System.out.println("md5sum :" + stringArray2[stringArray2.length - 1] + "\t" + remoteData.getMD5Sum());
                                        remoteData.writeToFile(file + File.separator + stringArray2[stringArray2.length - 1]);
                                        continue;
                                    }
                                    System.err.println("** [Error] could not fetch contents hosted at " + stringArray[i]);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                continue;
                            }
                            File file2 = new File(file, stringArray[i]);
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                                fileOutputStream.write(fTMessage.getFileContent(i));
                                fileOutputStream.flush();
                                fileOutputStream.close();
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (string.equals("")) {
                            string = "_";
                        } else if (OsInfo.isWindows(string2)) {
                            string = "_" + string;
                        }
                        MPDMessage mPDMessage = new MPDMessage(6, fTMessage.getID());
                        mPDMessage.setKey(fTMessage.getKey());
                        mPDMessage.setRunDir(file);
                        mPDMessage.setJars(string);
                        try {
                            socket = new Socket("127.0.0.1", FileTransferServer.this.mpdPort);
                            OutputStream outputStream = socket.getOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(mPDMessage);
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                            socket.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        System.err.println("** [Error] FTMessage: Unknown Command.");
                    }
                }
            }
        }
    }
}

