/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;
import java.net.URI;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankTable
implements Serializable {
    private static final long serialVersionUID = 1000004L;
    Vector<TableInfo> table = new Vector();

    public void addProcess(int n, URI uRI, int n2) {
        TableInfo tableInfo = new TableInfo(n, uRI, true, n2);
        this.table.addElement(tableInfo);
    }

    public void addProcess(int n, String string, int n2, int n3) {
        URI uRI = null;
        try {
            uRI = new URI("tcp://" + string + ":" + n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        TableInfo tableInfo = new TableInfo(n, uRI, true, n3);
        this.table.addElement(tableInfo);
    }

    public int size() {
        return this.table.size();
    }

    public String getHost(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getURI().getHost();
    }

    public int getPort(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getURI().getPort();
    }

    public int getFDPort(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getFDPort();
    }

    public int getRank(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.getRank();
    }

    public boolean isAlive(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.isAlive();
    }

    public boolean isTerminated(int n) {
        TableInfo tableInfo = this.table.elementAt(n);
        return tableInfo.isTerminated();
    }

    public void setAlive(int n, boolean bl) {
        TableInfo tableInfo = this.table.elementAt(n);
        tableInfo.setAlive(bl);
    }

    public void setTerminated(int n, boolean bl) {
        TableInfo tableInfo = this.table.elementAt(n);
        tableInfo.setTerminated(bl);
    }

    public URI[] getURIs() {
        int n = this.size();
        URI[] uRIArray = new URI[n];
        for (int i = 0; i < n; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            try {
                uRIArray[i] = new URI(tableInfo.getURI().toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRIArray;
    }

    public URI[] getFDURIs() {
        int n = this.size();
        URI[] uRIArray = new URI[n];
        for (int i = 0; i < n; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            try {
                uRIArray[i] = new URI(tableInfo.getFDURI().toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRIArray;
    }

    public Vector<Integer> getRankInListByRank(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            if (tableInfo.getRank() != n || !tableInfo.isAlive()) continue;
            Integer n3 = new Integer(i);
            vector.addElement(n3);
        }
        return vector;
    }

    public Vector<URI> getURIByRank(int n) {
        Vector<URI> vector = new Vector<URI>();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            TableInfo tableInfo = this.table.elementAt(i);
            if (tableInfo.getRank() != n || !tableInfo.isAlive()) continue;
            vector.addElement(tableInfo.getURI());
        }
        return vector;
    }

    public class TableInfo
    implements Serializable {
        private static final long serialVersionUID = 1000006L;
        int rank;
        URI ip;
        boolean alive;
        int fdPort;
        boolean terminated;

        public TableInfo(int n, URI uRI, boolean bl, int n2) {
            this.rank = n;
            this.ip = uRI;
            this.alive = bl;
            this.terminated = false;
            this.fdPort = n2;
        }

        public void setAlive(boolean bl) {
            this.alive = bl;
        }

        public void setTerminated(boolean bl) {
            this.terminated = bl;
        }

        public void setFDPort(int n) {
            this.fdPort = n;
        }

        public int getFDPort() {
            return this.fdPort;
        }

        public URI getFDURI() {
            URI uRI = null;
            try {
                uRI = new URI("tcp://" + this.ip.getHost() + ":" + this.fdPort);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return uRI;
        }

        public boolean isAlive() {
            return this.alive;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public URI getURI() {
            return this.ip;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

