/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.tools;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;
import p2pmpi.common.JobInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.message.ReplyJobInfoMessage;
import p2pmpi.message.RequestJobInfoMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSStatus {
    public static void display(String string, Vector<JobInfo> vector) {
        System.out.println("Job Information on : " + string + "\n");
        System.out.println("ID\t\t\tStatus");
        if (vector == null) {
            return;
        }
        int n = vector.size();
        block5: for (int i = 0; i < n; ++i) {
            JobInfo jobInfo = vector.elementAt(i);
            System.out.print(jobInfo.getHashID() + "\t\t");
            switch (jobInfo.getStatus()) {
                case 0: {
                    System.out.println("reserved");
                    continue block5;
                }
                case 1: {
                    System.out.println("starting");
                    continue block5;
                }
                case 2: {
                    System.out.println("running");
                }
            }
        }
        System.out.println("\n\nTotal : " + n + " jobs.");
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("P2PMPI_HOME");
        if (string == null) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        int n = p2PMPI_ConfigFile.getRSPort();
        Vector<JobInfo> vector = null;
        try {
            Socket socket = new Socket(stringArray[0], n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            RequestJobInfoMessage requestJobInfoMessage = new RequestJobInfoMessage();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(requestJobInfoMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            ReplyJobInfoMessage replyJobInfoMessage = (ReplyJobInfoMessage)objectInputStream.readObject();
            vector = replyJobInfoMessage.getJobList();
            objectInputStream.close();
            objectOutputStream.close();
            outputStream.close();
            inputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("[Error] : " + exception.toString());
            System.exit(1);
        }
        RSStatus.display(stringArray[0], vector);
    }
}

