/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PeerCache {
    private Document desc = null;
    private static DocumentBuilder docBuilder = null;
    private String id = null;
    private String errorStatus = null;

    public PeerCache() {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("[PeerCache ] Error : cannot create an XML DocumentBuilder for generating MPD advertisement. Exiting.");
            System.exit(1);
        }
        this.desc = docBuilder.newDocument();
        this.desc.setXmlVersion("1.0");
        this.desc.appendChild(this.desc.createElement("peercache"));
    }

    public PeerCache(String string) {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("[PeerCache] Error : cannot create an XML DocumentBuilder for generating MPD advertisement. Exiting.");
            System.exit(1);
        }
        this.desc = PeerCache.readDocument(string);
        if (this.desc != null) {
            NodeList nodeList = this.desc.getDocumentElement().getElementsByTagName("peer");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ((Element)nodeList.item(i)).setIdAttribute("id", true);
            }
        } else {
            this.desc = docBuilder.newDocument();
            this.desc.setXmlVersion("1.0");
            this.desc.appendChild(this.desc.createElement("peercache"));
        }
    }

    public String getErrorStatus() {
        if (this.errorStatus == null) {
            return "No error reported";
        }
        return this.errorStatus;
    }

    public boolean hasId(String string) {
        return this.desc.getElementById(string) != null;
    }

    private boolean addProperty(String string, String string2, String string3) {
        Element element;
        try {
            element = this.desc.createElement(string2);
        }
        catch (DOMException dOMException) {
            return false;
        }
        if (string3 == null) {
            element.setTextContent("n/a");
        } else {
            element.setTextContent(string3);
        }
        Element element2 = this.desc.getElementById(string);
        if (element2 == null) {
            element2 = this.desc.createElement("peer");
            element2.setAttribute("id", string);
            element2.setIdAttribute("id", true);
            this.desc.getFirstChild().appendChild(element2);
        }
        element2.appendChild(element);
        return true;
    }

    private boolean replaceProperty(String string, String string2, String string3) {
        Element element;
        try {
            element = this.desc.createElement(string2);
        }
        catch (DOMException dOMException) {
            return false;
        }
        if (string3 == null) {
            element.setTextContent("n/a");
        } else {
            element.setTextContent(string3);
        }
        Element element2 = this.desc.getElementById(string);
        if (element2 == null) {
            element2 = this.desc.createElement("peer");
            element2.setAttribute("id", string);
            element2.setIdAttribute("id", true);
            this.desc.getFirstChild().appendChild(element2);
        } else {
            NodeList nodeList = element2.getElementsByTagName(string2);
            int n = nodeList.getLength();
            if (n > 0) {
                Node node = nodeList.item(0).getParentNode();
                for (int i = 0; i < n; ++i) {
                    node.removeChild(nodeList.item(i));
                }
            }
        }
        element2.appendChild(element);
        return true;
    }

    public boolean setMpdVer(String string, String string2) {
        return this.replaceProperty(string, "mpdver", string2);
    }

    public boolean setCpuName(String string, String string2) {
        return this.replaceProperty(string, "cpu", string2);
    }

    public boolean setCpuFreq(String string, String string2) {
        return this.replaceProperty(string, "cpufreq", string2);
    }

    public boolean setArch(String string, String string2) {
        return this.replaceProperty(string, "arch", string2);
    }

    public boolean setOsName(String string, String string2) {
        return this.replaceProperty(string, "osname", string2);
    }

    public boolean setMem(String string, String string2) {
        return this.replaceProperty(string, "mem", string2);
    }

    public boolean setFdPort(String string, String string2) {
        return this.replaceProperty(string, "fdport", string2);
    }

    public boolean setFtPort(String string, String string2) {
        return this.replaceProperty(string, "ftport", string2);
    }

    public boolean setRsPort(String string, String string2) {
        return this.replaceProperty(string, "rsport", string2);
    }

    public boolean setMpdPort(String string, String string2) {
        return this.replaceProperty(string, "mpdport", string2);
    }

    private String getProperty(String string, String string2) {
        Element element = this.desc.getElementById(string);
        if (element == null) {
            System.err.println("Invalid id in getProperty(" + string + "," + string2 + ")");
            return null;
        }
        Node node = element.getElementsByTagName(string2).item(0);
        Node node2 = node.getFirstChild();
        if (node2.getNodeType() != 3) {
            return new String("undefined");
        }
        return node2.getNodeValue();
    }

    public String getMpdVer(String string) {
        return this.getProperty(string, "mpdver");
    }

    public String getCpuName(String string) {
        return this.getProperty(string, "cpu");
    }

    public String getCpuFreq(String string) {
        return this.getProperty(string, "cpufreq");
    }

    public String getArch(String string) {
        return this.getProperty(string, "arch");
    }

    public String getOsName(String string) {
        return this.getProperty(string, "osname");
    }

    public String getMem(String string) {
        return this.getProperty(string, "mem");
    }

    public String getFdPort(String string) {
        return this.getProperty(string, "fdport");
    }

    public String getFtPort(String string) {
        return this.getProperty(string, "ftport");
    }

    public String getRsPort(String string) {
        return this.getProperty(string, "rsport");
    }

    public String getMpdPort(String string) {
        return this.getProperty(string, "mpdport");
    }

    public boolean remove(String string) {
        Element element = this.desc.getElementById(string);
        if (element == null) {
            return false;
        }
        Node node = element.getParentNode();
        Node node2 = node.removeChild(element);
        return true;
    }

    public boolean saveDocument(String string) {
        DOMSource dOMSource = new DOMSource(this.desc);
        StreamResult streamResult = new StreamResult(new File(string));
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.errorStatus = "Warning : can not create an XML transformer during file saving: " + transformerConfigurationException.getCause();
            System.err.println(this.errorStatus);
            return false;
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            this.errorStatus = "Could not perform saving. Reason :" + transformerException.getCause();
            System.err.println(this.errorStatus);
            return false;
        }
        return true;
    }

    private static Document readDocument(String string) {
        try {
            return docBuilder.parse(new File(string));
        }
        catch (SAXException sAXException) {
            System.err.println("[PeerCache] Warning : cannot parse " + string);
        }
        catch (IOException iOException) {
            System.err.println("[PeerCache] Warning : no cache file " + string);
        }
        return null;
    }

    public void display() {
        PeerCache.displayDocument(this.desc);
    }

    private static void displayDocument(Document document) {
        Element element = document.getDocumentElement();
        PeerCache.displayElement(element);
    }

    private static void displayElement(Element element) {
        Object object;
        System.out.print("<" + element.getNodeName() + " ");
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = (Attr)namedNodeMap.item(i);
            System.out.print(object.getName() + "=\"" + object.getNodeValue() + "\" ");
        }
        System.out.println(">");
        block5: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    PeerCache.displayElement((Element)node);
                    continue block5;
                }
                case 3: {
                    object = ((Text)node).getData();
                    System.out.println((String)object);
                }
            }
        }
        System.out.println("</" + element.getNodeName() + ">");
    }

    public static void main(String[] stringArray) {
        PeerCache peerCache = new PeerCache();
        String string = new String("130.79.192.166");
        String string2 = new String("130.79.192.167");
        System.out.println("----------adding properties for peer id=" + string + "----------------------------");
        if (peerCache.setCpuName(string, "Intel xeon")) {
            System.out.println("\t* setCpuName(" + string + ",intel xeon) : ok");
        }
        if (peerCache.setCpuFreq(string, "2345 MHz")) {
            System.out.println("\t* setCpuFreq(" + string + ",2345 MHz) : ok");
        }
        if (peerCache.setFtPort(string, "9801")) {
            System.out.println("\t* setFtPort(" + string + ", 9801) : ok");
        }
        if (peerCache.setMem(string, "512 MB")) {
            System.out.println("\t* setMem(" + string + ", 512 MB) : ok");
        }
        System.out.println("----------saving peer id=" + string + " under a.xml----------------------------");
        peerCache.saveDocument("a.xml");
        System.out.println("----------reading a.xml to a new Cache----------------------------");
        PeerCache peerCache2 = new PeerCache("a.xml");
        System.out.println("\t* getCpuName(" + string + ") : " + peerCache2.getCpuName(string));
        System.out.println("----------adding a property for a new peer id=" + string2 + "-----------------------------");
        if (peerCache2.setOsName(string2, "linux")) {
            System.out.println("setOsName(" + string2 + ",linux) : ok");
        }
        if (peerCache2.setMem(string, "574 MB")) {
            System.out.println("\t* setMem(" + string + ", 574 MB) : should override previous value : ok");
        }
        System.out.println("----------displaying Cache (DOM document in memory)-----------------------------");
        peerCache2.display();
        System.out.println("----------saving Cache under b.xml----------------------------");
        peerCache2.saveDocument("b.xml");
    }
}

