/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.HostEntry;
import p2pmpi.common.NameGenerator;
import p2pmpi.common.NetIface;
import p2pmpi.common.OsInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.ProcessTable;
import p2pmpi.common.ReservationResult;
import p2pmpi.common.ReservedHost;
import p2pmpi.common.Version;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.mpd.MPD_Interface;
import p2pmpi.mpd.P2PMPI_MPDPeer;
import p2pmpi.mpd.PeerCache;
import p2pmpi.p2p.PeerKeepAlive;
import p2pmpi.p2p.PeerUpdateList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PMPI_MPD
extends P2PMPI_MPDPeer {
    int jxtaMinPort;
    int jxtaMaxPort;
    int jxtaCurrentPort;
    int numCPU;
    Properties confProps;
    long startBOOT = System.currentTimeMillis();
    long stopBOOT;
    protected ProcessTable procTab = null;
    URI superNode;
    URI myURI;

    public P2PMPI_MPD(int n, int n2, int n3, int n4, int n5, String string, Properties properties, String string2, String string3, int n6, int n7, int n8, URI uRI, String string4) {
        log = Logger.getLogger((String)"MPD");
        this.mpdPort = n;
        this.fdPort = n2;
        this.ftPort = n3;
        this.rsPort = n7;
        this.runPath = new File(string, this.getUniqueDirName());
        this.jxtaMinPort = n4;
        this.jxtaMaxPort = n5;
        this.confProps = properties;
        this.numCPU = n8;
        this.superNode = uRI;
        log.info((Object)("[MPD] ** Starting MPD " + Version.MAINVERSION + "." + Version.SUBVERSION + " **"));
        this.peerCacheFile = string4 != null ? string4 : new String(this.tmpDir + System.getProperty("path.separator") + "cache.xml");
        NetIface netIface = new NetIface();
        this.usingIP = netIface.getExternalIfIpv4();
        if (this.usingIP == null) {
            log.error((Object)"Could not determine a working network interface. Exiting.");
            System.exit(1);
        }
        log.info((Object)("[MPD] Network status: using " + netIface.getIfName() + " ip=" + this.usingIP));
        try {
            this.myURI = new URI("tcp://" + this.usingIP + ":" + n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numProcPerJob = n6;
        this.jxtaCurrentPort = n4;
        this.tmpDir = new String(string);
        this.procTab = new ProcessTable();
        this.myHost = new HostEntry(this.usingIP, n, n2, n3, n7, n6);
        this.createCacheEntry(this.usingIP);
    }

    protected void createCacheEntry(String string) {
        PeerCache peerCache = new PeerCache(this.peerCacheFile);
        String string2 = new String(string + ":" + this.mpdPort);
        peerCache.remove(string2);
        peerCache.setMpdVer(string2, Version.MAINVERSION + "." + Version.SUBVERSION);
        peerCache.setOsName(string2, System.getProperty("os.name"));
        peerCache.setArch(string2, System.getProperty("os.arch"));
        peerCache.setMpdPort(string2, Integer.toString(this.mpdPort));
        peerCache.setFdPort(string2, Integer.toString(this.fdPort));
        peerCache.setFtPort(string2, Integer.toString(this.ftPort));
        String[] stringArray = OsInfo.cpuInfo();
        String[] stringArray2 = OsInfo.memInfo();
        if (stringArray == null) {
            peerCache.setCpuName(string2, "N/A");
            peerCache.setCpuFreq(string2, "N/A");
        } else {
            peerCache.setCpuName(string2, stringArray[0]);
            peerCache.setCpuFreq(string2, stringArray[1]);
        }
        if (stringArray2 == null) {
            peerCache.setMem(string2, "N/A");
        } else {
            peerCache.setMem(string2, stringArray2[0]);
        }
        if (peerCache.saveDocument(this.peerCacheFile)) {
            log.info((Object)("[MPD] Entry created in cache " + this.peerCacheFile + " with id=" + string2));
        } else {
            log.info((Object)("[MPD] Cache entry not created. Reason: " + peerCache.getErrorStatus()));
        }
    }

    protected synchronized String getUniqueDirName() {
        return new String(NameGenerator.getUniqueName());
    }

    protected synchronized int getJxtaPort() {
        ServerSocket serverSocket = null;
        for (int i = 0; i < 2; ++i) {
            for (int j = this.jxtaCurrentPort; j <= this.jxtaMaxPort; ++j) {
                try {
                    serverSocket = new ServerSocket(j);
                    serverSocket.close();
                    this.jxtaCurrentPort = j + 1;
                    return j;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            this.jxtaCurrentPort = this.jxtaMinPort;
        }
        return -1;
    }

    protected synchronized void requestPeer(String string, int n, MPDMessage mPDMessage) {
        try {
            Socket socket = new Socket(string, n);
            log.info((Object)("Assign Rank " + mPDMessage.getRank() + ": to IP:" + string));
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(mPDMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.info((Object)("Reqpeer: Fail " + exception.toString()));
        }
    }

    protected void cancelReservation(String string, Vector<HostEntry> vector) {
        if (vector.size() == 0) {
            return;
        }
        try {
            RSMessage rSMessage = new RSMessage(5, string, this.usingIP, Version.MAINVERSION + "." + Version.SUBVERSION);
            rSMessage.setList(vector);
            Socket socket = new Socket("127.0.0.1", this.rsPort);
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(rSMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.info((Object)("[MPD] Error: could not contact RS to cancel reservation " + string));
        }
    }

    protected boolean isMyHost(HostEntry hostEntry) {
        return hostEntry.getIp().equals(this.myHost.getIp());
    }

    protected ReservationResult searchMPD(String string, int n, int n2, int n3, String string2) {
        int n4;
        int n5;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable2;
        Object object4;
        int n6;
        Serializable serializable3;
        int n7 = n * n2;
        int n8 = n2;
        int n9 = n7 + (int)(3.0 * (Math.log(n7) / Math.log(2.0)));
        Vector<HostEntry> vector = new Vector<HostEntry>();
        log.info((Object)("[MPD] entering searchMPD (n=" + n + ",r=" + n2 + ")"));
        long l = System.currentTimeMillis();
        while (true) {
            int n10;
            serializable3 = new ArrayList(this.hostCache.entrySet());
            Collections.sort(serializable3, new Comparator(){

                public int compare(Object object, Object object2) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    int n = ((HostEntry)entry.getValue()).getRtt();
                    int n2 = ((HostEntry)entry2.getValue()).getRtt();
                    return n - n2;
                }
            });
            n6 = 0;
            object4 = ((ArrayList)serializable3).iterator();
            while (object4.hasNext()) {
                serializable2 = (HostEntry)object4.next().getValue();
                if (!((HostEntry)serializable2).isAlive()) continue;
                vector.add((HostEntry)serializable2);
                if (++n6 < n9) continue;
                break;
            }
            if (n6 >= n7 || (n10 = (int)(System.currentTimeMillis() - l)) >= n3 * 1000) break;
            vector.clear();
            this.updateHostCache(this.superNode);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        log.info((Object)("[MPD] number of hosts required: min=" + n8 + ",max=" + n7 + ",found =" + n6));
        if (n6 < n8 - 1) {
            ReservationResult reservationResult = new ReservationResult(null, 1, n6 + 1, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        serializable3 = new RSMessage(0, string, this.usingIP, Version.MAINVERSION + "." + Version.SUBVERSION);
        ((RSMessage)serializable3).setReservePeriod(30000 + n * n2 * 1000);
        ((RSMessage)serializable3).setList(vector);
        object4 = null;
        serializable2 = null;
        try {
            Socket socket = new Socket("127.0.0.1", this.rsPort);
            object3 = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            object2 = new ObjectOutputStream(outputStream);
            ((ObjectOutputStream)object2).writeObject(serializable3);
            ((ObjectOutputStream)object2).flush();
            object = new ObjectInputStream((InputStream)object3);
            Object object5 = ((ObjectInputStream)object).readObject();
            serializable = (RSMessage)object5;
            object4 = ((RSMessage)serializable).getList();
            serializable2 = ((RSMessage)serializable).getDeadList();
            ((ObjectInputStream)object).close();
            ((ObjectOutputStream)object2).close();
            ((InputStream)object3).close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.error((Object)("[MPD] Error connecting to local RS (127.0.0.1:" + this.rsPort + ") : " + exception.toString()));
        }
        int n11 = ((Vector)serializable2).size();
        object3 = "";
        for (n5 = 0; n5 < n11; ++n5) {
            object2 = (HostEntry)((Vector)serializable2).elementAt(n5);
            object = ((HostEntry)object2).toString();
            object3 = (String)object3 + ((HostEntry)object2).getIp() + " ";
            ((HostEntry)this.hostCache.get(object)).setAlive(false);
        }
        log.info((Object)("[MPD] result from RS reservation request: " + ((Vector)object4).size() + " reserved hosts , " + ((Vector)serializable2).size() + " unreachable RS."));
        for (n5 = 0; n5 < ((Vector)object4).size(); ++n5) {
            object2 = (HostEntry)((Vector)object4).elementAt(n5);
            log.info((Object)("[MPD] reserved : " + ((HostEntry)object2).getIp()));
        }
        if (((Vector)serializable2).size() > 0) {
            log.info((Object)("[MPD] unreachable RS: " + (String)object3));
        }
        n5 = ((Vector)object4).size();
        boolean bl = false;
        ((Vector)object4).add(0, this.myHost);
        bl = true;
        log.debug((Object)("[MPD] Total of " + ++n5 + " reserved nodes"));
        if (n5 < n8) {
            ((Vector)object4).remove(0);
            this.cancelReservation(string, (Vector<HostEntry>)object4);
            ReservationResult reservationResult = new ReservationResult(null, 1, n5, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        int n12 = 0;
        for (int i = 0; i < n5; ++i) {
            serializable = (HostEntry)((Vector)object4).elementAt(i);
            int n13 = ((HostEntry)serializable).getNumProcPerJob();
            if (this.isMyHost((HostEntry)serializable)) {
                --n13;
            }
            if (n13 > n) {
                n12 += n;
                continue;
            }
            n12 += n13;
        }
        if (n12 < n7) {
            ((Vector)object4).remove(0);
            this.cancelReservation(string, (Vector<HostEntry>)object4);
            ReservationResult reservationResult = new ReservationResult(null, 2, n5, n12);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        if (bl) {
            ++n7;
            ++n;
        }
        if (string2.equalsIgnoreCase("spread")) {
            HostEntry hostEntry;
            int n14;
            Vector<ReservedHost> vector2 = new Vector<ReservedHost>();
            serializable = new Vector();
            int n15 = 0;
            int n16 = n5;
            int[] nArray = new int[n5];
            boolean bl2 = false;
            block9: do {
                for (n14 = 0; n14 < n16; ++n14) {
                    hostEntry = (HostEntry)((Vector)object4).elementAt(n14);
                    if (n15 >= n7) {
                        bl2 = true;
                        continue block9;
                    }
                    int n17 = hostEntry.getNumProcPerJob();
                    if (nArray[n14] >= n17 || nArray[n14] >= n) continue;
                    ++n15;
                    int n18 = n14;
                    nArray[n18] = nArray[n18] + 1;
                }
            } while (!bl2);
            for (n14 = 0; n14 < n16; ++n14) {
                hostEntry = (HostEntry)((Vector)object4).elementAt(n14);
                if (nArray[n14] == 0) {
                    ((Vector)serializable).add(hostEntry);
                    log.info((Object)("[Scatter]->" + hostEntry.getIp() + " (not used)"));
                    continue;
                }
                log.info((Object)("[Scatter]->" + hostEntry.getIp()));
                ReservedHost reservedHost = new ReservedHost(hostEntry, nArray[n14]);
                vector2.add(reservedHost);
            }
            this.cancelReservation(string, (Vector<HostEntry>)serializable);
            n14 = vector2.size();
            log.info((Object)("usedHostSize = " + n14));
            if (!bl) {
                ++n14;
            }
            ReservationResult reservationResult = new ReservationResult(vector2, 0, n14, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        Vector<ReservedHost> vector3 = new Vector<ReservedHost>();
        serializable = new Vector();
        int n19 = 0;
        int n20 = n5;
        int n21 = this.myHost.getNumProcPerJob();
        int n22 = n21 < n ? (n21 > n7 ? n7 : n21) : n;
        ReservedHost reservedHost = new ReservedHost(this.myHost, n22);
        vector3.add(reservedHost);
        n19 += n22;
        for (n4 = 0; n4 < n20; ++n4) {
            HostEntry hostEntry = (HostEntry)((Vector)object4).elementAt(n4);
            log.info((Object)("[Gather]->" + hostEntry.getIp()));
            if (this.isMyHost(hostEntry)) continue;
            if (n19 >= n7) {
                ((Vector)serializable).add(hostEntry);
                continue;
            }
            n21 = hostEntry.getNumProcPerJob();
            n22 = n21 < n ? (n19 + n21 > n7 ? n7 - n19 : n21) : (n19 + n > n7 ? n7 - n19 : n);
            reservedHost = new ReservedHost(hostEntry, n22);
            vector3.add(reservedHost);
            n19 += n22;
        }
        this.cancelReservation(string, (Vector<HostEntry>)serializable);
        n4 = vector3.size();
        if (!bl) {
            ++n4;
        }
        ReservationResult reservationResult = new ReservationResult(vector3, 0, n4, 0);
        reservationResult.setMyHost(this.myHost);
        return reservationResult;
    }

    @Override
    public void run() {
        if (!this.joinMpiGroup(this.superNode)) {
            System.err.println("** [MPD Error] : could not contact SuperNode at " + this.superNode.toString() + ". Exiting.");
            log.info((Object)("[MPD Error]: could not contact SuperNode at " + this.superNode.toString() + ". Exiting."));
            System.exit(1);
        }
        MPD_Interface mPD_Interface = new MPD_Interface(this);
        mPD_Interface.start();
        this.updateHostCache(this.superNode);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new PeerKeepAlive(this.superNode, this.myHost), 0L, 180000L);
        Timer timer2 = new Timer();
        timer2.schedule((TimerTask)new PeerUpdateList(this.superNode, this.myHost, this.hostCache), 0L, 300000L);
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(log);
        P2PMPI_MPD p2PMPI_MPD = new P2PMPI_MPD(p2PMPI_ConfigFile.getMPDPort(), p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getFTPort(), p2PMPI_ConfigFile.getMinPort(), p2PMPI_ConfigFile.getMaxPort(), file.toString(), p2PMPI_ConfigFile.getProperties(), p2PMPI_ConfigFile.getHostDeny(), p2PMPI_ConfigFile.getHostAllow(), p2PMPI_ConfigFile.getNumProcPerJob(), p2PMPI_ConfigFile.getRSPort(), p2PMPI_ConfigFile.getNumCPU(), p2PMPI_ConfigFile.getSuperNode(), p2PMPI_ConfigFile.getPeerCacheFile());
        p2PMPI_MPD.start();
    }
}

