/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.fd;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import p2pmpi.common.GossipConfig;
import p2pmpi.message.AliveMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.GossipPingReplyMessage;
import p2pmpi.message.IsAliveMessage;
import p2pmpi.message.NoAliveMessage;
import p2pmpi.message.NotifyMessage;

public abstract class GossipDetector
implements Runnable {
    protected int myMPIRank;
    protected int myRank;
    protected int mpdPort;
    protected String hashID;
    protected int mpiPort;
    protected URI[] uriList;
    protected boolean[] aliveList;
    protected long[] heartbeatList;
    protected int numPeers;
    protected long T_GOSSIP;
    protected long T_MARGIN;
    protected long T_MAX_HANG;
    protected long T_CLEANUP;
    protected long T_MIN_CLEANUP;
    protected Timer timer;
    protected Timer aliveTimer;
    protected volatile boolean alive = true;
    protected static Logger log;
    protected long t_stamp;
    protected int t_diff;

    public GossipDetector(int n, String string, int n2, URI[] uRIArray, int n3, int n4, int n5, int n6, int n7, long l, int n8) {
        this.myMPIRank = n4;
        this.myRank = n;
        this.hashID = string;
        this.mpiPort = n2;
        this.uriList = uRIArray;
        this.mpdPort = n3;
        this.t_stamp = l;
        this.t_diff = n7;
        log = Logger.getLogger((String)"MPD");
        this.T_GOSSIP = n5;
        this.T_MAX_HANG = n8;
        this.numPeers = uRIArray.length;
        this.T_MARGIN = (long)Math.ceil((double)n6 / (double)n5);
        this.aliveList = new boolean[this.numPeers];
        this.heartbeatList = new long[this.numPeers];
        for (int i = 0; i < this.numPeers; ++i) {
            this.aliveList[i] = true;
            this.heartbeatList[i] = 0L;
        }
        this.timer = new Timer();
        this.aliveTimer = new Timer();
    }

    public void stop() {
        this.timer.cancel();
        this.aliveTimer.cancel();
        log.info((Object)("[GossipDetector] *** Stop gossip for hashID =" + this.hashID + " and myRank = " + this.myRank));
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void run() {
        long l;
        this.heartbeatList[this.myRank] = l = (long)Math.ceil((double)(System.currentTimeMillis() - this.t_stamp + (long)this.t_diff) / (double)this.T_GOSSIP);
        log.debug((Object)("[GossipDetector] *** Start gossip for hashID =" + this.hashID + " and myRank = " + this.myRank));
        log.debug((Object)("[GossipDetector] T_CLEANUP = " + this.T_CLEANUP + "rounds, T_MARGIN = " + this.T_MARGIN + "rounds"));
        log.debug((Object)("[GossipDetector] rank: " + this.myRank + "-> startHeartBeat = " + l));
        log.debug((Object)("[GossipDetector] rank: " + this.myRank + "-> currentime = " + System.currentTimeMillis() + ", t_stamp = " + this.t_stamp + ", t_diff " + this.t_diff));
        this.timer.scheduleAtFixedRate((TimerTask)new DoGossip(), 0L, this.T_GOSSIP);
        this.aliveTimer.scheduleAtFixedRate((TimerTask)new CheckAlive(), 0L, (long)GossipConfig.t_appalive);
    }

    public int getMyRank() {
        return this.myRank;
    }

    public long getCurrentHeartBeat() {
        return this.heartbeatList[this.myRank];
    }

    public void mergeDestination(int n, long l) {
        if (this.heartbeatList[n] < l) {
            this.heartbeatList[n] = l;
        }
    }

    public void merge(long[] lArray) {
        if (lArray == null) {
            return;
        }
        for (int i = 0; i < this.numPeers; ++i) {
            if (this.heartbeatList[i] >= lArray[i]) continue;
            this.heartbeatList[i] = lArray[i];
        }
    }

    public boolean ping(int n) {
        String string = this.uriList[n].getHost();
        int n2 = this.uriList[n].getPort();
        GossipMessage gossipMessage = new GossipMessage(13, this.hashID);
        gossipMessage.setToRank(n);
        gossipMessage.setHeartBeatList(this.heartbeatList);
        log.info((Object)("[GossipDetector] suspected :" + n + ", sending ping message to " + string));
        try {
            Socket socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
            socket.connect(inetSocketAddress, 500);
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(gossipMessage);
            objectOutputStream.flush();
            InputStream inputStream = socket.getInputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
            if (object instanceof GossipPingReplyMessage) {
                long l = ((GossipPingReplyMessage)object).getCurrentHeartBeat();
                if (l < 0L) {
                    return false;
                }
                this.mergeDestination(n, l);
                log.info((Object)("[GossipDetector] suspected  node:" + n + "[" + string + "] reply with heartbeat->" + l));
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            log.info((Object)("[GossipDetector] can't connect suspected node :" + n));
            return false;
        }
    }

    public abstract int getNextDestination(int var1);

    public class DoGossip
    extends TimerTask {
        int currentStep = 0;

        DoGossip() {
        }

        public void run() {
            Object object;
            Object object2;
            int n;
            int n2 = GossipDetector.this.myRank;
            GossipDetector.this.heartbeatList[n2] = GossipDetector.this.heartbeatList[n2] + 1L;
            for (n = 0; n < GossipDetector.this.numPeers; ++n) {
                long l;
                if (!GossipDetector.this.aliveList[n] || (l = GossipDetector.this.heartbeatList[GossipDetector.this.myRank] - GossipDetector.this.heartbeatList[n]) <= GossipDetector.this.T_CLEANUP || GossipDetector.this.heartbeatList[n] == 0L && l < GossipDetector.this.T_CLEANUP + GossipDetector.this.T_MARGIN || GossipDetector.this.ping(n)) continue;
                GossipDetector.this.aliveList[n] = false;
                log.info((Object)("**** [GossipDetector] Detection failure of " + n + "th node in list"));
                NotifyMessage notifyMessage = new NotifyMessage(n);
                try {
                    object2 = new Socket("127.0.0.1", GossipDetector.this.mpiPort);
                    OutputStream outputStream = ((Socket)object2).getOutputStream();
                    object = new ObjectOutputStream(outputStream);
                    ((ObjectOutputStream)object).writeObject(notifyMessage);
                    ((ObjectOutputStream)object).close();
                    outputStream.close();
                    ((Socket)object2).close();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            n = GossipDetector.this.getNextDestination(this.currentStep);
            int n3 = 0;
            while (!(GossipDetector.this.aliveList[n = (n + n3) % GossipDetector.this.numPeers] && n != GossipDetector.this.myRank || ++n3 > GossipDetector.this.numPeers - 1)) {
            }
            object2 = GossipDetector.this.uriList[n].getHost();
            int n4 = GossipDetector.this.uriList[n].getPort();
            object = new GossipMessage(1, GossipDetector.this.hashID);
            ((GossipMessage)object).setMyRank(GossipDetector.this.myRank);
            ((GossipMessage)object).setToRank(n);
            ((GossipMessage)object).setHeartBeatList(GossipDetector.this.heartbeatList);
            try {
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress((String)object2, n4);
                socket.connect(inetSocketAddress, 500);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.currentStep;
            if ((long)this.currentStep >= GossipDetector.this.T_MIN_CLEANUP) {
                this.currentStep = 0;
            }
        }
    }

    public class CheckAlive
    extends TimerTask {
        private void warnMPD() {
            try {
                log.info((Object)("[GossipDetector:" + GossipDetector.this.hashID + ":" + GossipDetector.this.myRank + "] detect application dead so unregister it to MPD at port " + GossipDetector.this.mpdPort));
                AppUnregisterMessage appUnregisterMessage = new AppUnregisterMessage(GossipDetector.this.hashID + "--" + GossipDetector.this.myMPIRank);
                Socket socket = new Socket("127.0.0.1", GossipDetector.this.mpdPort);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appUnregisterMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                log.info((Object)("[GossipDetector]: Error unregistry to MPD (" + exception.toString() + ")"));
            }
        }

        public void run() {
            try {
                IsAliveMessage isAliveMessage = new IsAliveMessage(GossipDetector.this.hashID);
                Socket socket = new Socket("127.0.0.1", GossipDetector.this.mpiPort);
                OutputStream outputStream = socket.getOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(isAliveMessage);
                InputStream inputStream = socket.getInputStream();
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (object instanceof AliveMessage) {
                    AliveMessage aliveMessage = (AliveMessage)object;
                    if (!GossipDetector.this.hashID.equals(aliveMessage.getKey())) {
                        GossipDetector.this.alive = false;
                        GossipDetector.this.aliveTimer.cancel();
                        GossipDetector.this.timer.cancel();
                        this.warnMPD();
                    }
                } else if (object instanceof NoAliveMessage) {
                    GossipDetector.this.alive = false;
                    GossipDetector.this.aliveTimer.cancel();
                    GossipDetector.this.timer.cancel();
                    this.warnMPD();
                }
            }
            catch (Exception exception) {
                log.info((Object)"[GossipDetector]: *** MPI application crashed ***");
                GossipDetector.this.alive = false;
                GossipDetector.this.aliveTimer.cancel();
                GossipDetector.this.timer.cancel();
                this.warnMPD();
            }
        }
    }
}

