/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import p2pmpi.common.P2PMPI_ConfigFile;

public class NetIface {
    private String ifname = null;
    private String extIfIpv4Address = null;
    private String extIfIpv6Address = null;
    private String canonicalHostName = null;

    public NetIface() {
        NetworkInterface networkInterface = null;
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        String string = p2PMPI_ConfigFile.getExternalIP();
        if (string != null) {
            this.ifname = "eth0";
            this.extIfIpv6Address = "/undefined";
            this.extIfIpv4Address = "/" + string;
        } else {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    networkInterface = enumeration.nextElement();
                    InetAddress inetAddress = null;
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        inetAddress = enumeration2.nextElement();
                        byte[] byArray = inetAddress.getAddress();
                        if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress()) continue;
                        this.ifname = networkInterface.getDisplayName();
                        this.canonicalHostName = inetAddress.getCanonicalHostName();
                        if (NetIface.isIPv4Address(byArray)) {
                            this.extIfIpv4Address = inetAddress.toString();
                            continue;
                        }
                        this.extIfIpv6Address = inetAddress.toString();
                    }
                }
            }
            catch (SocketException socketException) {
                System.err.println("[Error] cannot determine network interfaces.");
            }
        }
    }

    private String splitStringAddress(String string) {
        String[] stringArray = string.split("/", 2);
        if (stringArray[0].length() > 0) {
            return stringArray[0];
        }
        return stringArray[1];
    }

    public String getIfName() {
        return this.ifname;
    }

    public String getExternalIfIpv4() {
        if (this.extIfIpv4Address == null) {
            return null;
        }
        return this.splitStringAddress(this.extIfIpv4Address);
    }

    public String getExternalIfIpv6() {
        if (this.extIfIpv6Address == null) {
            return null;
        }
        return this.splitStringAddress(this.extIfIpv6Address);
    }

    public String getCanonicalHostName() {
        return this.canonicalHostName;
    }

    private static boolean isIPv4Address(byte[] byArray) {
        return byArray.length == 4;
    }

    public static void main(String[] stringArray) {
        NetIface netIface = new NetIface();
        System.out.println("selected interface: " + netIface.getIfName() + ": ipv4=" + netIface.getExternalIfIpv4() + "  ipv6=" + netIface.getExternalIfIpv6());
    }
}

