/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.Serializable;

public class HostEntry
implements Serializable {
    private static final long serialVersionUID = 1000002L;
    String ip;
    int fdPort;
    int ftPort;
    int mpdPort;
    int rsPort;
    int numProcPerJob;
    boolean alive;
    int rtt;
    long lastUpdate;

    public HostEntry(String string, int n, int n2, int n3, int n4, int n5) {
        this.ip = string;
        this.mpdPort = n;
        this.fdPort = n2;
        this.ftPort = n3;
        this.rsPort = n4;
        this.alive = true;
        this.rtt = Integer.MAX_VALUE;
        this.numProcPerJob = n5;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setLastUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public void setFdPort(int n) {
        this.fdPort = n;
    }

    public void setFtPort(int n) {
        this.ftPort = n;
    }

    public void setMpdPort(int n) {
        this.mpdPort = n;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public void setRtt(int n) {
        if (n < this.rtt) {
            this.rtt = n;
        }
    }

    public void setNumProcPerJob(int n) {
        this.numProcPerJob = n;
    }

    public String getIp() {
        return this.ip;
    }

    public int getFdPort() {
        return this.fdPort;
    }

    public int getFtPort() {
        return this.ftPort;
    }

    public int getMpdPort() {
        return this.mpdPort;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public int getRtt() {
        return this.rtt;
    }

    public int getNumProcPerJob() {
        return this.numProcPerJob;
    }

    public long getLastUpdate() {
        return System.currentTimeMillis() - this.lastUpdate;
    }

    public boolean isUpdate() {
        return System.currentTimeMillis() - this.lastUpdate < 240000L;
    }

    public int getRsPort() {
        return this.rsPort;
    }

    public String toString() {
        return this.ip + ":" + this.mpdPort + ":" + this.fdPort + ":" + this.ftPort + ":" + this.rsPort + ":" + this.numProcPerJob;
    }
}

