/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.TGForEachNodePair;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GraphEltSet
implements ImmutableGraphEltSet {
    protected Vector nodes = new Vector();
    protected Vector edges = new Vector();
    protected Hashtable nodeIDRegistry = new Hashtable();

    protected Node nodeAt(int n) {
        if (this.nodes.size() == 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(n);
    }

    public int nodeNum() {
        return this.nodes.size();
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public Iterator getNodes() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNode(Node node) throws TGException {
        String string = node.getID();
        if (string != null) {
            if (this.findNode(string) != null) throw new TGException(1, "node ID '" + string + "' already exists.");
            this.nodeIDRegistry.put(string, node);
            this.nodes.addElement(node);
            return;
        } else {
            String string2 = node.getLabel().trim();
            if (string2 == null) {
                string2 = "";
            }
            if (!string2.equals("") && this.findNode(node.getLabel()) == null) {
                string = string2;
            } else {
                int n = 1;
                while (this.findNode(string2 + "-" + n) != null) {
                    ++n;
                }
                string = string2 + "-" + n;
            }
            node.setID(string);
            this.nodeIDRegistry.put(string, node);
            this.nodes.addElement(node);
        }
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    protected Edge edgeAt(int n) {
        if (this.edges.size() == 0) {
            return null;
        }
        return (Edge)this.edges.elementAt(n);
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public int edgeCount() {
        return this.edges.size();
    }

    public Iterator getEdges() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.iterator();
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (!this.contains(edge)) {
            this.edges.addElement(edge);
            edge.from.addEdge(edge);
            edge.to.addEdge(edge);
        }
    }

    public Edge addEdge(Node node, Node node2, int n) {
        Edge edge = null;
        if (node != null && node2 != null) {
            edge = new Edge(node, node2, n);
            this.addEdge(edge);
        }
        return edge;
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    public Node findNode(String string) {
        if (string == null) {
            return null;
        }
        return (Node)this.nodeIDRegistry.get(string);
    }

    public Collection findNodesByLabel(String string) {
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < this.nodeCount(); ++i) {
            if (this.nodeAt(i) == null || !this.nodeAt(i).getLabel().equals(string)) continue;
            vector.add(this.nodeAt(i));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public Node findNodeLabelContaining(String string) {
        int n;
        for (n = 0; n < this.nodeCount(); ++n) {
            if (this.nodeAt(n) == null || !this.nodeAt(n).getLabel().toLowerCase().equals(string.toLowerCase())) continue;
            return this.nodeAt(n);
        }
        for (n = 0; n < this.nodeCount(); ++n) {
            if (this.nodeAt(n) == null || this.nodeAt(n).getLabel().toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
            return this.nodeAt(n);
        }
        return null;
    }

    public Edge findEdge(Node node, Node node2) {
        for (int i = 0; i < node.edgeCount(); ++i) {
            Edge edge = node.edgeAt(i);
            if (edge.to != node2) continue;
            return edge;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Edge edge) {
        Vector vector = this.edges;
        synchronized (vector) {
            if (edge == null) {
                return false;
            }
            if (!this.edges.removeElement(edge)) {
                return false;
            }
            edge.from.removeEdge(edge);
            edge.to.removeEdge(edge);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdges(Vector vector) {
        Vector vector2 = this.edges;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                this.deleteEdge((Edge)vector.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Node node, Node node2) {
        Vector vector = this.edges;
        synchronized (vector) {
            Edge edge = this.findEdge(node, node2);
            if (edge != null) {
                return this.deleteEdge(edge);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNode(Node node) {
        Vector vector = this.nodes;
        synchronized (vector) {
            if (node == null) {
                return false;
            }
            if (!this.nodes.removeElement(node)) {
                return false;
            }
            String string = node.getID();
            if (string != null) {
                this.nodeIDRegistry.remove(string);
            }
            for (int i = 0; i < node.edgeCount(); ++i) {
                Edge edge = node.edgeAt(i);
                if (edge.from == node) {
                    this.edges.removeElement(edge);
                    edge.to.removeEdge(edge);
                    continue;
                }
                if (edge.to != node) continue;
                this.edges.removeElement(edge);
                edge.from.removeEdge(edge);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNodes(Vector vector) {
        Vector vector2 = this.nodes;
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                this.deleteNode((Node)vector.elementAt(i));
            }
        }
    }

    public Node getRandomNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        int n = (int)(Math.random() * (double)this.nodeCount());
        return this.nodeAt(n);
    }

    public Node getFirstNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodeAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Vector vector = this.nodes;
        synchronized (vector) {
            Vector vector2 = this.edges;
            synchronized (vector2) {
                this.nodes.removeAllElements();
                this.edges.removeAllElements();
                this.nodeIDRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forAllNodes(TGForEachNode tGForEachNode) {
        Vector vector = this.nodes;
        synchronized (vector) {
            for (int i = 0; i < this.nodeCount(); ++i) {
                Node node = this.nodeAt(i);
                tGForEachNode.forEachNode(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forAllNodePairs(TGForEachNodePair tGForEachNodePair) {
        Vector vector = this.nodes;
        synchronized (vector) {
            for (int i = 0; i < this.nodeCount(); ++i) {
                Node node = this.nodeAt(i);
                tGForEachNodePair.beforeInnerLoop(node);
                for (int j = i + 1; j < this.nodeCount(); ++j) {
                    tGForEachNodePair.forEachNodePair(node, this.nodeAt(j));
                }
                tGForEachNodePair.afterInnerLoop(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forAllEdges(TGForEachEdge tGForEachEdge) {
        Vector vector = this.edges;
        synchronized (vector) {
            for (int i = 0; i < this.edgeCount(); ++i) {
                Edge edge = this.edgeAt(i);
                tGForEachEdge.forEachEdge(edge);
            }
        }
    }
}

