/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import p2pmpi.visu.PeerNode;
import p2pmpi.visu.Task;
import p2pmpi.visu.Visu_Param;

class taskTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"RunCmd", "Rank", "Name", "Status"};
    Visu_Param parent;
    private Vector<taskObject> data;
    int nbReplicasTreated;

    public taskTableModel(Visu_Param visu_Param) {
        this.parent = visu_Param;
        this.data = new Vector();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        if (this.data.size() == 0) {
            return 1;
        }
        return this.data.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public void constructData() {
        Vector<String> vector = new Vector<String>();
        this.data.clear();
        for (int i = 0; i < this.parent.peers.size(); ++i) {
            PeerNode peerNode = this.parent.peers.get(i);
            for (int j = 0; j < peerNode.Tasks.size(); ++j) {
                if (vector.contains(peerNode.Tasks.get(j).getCmd())) continue;
                for (int k = 0; k < peerNode.Tasks.get(j).getRanks().size(); ++k) {
                    if (peerNode.Tasks.get(j).getRank(k) != 0) continue;
                    taskObject taskObject2 = new taskObject(peerNode.Tasks.get(j).getCmd(), 0, peerNode.getHostName(), peerNode.Tasks.get(j).getRankStatus(0));
                    this.data.addElement(taskObject2);
                    for (int i2 = 1; i2 < peerNode.Tasks.get(j).getTotalNbRanks(); ++i2) {
                        for (int i3 = 0; i3 < peerNode.Tasks.get(j).getNbReplicas(); ++i3) {
                            this.data.addElement(this.find(peerNode.Tasks.get(j).getCmd(), i2, i3));
                        }
                    }
                    vector.addElement(peerNode.Tasks.get(j).getCmd());
                }
            }
        }
        this.fireTableRowsInserted(0, this.data.size());
    }

    public Object getValueAt(int n, int n2) {
        if (this.data.size() > n) {
            try {
                switch (n2) {
                    case 0: {
                        return this.data.get((int)n).runCmd;
                    }
                    case 1: {
                        return this.data.get((int)n).Rank;
                    }
                    case 2: {
                        return this.data.get((int)n).Name;
                    }
                    case 3: {
                        if (this.data.get((int)n).Status != 1) break;
                        return "Alive";
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            return "";
        }
        return "";
    }

    public String toString() {
        String string = "\n\n** Task Table **\n\n==================================================\n";
        string = string + "RunCmd\tRank\tName\t\t\tStatus";
        string = string + "\n_____________________________________________________\n";
        for (int i = 0; i < this.getRowCount(); ++i) {
            string = string + "\n";
            for (int j = 0; j < this.getColumnCount(); ++j) {
                string = string + this.getValueAt(i, j) + "\t";
            }
        }
        return string;
    }

    private taskObject find(String string, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.parent.peers.size(); ++i) {
            PeerNode peerNode = this.parent.peers.get(i);
            for (int j = 0; j < peerNode.Tasks.size(); ++j) {
                Task task = peerNode.Tasks.get(j);
                if (task.getCmd() != string) continue;
                for (int k = 0; k < task.getRanks().size(); ++k) {
                    boolean bl;
                    boolean bl2 = bl = task.getRank(k) == n && n3 == n2;
                    if (task.getRank(k) != n) continue;
                    if (n3 == n2) {
                        int n4 = task.getRank(k);
                        Integer n5 = task.getRankStatus(k);
                        String string2 = task.getCmd();
                        String string3 = peerNode.getHostName();
                        return new taskObject(string2, n4, string3, n5);
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    public void clear() {
        this.data.clear();
    }

    class taskObject {
        public String runCmd;
        public int Rank;
        public String Name;
        public Integer Status;

        public taskObject(String string, int n, String string2, Integer n2) {
            this.runCmd = string;
            this.Rank = n;
            this.Name = string2;
            this.Status = n2;
        }
    }
}

