/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.tools;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import p2pmpi.common.HostEntry;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.message.ReplyHostCacheMessage;
import p2pmpi.message.RequestHostCacheMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostCacheDisplay {
    private static String dateTranslate(long l) {
        long l2 = l;
        int n = (int)(l / 84600000L);
        int n2 = (int)((l2 -= (long)(n * 84600000)) / 3600000L);
        int n3 = (int)((l2 -= (long)(n2 * 3600000)) / 60000L);
        int n4 = (int)((l2 -= (long)(n3 * 60000)) / 1000L);
        int n5 = (int)(l2 -= (long)(n4 * 1000));
        return n + "D " + n2 + ":" + n3 + ":" + n4 + ":" + n5;
    }

    private static String resolve(String string) {
        String string2 = string;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string2;
    }

    private static String getFiller(String string, int n, String string2) {
        return string2.substring(0, n - string.length() + 1);
    }

    private static String displayMd5(HostEntry hostEntry) {
        String string = "";
        int n = 6;
        String string2 = "";
        Vector<String> vector = hostEntry.getCacheMd5sums();
        if (vector != null) {
            for (String string3 : vector) {
                string2 = string2 + ".." + string3.substring(string3.length() - n) + " ";
            }
        }
        string = string + " (" + vector.size() + ")\t" + string2;
        return string;
    }

    private static String displayRTT(HostEntry hostEntry) {
        String string = "";
        String string2 = hostEntry.getRtt() == Integer.MAX_VALUE ? "unknown" : "" + hostEntry.getRtt();
        string = hostEntry.getMpdPort() + "\t\t" + string2 + "\t" + hostEntry.isAlive() + "\t" + HostCacheDisplay.dateTranslate(hostEntry.getLastUpdate());
        return string;
    }

    public static void display(String string, Vector<HostEntry> vector, boolean bl, boolean bl2) {
        String string2 = null;
        String string3 = new String();
        String string4 = "Host";
        int n = 0;
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        String[] stringArray = new String[n2];
        if (!bl) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                stringArray[n3] = HostCacheDisplay.resolve(vector.elementAt(n3).getIp());
                n = stringArray[n3].length() > n ? stringArray[n3].length() : n;
            }
            if (n2 == 0) {
                n = 10;
            }
            for (n3 = 0; n3 < n + 4; ++n3) {
                string3 = string3 + " ";
            }
            string2 = HostCacheDisplay.getFiller(string4, n, string3);
        } else {
            string2 = "\t\t";
        }
        System.out.println("Hostcache entry of MPD : " + string + "\n");
        if (bl2) {
            System.out.println(string4 + string2 + "files md5sums (truncated)");
        } else {
            System.out.println(string4 + string2 + "MPD Port\tRTT(ms)\tAlive\tLast update");
        }
        for (int i = 0; i < n2; ++i) {
            HostEntry hostEntry = vector.elementAt(i);
            String string5 = "";
            string5 = !bl ? stringArray[i] + HostCacheDisplay.getFiller(stringArray[i], n, string3) : hostEntry.getIp() + "\t";
            string5 = bl2 ? string5 + HostCacheDisplay.displayMd5(hostEntry) : string5 + HostCacheDisplay.displayRTT(hostEntry);
            System.out.println(string5);
        }
        System.out.println("\nTotal : " + n2 + " MPD known.");
    }

    public static Vector<HostEntry> get(String string) {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        int n = p2PMPI_ConfigFile.getMPDPort();
        Vector<HostEntry> vector = null;
        try {
            Socket socket = new Socket(string, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            RequestHostCacheMessage requestHostCacheMessage = new RequestHostCacheMessage();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(requestHostCacheMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            ReplyHostCacheMessage replyHostCacheMessage = (ReplyHostCacheMessage)objectInputStream.readObject();
            vector = replyHostCacheMessage.getHostCache();
            objectInputStream.close();
            objectOutputStream.close();
            outputStream.close();
            inputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("[Error] : " + exception.toString());
            System.exit(1);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "127.0.0.1";
        Vector<HostEntry> vector = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h")) {
                System.out.println("usage: mpihost [-h] [-n] [-d] [hostname]");
                System.out.println("  -h : this help message");
                System.out.println("  -n : display numeric IP addresses (no DNS resolution)");
                System.out.println("  -d : display md5sums of files in cache");
                System.out.println("  hostname : IP or hostname. Without this argument, query localhost.");
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-n")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-d")) {
                bl2 = true;
                continue;
            }
            string = stringArray[i];
        }
        vector = HostCacheDisplay.get(string);
        HostCacheDisplay.display(string, vector, bl, bl2);
    }
}

