/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import p2pmpi.mpi.dev.BufferBoolean;
import p2pmpi.mpi.dev.BufferByte;
import p2pmpi.mpi.dev.BufferChar;
import p2pmpi.mpi.dev.BufferDouble;
import p2pmpi.mpi.dev.BufferFloat;
import p2pmpi.mpi.dev.BufferInt;
import p2pmpi.mpi.dev.BufferLong;
import p2pmpi.mpi.dev.BufferNull;
import p2pmpi.mpi.dev.BufferObject;
import p2pmpi.mpi.dev.BufferShort;
import p2pmpi.mpi.dev.BufferString;

public abstract class P2PMPI_Buffer {
    public static int HEADER_SIZE = 24;
    protected int baseSize;
    short commID;
    int src;
    int dst;
    int tag;
    int numsend;

    public P2PMPI_Buffer(int baseSize) {
        this.baseSize = baseSize;
    }

    public static P2PMPI_Buffer createBuffer(int type, int baseSize) {
        switch (type) {
            case 1: {
                return new BufferByte(baseSize);
            }
            case 2: {
                return new BufferChar(baseSize);
            }
            case 3: {
                return new BufferShort(baseSize);
            }
            case 5: {
                return new BufferInt(baseSize);
            }
            case 8: {
                return new BufferDouble(baseSize);
            }
            case 4: {
                return new BufferBoolean(baseSize);
            }
            case 7: {
                return new BufferFloat(baseSize);
            }
            case 6: {
                return new BufferLong(baseSize);
            }
            case 11: {
                return new BufferObject(baseSize);
            }
            case 10: {
                return new BufferString(baseSize);
            }
            case 0: {
                return new BufferNull(baseSize);
            }
        }
        return new BufferByte(baseSize);
    }

    public abstract Object createArrayBuffer(int var1);

    public abstract ByteBuffer fillBuffer(ByteBuffer var1, Object var2, int var3, int var4);

    public abstract int fillRecvData(Object var1, int var2, int var3, ByteBuffer var4, int var5);

    public void fillHeader(ByteBuffer buff) {
        buff.put((byte)13);
        buff.put((byte)2);
        buff.putShort(this.commID);
        buff.putInt(this.src);
        buff.putInt(this.dst);
        buff.putInt(this.tag);
        buff.putInt(this.numsend);
    }

    public synchronized ByteBuffer getByteBuffer(Object buffer, int offset, int count, short commID, int src, int dst, int tag, int numsend) {
        this.commID = commID;
        this.src = src;
        this.dst = dst;
        this.tag = tag;
        this.numsend = numsend;
        int dataSize = count * this.baseSize;
        ByteBuffer myBuffer = ByteBuffer.allocateDirect(HEADER_SIZE + dataSize);
        this.fillHeader(myBuffer);
        myBuffer.putInt(dataSize);
        myBuffer = this.fillBuffer(myBuffer, buffer, offset, count);
        myBuffer.flip();
        return myBuffer;
    }
}

