/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.util.Vector;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.SmallRequest;

public class NIORequest {
    protected Object recvBuffer;
    protected int offset;
    protected int count;
    protected int src;
    protected int tag;
    protected int dst;
    Vector<SmallRequest> reqList;
    P2PMPI_Buffer buffer;
    IStatus status = null;
    protected volatile boolean completed;

    public NIORequest() {
        this.reqList = new Vector();
        this.completed = false;
    }

    public NIORequest(Object recvBuffer, int offset, int count, int src, int dst, int tag, P2PMPI_Buffer buffer) {
        this.recvBuffer = recvBuffer;
        this.offset = offset;
        this.count = count;
        this.src = src;
        this.dst = dst;
        this.tag = tag;
        this.buffer = buffer;
        this.reqList = new Vector();
        this.completed = false;
    }

    public void fillStatus(IStatus status) {
        this.status = status;
    }

    public void fillStatus(int src, int tag, int length) {
        this.status = new IStatus(src, tag, length);
    }

    public void fillStatus(IStatus status, int length) {
        this.status = status;
        this.status.setLength(length);
    }

    public synchronized void complete() {
        this.completed = true;
        try {
            this.notify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void add(SmallRequest req) {
        this.reqList.addElement(req);
    }

    public int addData(ByteBuffer data, int dataSize) {
        return this.buffer.fillRecvData(this.recvBuffer, this.offset, this.count, data, dataSize);
    }

    public IStatus Wait() {
        int waitSize = this.reqList.size();
        if (waitSize != 0) {
            for (int i = 0; i < waitSize; ++i) {
                this.reqList.elementAt(i).Wait();
            }
        } else {
            while (!this.completed) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        return this.status;
    }

    public IStatus Test() {
        return this.status;
    }
}

