/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.MessageHandler;
import p2pmpi.mpi.dev.MessageIDLog;
import p2pmpi.mpi.dev.NIORequest;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.RecvBufferInformation;
import p2pmpi.mpi.dev.SendBufferInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Device
implements Runnable {
    protected MessageHandler msgHandle;
    protected int myRank;
    public int numReplica;
    protected int numProc;
    protected int myRankInRep;
    protected int myRankInList;
    protected RankTable rankTable;
    protected boolean terminated;
    protected String myHash;
    protected int fdPort;
    protected int mpdPort;
    protected Vector<RecvBufferInformation> unexpectedQueue = new Vector();
    protected Vector<RecvBufferInformation> expectedQueue = new Vector();
    protected Vector<SendBufferInformation> backupBuffer = new Vector();
    protected MessageIDLog recvLog = new MessageIDLog();
    protected MessageIDLog sendLog = new MessageIDLog();
    protected boolean master;
    protected int myMaster;
    protected Map commMap = new HashMap();
    protected RankTable commWorld;
    protected ExecutorService tpes;
    protected boolean N_POWER2 = false;
    public static int EAGER_SIZE = 131072;

    public boolean isPower2() {
        return this.N_POWER2;
    }

    public abstract boolean isDone();

    public abstract boolean init();

    public abstract int initPort(int var1, int var2, String var3);

    public abstract boolean init(ServerSocket var1, String var2, int var3, int var4);

    public abstract void spawnMessageHandler(ServerSocket var1, int var2, RankTable var3, String var4, int var5, int var6, int var7, int var8, int var9, String var10);

    public abstract void connect(int var1, int var2, int var3, RankTable var4, int var5, int var6);

    public abstract boolean connectToNode(URI var1, int var2, int var3, SocketChannel[][] var4, byte var5);

    public abstract void doFailureRepair(int var1);

    @Override
    public abstract void run();

    public abstract void commit(RankTable var1, int[] var2, short var3, int var4, int var5, int var6, int var7);

    public abstract int ssend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract NIORequest issend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract int send(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract NIORequest isend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract IStatus recv(Object var1, int var2, int var3, short var4, int var5, int var6, int var7, int var8, P2PMPI_Buffer var9);

    public abstract NIORequest irecv(Object var1, int var2, int var3, short var4, int var5, int var6, int var7, int var8, P2PMPI_Buffer var9);

    public abstract void finalizeConfirm();

    public abstract void finalize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            for (int i = 0; i < this.rankTable.size(); ++i) {
                if (this.rankTable.isTerminated(i)) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            this.rankTable.setTerminated(0, true);
        }
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void setMyMaster(int myMaster) {
        this.myMaster = myMaster;
    }

    public boolean isMaster() {
        return this.master;
    }

    public int getRank() {
        return this.msgHandle.getRank();
    }

    public int getCommSize() {
        return this.msgHandle.getCommSize();
    }

    public int getTGossip() {
        return this.msgHandle.getTGossip();
    }

    public int getTMargin() {
        return this.msgHandle.getTMargin();
    }

    public int getTHang() {
        return this.msgHandle.getTHang();
    }

    public String getGossipProtocol() {
        return this.msgHandle.getGossipProtocol();
    }

    public int getTDiff() {
        return this.msgHandle.getTDiff();
    }

    public int getExpectedQueueSize() {
        return this.expectedQueue.size();
    }

    public int getUnexpectedQueueSize() {
        return this.unexpectedQueue.size();
    }

    public void shutdown() {
        this.msgHandle.shutdown();
        this.tpes.shutdownNow();
    }

    public boolean isRankTableReady() {
        return this.msgHandle.isReady();
    }

    public RankTable getRankTable() {
        return this.msgHandle.getRankTable();
    }

    public int getRankInList() {
        return this.msgHandle.getRankInList();
    }

    public boolean isRequestInExpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend) {
        int numElement = this.expectedQueue.size();
        for (int i = 0; i < numElement; ++i) {
            boolean any_tag;
            RecvBufferInformation tmp = this.expectedQueue.elementAt(i);
            boolean match_dst = tmp.commID() == commID && tmp.fromRank() == fromRank && tmp.toRank() == toRank && tmp.numSend() == numsend;
            boolean match_tag = tmp.getTag() == tag;
            boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
            boolean bl = any_tag = tag == Tag.MPI_ANYTAG;
            if (!match_dst && !any_src || !match_tag && !any_tag) continue;
            return true;
        }
        return false;
    }

    public NIORequest getRequestFromExpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend, IStatus status) {
        int numElement = this.expectedQueue.size();
        for (int i = 0; i < numElement; ++i) {
            boolean match_dst;
            RecvBufferInformation tmp = this.expectedQueue.elementAt(i);
            boolean match_tag = tmp.getTag() == tag;
            boolean any_src = tmp.fromRank() == Tag.MPI_ANYSOURCE;
            boolean any_tag = tmp.getTag() == Tag.MPI_ANYTAG;
            boolean bl = match_dst = tmp.commID() == commID && tmp.fromRank() == fromRank && tmp.toRank() == toRank && (tmp.numSend() == numsend || any_src || any_tag);
            if (!match_dst && !any_src || !match_tag && !any_tag) continue;
            status.setStatus(fromRank, tag);
            this.expectedQueue.remove(i);
            return tmp.getRequest();
        }
        return null;
    }

    public ByteBuffer getDataFromUnexpectedQueue(short commID, int fromRank, int toRank, int tag, int numsend, IStatus status) {
        int numElement = this.unexpectedQueue.size();
        for (int i = 0; i < numElement; ++i) {
            boolean match_dst;
            RecvBufferInformation tmp = this.unexpectedQueue.elementAt(i);
            boolean match_tag = tmp.getTag() == tag;
            boolean any_src = fromRank == Tag.MPI_ANYSOURCE;
            boolean any_tag = tag == Tag.MPI_ANYTAG;
            boolean bl = match_dst = tmp.commID() == commID && tmp.fromRank() == fromRank && tmp.toRank() == toRank && (tmp.numSend() == numsend || any_src || any_tag);
            if (!match_dst && !any_src || !match_tag && !any_tag) continue;
            status.setStatus(tmp.fromRank(), tmp.getTag());
            this.unexpectedQueue.remove(i);
            return tmp.getData();
        }
        return null;
    }

    public void cleanupProcess() {
        Socket conn = null;
        OutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            GossipMessage gossipMsg = new GossipMessage(2, this.myHash);
            int rankInList = this.getRankInList();
            gossipMsg.setMyRank(rankInList);
            conn = new Socket("127.0.0.1", this.fdPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(gossipMsg);
            oos.flush();
            oos.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("Fault Detection Service is not running");
        }
        try {
            AppUnregisterMessage unRegMsg = new AppUnregisterMessage(this.myHash, this.myRank);
            conn = new Socket("127.0.0.1", this.mpdPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(unRegMsg);
            oos.flush();
            oos.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("MPD Service is not running");
        }
    }

    public String getMessageID(short commID, int src, int dst, int tag, int numsend) {
        try {
            return new String(commID + "_" + src + "_" + dst + "_" + tag + "_" + numsend);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIORequest sendToBackup(RankTable commTable, ByteBuffer data, Vector<Integer> dest, short commID, int src, int dst, int tag, int numsend, int[] repRankInList) {
        String messageID = this.getMessageID(commID, src, dst, tag, numsend);
        MessageIDLog messageIDLog = this.sendLog;
        synchronized (messageIDLog) {
            if (this.sendLog.isExist(messageID)) {
                this.sendLog.remove(messageID);
            } else {
                this.sendLog.add(messageID);
                SendBufferInformation backup = new SendBufferInformation(commTable, data, dest, commID, src, dst, tag, numsend, repRankInList);
                Vector<SendBufferInformation> vector = this.backupBuffer;
                synchronized (vector) {
                    this.backupBuffer.addElement(backup);
                }
            }
        }
        NIORequest req = new NIORequest();
        req.complete();
        req.fillStatus(src, tag, 0);
        return req;
    }

    public String getHashKey(short commID, int fromRank, int toRank, int tag, int numsend) {
        return commID + "_" + fromRank + "_" + toRank + "_" + tag + "_" + numsend;
    }

    public void registerMap(short commID, MapRankTable mapTable) {
        this.commMap.put(Short.toString(commID), mapTable);
    }

    public void registerCOMMWORLD(RankTable commWorld) {
        this.commWorld = commWorld;
    }

    public MapRankTable getMapRankTable(short commID) {
        return (MapRankTable)this.commMap.get(Short.toString(commID));
    }
}

