/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class BufferShort
extends P2PMPI_Buffer {
    public BufferShort(int baseSize) {
        super(baseSize);
    }

    public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
        ShortBuffer sBuffer = myBuffer.asShortBuffer();
        sBuffer.put((short[])buffer, offset, count);
        myBuffer.position(myBuffer.position() + count * this.baseSize);
        return myBuffer;
    }

    public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
        int recvData = dataSize / this.baseSize < count ? dataSize / this.baseSize : count;
        ShortBuffer sBuffer = data.asShortBuffer();
        sBuffer.get((short[])buffer, offset, recvData);
        data.position(data.position() + recvData * this.baseSize);
        return (recvData - count) * this.baseSize;
    }

    public Object createArrayBuffer(int count) {
        return new short[count];
    }
}

