/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class BufferObject
extends P2PMPI_Buffer {
    protected byte[] ObjectSerialize(Object buff, int offset, int count) {
        ByteArrayOutputStream o;
        Object[] buffArray = (Object[])buff;
        try {
            o = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(o);
            for (int i = offset; i < offset + count; ++i) {
                out.writeObject(buffArray[i]);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return o.toByteArray();
    }

    protected void ObjectDeserialize(Object buff, byte[] data, int offset, int count) {
        Object[] buffArray = (Object[])buff;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream s = new ObjectInputStream(in);
            for (int i = offset; i < offset + count; ++i) {
                buffArray[i] = s.readObject();
            }
            s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public BufferObject(int baseSize) {
        super(baseSize);
    }

    public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
        byte[] byteDat = this.ObjectSerialize(buffer, offset, count);
        int size = byteDat.length;
        ByteBuffer newBuffer = ByteBuffer.allocateDirect(HEADER_SIZE + size);
        this.fillHeader(newBuffer);
        newBuffer.putInt(size);
        newBuffer.put(byteDat);
        return newBuffer;
    }

    public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
        byte[] byteDat = new byte[dataSize];
        data.get(byteDat);
        this.ObjectDeserialize(buffer, byteDat, offset, count);
        return (count - offset) * this.baseSize;
    }

    public Object createArrayBuffer(int count) {
        return null;
    }
}

