/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class BufferInt
extends P2PMPI_Buffer {
    public BufferInt(int baseSize) {
        super(baseSize);
    }

    public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
        IntBuffer iBuffer = myBuffer.asIntBuffer();
        iBuffer.put((int[])buffer, offset, count);
        myBuffer.position(myBuffer.position() + count * this.baseSize);
        return myBuffer;
    }

    public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
        int recvData = dataSize / this.baseSize < count ? dataSize / this.baseSize : count;
        IntBuffer iBuffer = data.asIntBuffer();
        iBuffer.get((int[])buffer, offset, recvData);
        data.position(data.position() + recvData * this.baseSize);
        return (recvData - offset) * this.baseSize;
    }

    public Object createArrayBuffer(int count) {
        return new int[count];
    }
}

