/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import p2pmpi.mpi.dev.P2PMPI_Buffer;

public class BufferChar
extends P2PMPI_Buffer {
    public BufferChar(int baseSize) {
        super(baseSize);
    }

    public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
        CharBuffer charBuffer = myBuffer.asCharBuffer();
        charBuffer.put((char[])buffer, offset, count);
        myBuffer.position(myBuffer.position() + count * this.baseSize);
        return myBuffer;
    }

    public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
        int recvData = dataSize / this.baseSize < count ? dataSize / this.baseSize : count;
        int end = offset + recvData;
        CharBuffer charBuffer = data.asCharBuffer();
        charBuffer.get((char[])buffer, offset, recvData);
        data.position(data.position() + recvData * this.baseSize);
        return (count - recvData) * this.baseSize;
    }

    public Object createArrayBuffer(int count) {
        return new char[count];
    }
}

