/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Status;
import p2pmpi.mpi.dev.Device;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.NIORequest;

public class Request {
    protected Device myDevice;
    protected Object recvBuffer;
    protected int offset;
    protected int count;
    protected Datatype datatype;
    protected int src;
    protected int tag;
    protected int dst;
    protected NIORequest myRequest;

    public Request(Device myDevice, Object recvBuffer, int offset, int count, Datatype datatype, int src, int tag, int dst) {
        this.myDevice = myDevice;
        this.recvBuffer = recvBuffer;
        this.offset = offset;
        this.count = count;
        this.datatype = datatype;
        this.src = src;
        this.tag = tag;
        this.dst = dst;
    }

    public Request() {
        this.myRequest = new NIORequest();
    }

    public Request(Object recvBuffer, int offset, int count, Datatype datatype, int src, int dst, int tag) {
        this.myRequest = new NIORequest(recvBuffer, offset, count, src, dst, tag, datatype.getBuffer());
    }

    public Request(NIORequest req) {
        this.myRequest = req;
    }

    public static Status[] Waitall(Request[] requests) {
        int size = requests.length;
        Status[] status = new Status[size];
        for (int i = 0; i < size; ++i) {
            status[i] = requests[i].Wait();
        }
        return status;
    }

    public synchronized Status Wait() {
        IStatus istatus = this.myRequest.Wait();
        return new Status(istatus);
    }

    public Status Test() {
        IStatus istatus = this.myRequest.Test();
        if (istatus != null) {
            return new Status(istatus);
        }
        return null;
    }
}

