/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import p2pmpi.common.MapRankTable;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.mpi.DevicePort;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.dev.NIODevice;
import p2pmpi.mpi.dev.NormalDevice;

class MPIClient
extends MPI {
    private int clientPort = 0;
    private ServerSocket reservedSocket = null;

    private int getMyPort() {
        return this.clientPort;
    }

    private ServerSocket getReservedSocket() {
        return this.reservedSocket;
    }

    private void setPorts(int minPort, int maxPort, long seed) {
        int randomStart;
        int i;
        mpiRandom = new Random(seed);
        Random r = new Random();
        String errPortMsg = "No available ports for the application process communications in the range [" + minPort + ":" + maxPort + "]";
        for (i = randomStart = r.nextInt(maxPort - minPort) + minPort; i <= maxPort; ++i) {
            try {
                this.reservedSocket = new ServerSocket(i);
                this.clientPort = i;
                break;
            }
            catch (Exception e) {
                this.reservedSocket = null;
                continue;
            }
        }
        if (this.reservedSocket == null) {
            for (i = minPort; i <= maxPort; ++i) {
                try {
                    this.reservedSocket = new ServerSocket(i);
                    this.clientPort = i;
                    break;
                }
                catch (Exception e) {
                    this.reservedSocket = null;
                    continue;
                }
            }
            if (this.reservedSocket == null) {
                System.err.println("** [Error] clientPort: " + errPortMsg + ", host " + MPIClient.getLocalhostExtIp());
                System.exit(1);
            }
        }
    }

    public MPIClient(int minPort, int maxPort) {
        String rank0_host = System.getProperty("ip");
        int rank0_port = Integer.parseInt(System.getProperty("port"));
        myRank = Integer.parseInt(System.getProperty("rank"));
        myHash = System.getProperty("hashkey");
        Socket sock = null;
        ServerSocket reservePort = null;
        int myPort = 0;
        this.setPorts(minPort, maxPort, Long.parseLong(myHash) + (long)myRank);
        myPort = this.getMyPort();
        reservePort = this.getReservedSocket();
        myDevice = System.getProperty("device").equals("niodevice") ? new NIODevice() : (System.getProperty("device").equals("normaldevice") ? new NormalDevice() : new NIODevice());
        if (!myDevice.init(reservePort, myHash, mpdPort, fdPort)) {
            System.err.println("** [Error] MPI NIOdevice init failed");
            System.exit(1);
        }
        String errPortMsg = "No available ports for the application process communications in the range [" + minPort + "-" + maxPort + "]";
        DevicePort datadev = new DevicePort(minPort, maxPort, "data port");
        DevicePort ctrldev = new DevicePort(minPort, maxPort, "control port");
        MPIMessage mpiMsg = null;
        mpiMsg = new MPIMessage(12);
        mpiMsg.setRank(myRank);
        mpiMsg.setFDPort(fdPort);
        mpiMsg.setURI(MPIClient.getLocalhostExtIp(), myPort);
        mpiMsg.setDataURI(MPIClient.getLocalhostExtIp(), datadev.getPort());
        mpiMsg.setCtrlURI(MPIClient.getLocalhostExtIp(), ctrldev.getPort());
        boolean synSuccess = false;
        OutputStream os = null;
        InputStream in = null;
        ObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        for (int i = 0; i < 75; ++i) {
            try {
                sock = new Socket();
                InetSocketAddress addr = new InetSocketAddress(rank0_host, rank0_port);
                sock.connect(addr, 200);
                os = sock.getOutputStream();
                oos = new ObjectOutputStream(os);
                oos.writeObject(mpiMsg);
                oos.flush();
                oos.close();
                os.close();
                synSuccess = true;
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (!synSuccess) {
            System.exit(1);
        }
        while (!myDevice.isRankTableReady()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {}
        }
        long startDiffTime = System.currentTimeMillis();
        rankTable = myDevice.getRankTable();
        int rankInList = myDevice.getRankInList();
        mapRankTable = new MapRankTable();
        for (int i = 0; i < rankTable.size(); ++i) {
            mapRankTable.addMap(rankTable.getRank(i), rankTable.getRank(i), i);
        }
        int rankInRep = rankTable.getRankInReplica(datadev.getExtURI(), rankInList);
        myDevice.connect(myRank, rankInRep, rankInList, rankTable, rankTable.getNumProcess(), rankTable.getNumReplica());
        Thread devThread = new Thread(myDevice);
        devThread.setDaemon(true);
        devThread.start();
        COMM_WORLD = new IntraComm(myDevice, rankTable, myDevice.getRank(), rankInList, myDevice.getCommSize(), mapRankTable);
        AppRegisterMessage appMsg = new AppRegisterMessage();
        appMsg.setID(myHash + "--" + myRank);
        appMsg.setRunCmd(System.getProperty("runCmd"));
        appMsg.setIPRank0(rank0_host);
        appMsg.setRunDir(System.getProperty("user.dir"));
        appMsg.setRank(myRank);
        appMsg.setPort(myPort);
        appMsg.setMPISize(myDevice.getCommSize());
        appMsg.setRealSize(rankTable.size());
        appMsg.setRankTable(rankTable);
        try {
            Socket conn = new Socket("127.0.0.1", mpdPort);
            os = conn.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(appMsg);
            oos.flush();
            in = conn.getInputStream();
            ois = new ObjectInputStream(in);
            PingReplyMessage replyMsg = (PingReplyMessage)ois.readObject();
            ois.close();
            oos.close();
            in.close();
            os.close();
            conn.close();
        }
        catch (Exception e) {
            System.err.println("** [Error] Make sure MPD is running");
            System.exit(-1);
        }
        GossipMessage gossipMsg = new GossipMessage(0, myHash);
        gossipMsg.setMPIRank(myRank);
        gossipMsg.setMyRank(rankInList);
        gossipMsg.setMPIPort(myPort);
        gossipMsg.setURIList(rankTable.getFDURIs());
        gossipMsg.setTGossip(myDevice.getTGossip());
        gossipMsg.setTMargin(myDevice.getTMargin());
        gossipMsg.setTHang(myDevice.getTHang());
        gossipMsg.setGossipProtocol(myDevice.getGossipProtocol());
        gossipMsg.setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - startDiffTime + (long)myDevice.getTDiff()));
        try {
            sock = new Socket("127.0.0.1", fdPort);
            os = sock.getOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(gossipMsg);
            oos.flush();
            oos.close();
            os.close();
            sock.close();
        }
        catch (Exception e) {
            System.out.println("Fault Detection Service is not running");
            System.exit(1);
        }
    }
}

