/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.dev.Device;

public class Group {
    Device myDevice;
    RankTable rankTable;
    MapRankTable mapRankTable;
    int myRank;
    int myRankInList;
    int groupSize;

    public Group(Device device, RankTable rankTable, int myRank, int myRankInList, int groupSize, MapRankTable mapRankTable) {
        this.myDevice = device;
        this.rankTable = rankTable;
        this.myRank = myRank;
        this.myRankInList = myRankInList;
        this.groupSize = groupSize;
        this.mapRankTable = mapRankTable;
    }

    public int Rank() {
        return this.myRank;
    }

    public int RankInList() {
        return this.myRankInList;
    }

    public int Size() {
        return this.groupSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int __sizetotal() {
        int size = 0;
        int numPeer = this.__getNumPeers();
        MapRankTable mapRankTable = this.mapRankTable;
        synchronized (mapRankTable) {
            for (int i = 0; i < numPeer; ++i) {
                if (!this.rankTable.isAlive(this.mapRankTable.getCurrentRank(i))) continue;
                ++size;
            }
        }
        return size;
    }

    public Group Excl(int[] rank) {
        int newGroupSize = this.groupSize;
        int numPeers = this.__getNumPeers();
        MapRankTable newMapRankTable = new MapRankTable();
        int myNewRank = MPI.UNDEFINED;
        int myNewRankInList = MPI.UNDEFINED;
        int numElement = 0;
        for (int i = 0; i < numPeers; ++i) {
            int r = this.mapRankTable.getCurrentRank(i);
            int counter = 0;
            boolean isExclude = false;
            for (int j = 0; j < rank.length; ++j) {
                if (rank[j] < r) {
                    ++counter;
                    continue;
                }
                if (rank[j] != r) continue;
                isExclude = true;
                break;
            }
            if (isExclude) continue;
            newMapRankTable.addMap(r - counter, this.mapRankTable.getWorldRank(i), this.mapRankTable.getRankInList(i));
            if (i == this.myRankInList) {
                myNewRank = r - counter;
                myNewRankInList = numElement;
            }
            ++numElement;
        }
        Group newGroup = new Group(this.myDevice, this.rankTable, myNewRank, myNewRankInList, newGroupSize -= rank.length, newMapRankTable);
        return newGroup;
    }

    public Group Incl(int[] rank) {
        int counter = 0;
        int listcounter = 0;
        MapRankTable newMapRankTable = new MapRankTable();
        int myNewRank = MPI.UNDEFINED;
        int myNewRankInList = MPI.UNDEFINED;
        int numPeers = this.mapRankTable.size();
        for (int i = 0; i < rank.length; ++i) {
            boolean rankAdded = false;
            for (int j = 0; j < numPeers; ++j) {
                if (this.mapRankTable.getCurrentRank(j) != rank[i]) continue;
                newMapRankTable.addMap(counter, this.mapRankTable.getWorldRank(j), this.mapRankTable.getRankInList(j));
                if (j == this.myRankInList) {
                    myNewRank = counter;
                    myNewRankInList = listcounter;
                }
                rankAdded = true;
                ++listcounter;
            }
            if (!rankAdded) continue;
            ++counter;
        }
        int newGroupSize = counter;
        Group newGroup = new Group(this.myDevice, this.rankTable, myNewRank, myNewRankInList, newGroupSize, newMapRankTable);
        return newGroup;
    }

    public static int Compare(Group group1, Group group2) {
        MapRankTable rank1 = group1.__getMapCommTable();
        MapRankTable rank2 = group2.__getMapCommTable();
        if (rank1.size() != rank2.size()) {
            return MPI.UNEQUAL;
        }
        int numMap = rank1.size();
        boolean ident = true;
        for (int i = 0; i < numMap; ++i) {
            if (rank1.getCurrentRank(i) == rank2.getCurrentRank(i) && rank1.getRankInList(i) == rank2.getRankInList(i)) continue;
            ident = false;
            break;
        }
        if (!ident) {
            boolean pass = false;
            for (int i = 0; i < numMap; ++i) {
                for (int j = 0; j < numMap; ++j) {
                    if (rank1.getRankInList(i) != rank2.getRankInList(j)) continue;
                    pass = true;
                    break;
                }
                if (pass) continue;
                return MPI.UNEQUAL;
            }
            return MPI.SIMILAR;
        }
        return MPI.IDENT;
    }

    public static Group Union(Group group1, Group group2) {
        MapRankTable rank1 = group1.__getMapCommTable();
        MapRankTable rank2 = group2.__getMapCommTable();
        MapRankTable newMapRankTable = new MapRankTable();
        int newGroupSize = 0;
        int numMap1 = rank1.size();
        int numMember1 = group1.Size();
        for (int i = 0; i < numMap1; ++i) {
            newMapRankTable.addMap(rank1.getCurrentRank(i), rank1.getWorldRank(i), rank1.getRankInList(i));
        }
        int myNewRank = group1.Rank();
        int myNewRankInList = group1.RankInList();
        int numMap2 = rank2.size();
        int numMember2 = group2.Size();
        int numAdded = 0;
        int counter = 0;
        for (int i = 0; i < numMember2; ++i) {
            boolean rankAdded = false;
            for (int j = 0; j < numMap2; ++j) {
                if (rank2.getCurrentRank(j) != i) continue;
                boolean alreadyAdded = false;
                for (int k = 0; k < numMap1; ++k) {
                    if (rank2.getRankInList(j) != rank1.getRankInList(k)) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                newMapRankTable.addMap(numAdded + numMember1, rank2.getWorldRank(j), rank2.getRankInList(j));
                if (j == group2.RankInList()) {
                    myNewRank = numAdded + numMember1;
                    myNewRankInList = numMap1 + counter;
                }
                ++counter;
                rankAdded = true;
            }
            if (!rankAdded) continue;
            ++numAdded;
        }
        newGroupSize = numAdded + numMember1;
        Group newGroup = new Group(group1.__getDevice(), group1.__getRankTable(), myNewRank, myNewRankInList, newGroupSize, newMapRankTable);
        return newGroup;
    }

    public static Group Intersection(Group group1, Group group2) {
        MapRankTable newMapRankTable = new MapRankTable();
        MapRankTable rank1 = group1.__getMapCommTable();
        MapRankTable rank2 = group2.__getMapCommTable();
        int numMap1 = rank1.size();
        int numMap2 = rank2.size();
        int[] tmpRanks = new int[numMap1];
        int counter = 0;
        block0: for (int i = 0; i < numMap1; ++i) {
            for (int j = 0; j < numMap2; ++j) {
                if (rank1.getRankInList(i) != rank2.getRankInList(j)) continue;
                boolean rankDup = false;
                for (int k = 0; k < counter; ++k) {
                    if (tmpRanks[k] != rank1.getCurrentRank(i)) continue;
                    rankDup = true;
                    break;
                }
                if (rankDup) continue block0;
                tmpRanks[counter] = rank1.getCurrentRank(i);
                ++counter;
                continue block0;
            }
        }
        int[] ranks = new int[counter];
        for (int i = 0; i < counter; ++i) {
            ranks[i] = tmpRanks[i];
        }
        return group1.Incl(ranks);
    }

    public static Group Difference(Group group1, Group group2) {
        MapRankTable newMapRankTable = new MapRankTable();
        MapRankTable rank1 = group1.__getMapCommTable();
        MapRankTable rank2 = group2.__getMapCommTable();
        int numMap1 = rank1.size();
        int numMap2 = rank2.size();
        int[] tmpRanks = new int[numMap1];
        int counter = 0;
        block0: for (int i = 0; i < numMap1; ++i) {
            for (int j = 0; j < numMap2; ++j) {
                if (rank1.getRankInList(i) != rank2.getRankInList(j)) continue;
                boolean rankDup = false;
                for (int k = 0; k < counter; ++k) {
                    if (tmpRanks[k] != rank1.getCurrentRank(i)) continue;
                    rankDup = true;
                    break;
                }
                if (rankDup) continue block0;
                tmpRanks[counter] = rank1.getCurrentRank(i);
                ++counter;
                continue block0;
            }
        }
        int[] ranks = new int[counter];
        for (int i = 0; i < counter; ++i) {
            ranks[i] = tmpRanks[i];
        }
        return group1.Excl(ranks);
    }

    public Device __getDevice() {
        return this.myDevice;
    }

    public int __getNumPeers() {
        return this.mapRankTable.size();
    }

    public RankTable __getCommTable() {
        return this.rankTable;
    }

    public MapRankTable __getMapCommTable() {
        return this.mapRankTable;
    }

    public RankTable __getRankTable() {
        return this.rankTable;
    }
}

