/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.DiskCache;
import p2pmpi.common.FileCharacteristics;
import p2pmpi.common.HostEntry;
import p2pmpi.common.NameGenerator;
import p2pmpi.common.NetIface;
import p2pmpi.common.OsInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.ProcessTable;
import p2pmpi.common.ReservationResult;
import p2pmpi.common.ReservedHost;
import p2pmpi.common.Version;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.mpd.MPD_Interface;
import p2pmpi.mpd.P2PMPI_MPDPeer;
import p2pmpi.mpd.PeerCache;
import p2pmpi.p2p.PeerKeepAlive;
import p2pmpi.p2p.PeerUpdateList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PMPI_MPD
extends P2PMPI_MPDPeer {
    int appMinPort;
    int appMaxPort;
    int appCurrentPort;
    int numCPU;
    Properties confProps;
    long startBOOT = System.currentTimeMillis();
    long stopBOOT;
    protected ProcessTable procTab = null;
    URI superNode;
    URI myURI;

    public P2PMPI_MPD(int n, int n2, int n3, int n4, int n5, String string, Properties properties, String string2, String string3, int n6, int n7, int n8, URI uRI, String string4, String string5, String string6, String string7) {
        log = Logger.getLogger((String)"MPD");
        this.mpdPort = n;
        this.fdPort = n2;
        this.ftPort = n3;
        this.rsPort = n7;
        this.runPath = new File(string, this.getUniqueDirName());
        this.appMinPort = n4;
        this.appMaxPort = n5;
        this.confProps = properties;
        this.numCPU = n8;
        this.superNode = uRI;
        log.info((Object)("[MPD] ** Starting MPD " + Version.MAINVERSION + "." + Version.SUBVERSION + " **"));
        this.peerCacheFile = string4 != null ? string4 : new String(this.tmpDir + System.getProperty("path.separator") + "cache.xml");
        NetIface netIface = new NetIface(string6, string7);
        this.usingIP = netIface.getExternalIfIpv4();
        if (this.usingIP == null) {
            log.error((Object)"Could not determine a working network interface. Exiting.");
            System.exit(1);
        }
        log.info((Object)("[MPD] Network: requested IFACE=" + string6 + ". Using " + netIface.getIfName() + " ip=" + this.usingIP));
        try {
            this.myURI = new URI("tcp://" + this.usingIP + ":" + n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numProcPerJob = n6;
        this.procTab = new ProcessTable();
        this.appCurrentPort = this.appMinPort;
        this.createCacheEntry(this.usingIP);
        this.diskCache = new DiskCache(string, string5);
        this.myHost = new HostEntry(this.usingIP, n, n2, n3, n7, n6);
    }

    protected void createCacheEntry(String string) {
        PeerCache peerCache = new PeerCache(this.peerCacheFile);
        String string2 = new String(string + ":" + this.mpdPort);
        peerCache.remove(string2);
        peerCache.setMpdVer(string2, Version.MAINVERSION + "." + Version.SUBVERSION);
        peerCache.setOsName(string2, System.getProperty("os.name"));
        peerCache.setArch(string2, System.getProperty("os.arch"));
        peerCache.setMpdPort(string2, Integer.toString(this.mpdPort));
        peerCache.setFdPort(string2, Integer.toString(this.fdPort));
        peerCache.setFtPort(string2, Integer.toString(this.ftPort));
        String[] stringArray = OsInfo.cpuInfo();
        String[] stringArray2 = OsInfo.memInfo();
        if (stringArray == null) {
            peerCache.setCpuName(string2, "N/A");
            peerCache.setCpuFreq(string2, "N/A");
        } else {
            peerCache.setCpuName(string2, stringArray[0]);
            peerCache.setCpuFreq(string2, stringArray[1]);
        }
        if (stringArray2 == null) {
            peerCache.setMem(string2, "N/A");
        } else {
            peerCache.setMem(string2, stringArray2[0]);
        }
        if (peerCache.saveDocument(this.peerCacheFile)) {
            log.info((Object)("[MPD] Entry created in cache " + this.peerCacheFile + " with id=" + string2));
        } else {
            log.info((Object)("[MPD] Cache entry not created. Reason: " + peerCache.getErrorStatus()));
        }
    }

    protected synchronized String getUniqueDirName() {
        return new String(NameGenerator.getUniqueName());
    }

    protected synchronized void requestPeer(String string, int n, MPDMessage mPDMessage) {
        try {
            Socket socket = new Socket(string, n);
            log.info((Object)("Assign Rank " + mPDMessage.getRank() + ": to IP:" + string));
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(mPDMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.info((Object)("[MPD] Error: failed to assign a rank to" + string + ": " + exception.toString()));
        }
    }

    protected void cancelReservation(String string, Vector<HostEntry> vector) {
        if (vector.size() == 0) {
            return;
        }
        try {
            RSMessage rSMessage = new RSMessage(5, string, this.usingIP, Version.MAINVERSION + "." + Version.SUBVERSION);
            rSMessage.setList(vector);
            Socket socket = new Socket("127.0.0.1", this.rsPort);
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(rSMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.info((Object)("[MPD] Error: could not contact RS to cancel reservation " + string));
        }
    }

    protected boolean isMyHost(HostEntry hostEntry) {
        return hostEntry.getIp().equals(this.myHost.getIp());
    }

    private static long calculateDataPresent(Vector<String> vector, Vector<FileCharacteristics> vector2) {
        Vector<FileCharacteristics> vector3 = vector2;
        long l = 0L;
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < vector3.size(); ++j) {
                if (!vector.elementAt(i).equals(vector3.elementAt(j).getMd5sum())) continue;
                l += (long)((int)(vector3.elementAt(j).getFileSize() / 1024L));
            }
        }
        return l;
    }

    private HashMap<HostEntry, Long> buildDataPresence(HashMap<String, HostEntry> hashMap, Vector<FileCharacteristics> vector) {
        HashMap<HostEntry, Long> hashMap2 = new HashMap<HostEntry, Long>();
        Iterator<Map.Entry<String, HostEntry>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HostEntry hostEntry = iterator.next().getValue();
            Vector<String> vector2 = hostEntry.getCacheMd5sums();
            long l = P2PMPI_MPD.calculateDataPresent(vector2, vector);
            hashMap2.put(hostEntry, l);
        }
        return hashMap2;
    }

    private Vector<HostEntry> buildPeerList(int n, int n2, int n3, String string, Vector<FileCharacteristics> vector) {
        int n4 = n + (int)(3.0 * (Math.log(n) / Math.log(2.0)));
        Vector<HostEntry> vector2 = new Vector<HostEntry>();
        long l = System.currentTimeMillis();
        if (string.startsWith("data")) {
            this.updateHostCache(this.superNode);
            HashMap<HostEntry, Long> hashMap = this.buildDataPresence(this.hostCache, vector);
            while (true) {
                int n5;
                ArrayList<Map.Entry<HostEntry, Long>> arrayList = new ArrayList<Map.Entry<HostEntry, Long>>(hashMap.entrySet());
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        return (int)((Long)entry2.getValue() - (Long)entry.getValue());
                    }
                });
                int n6 = 0;
                Iterator<Map.Entry<HostEntry, Long>> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    HostEntry hostEntry = iterator.next().getKey();
                    if (!hostEntry.isAlive()) continue;
                    vector2.add(hostEntry);
                    if (++n6 < n4) continue;
                    return vector2;
                }
                if (n6 < n && (n5 = (int)(System.currentTimeMillis() - l)) < n3 * 1000) {
                    vector2.clear();
                    this.updateHostCache(this.superNode);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                int n7;
                ArrayList arrayList = new ArrayList(this.hostCache.entrySet());
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        int n = ((HostEntry)entry.getValue()).getRtt();
                        int n2 = ((HostEntry)entry2.getValue()).getRtt();
                        return n - n2;
                    }
                });
                int n8 = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    HostEntry hostEntry = (HostEntry)iterator.next().getValue();
                    if (!hostEntry.isAlive()) continue;
                    vector2.add(hostEntry);
                    if (++n8 < n4) continue;
                    return vector2;
                }
                if (n8 >= n || (n7 = (int)(System.currentTimeMillis() - l)) >= n3 * 1000) break;
                vector2.clear();
                this.updateHostCache(this.superNode);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        return vector2;
    }

    protected ReservationResult searchMPD(String string, int n, int n2, int n3, String string2, Vector<FileCharacteristics> vector) {
        int n4;
        int n5;
        Object object;
        Vector<HostEntry> vector2;
        Object object2;
        Object object3;
        Object object4;
        int n6 = n * n2;
        int n7 = n2;
        log.info((Object)("[MPD] entering searchMPD (n=" + n + ",r=" + n2 + ")"));
        Vector<HostEntry> vector3 = this.buildPeerList(n6, n7, n3, string2, vector);
        int n8 = vector3.size();
        log.info((Object)("[MPD] number of hosts required: min=" + n7 + ",max=" + n6 + ",found =" + n8));
        if (n8 < n7 - 1) {
            ReservationResult reservationResult = new ReservationResult(null, 1, n8 + 1, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        RSMessage rSMessage = new RSMessage(0, string, this.usingIP, Version.MAINVERSION + "." + Version.SUBVERSION);
        rSMessage.setReservePeriod(30000 + n * n2 * 1000);
        rSMessage.setList(vector3);
        Vector<HostEntry> vector4 = null;
        Vector<HostEntry> vector5 = null;
        try {
            Socket socket = new Socket("127.0.0.1", this.rsPort);
            object4 = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            object3 = new ObjectOutputStream(outputStream);
            ((ObjectOutputStream)object3).writeObject(rSMessage);
            ((ObjectOutputStream)object3).flush();
            object2 = new ObjectInputStream((InputStream)object4);
            vector2 = ((ObjectInputStream)object2).readObject();
            object = (RSMessage)((Object)vector2);
            vector4 = ((RSMessage)object).getList();
            vector5 = ((RSMessage)object).getDeadList();
            ((ObjectInputStream)object2).close();
            ((ObjectOutputStream)object3).close();
            ((InputStream)object4).close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            log.error((Object)("[MPD] Error connecting to local RS (127.0.0.1:" + this.rsPort + ") : " + exception.toString()));
        }
        int n9 = vector5.size();
        object4 = "";
        for (n5 = 0; n5 < n9; ++n5) {
            object3 = (HostEntry)vector5.elementAt(n5);
            object2 = ((HostEntry)object3).toString();
            object4 = (String)object4 + ((HostEntry)object3).getIp() + " ";
            ((HostEntry)this.hostCache.get(object2)).setAlive(false);
        }
        log.info((Object)("[MPD] result from RS reservation request: " + vector4.size() + " reserved hosts , " + vector5.size() + " unreachable RS."));
        for (n5 = 0; n5 < vector4.size(); ++n5) {
            object3 = vector4.elementAt(n5);
            log.info((Object)("[MPD] reserved : " + ((HostEntry)object3).getIp()));
        }
        if (vector5.size() > 0) {
            log.info((Object)("[MPD] unreachable RS: " + (String)object4));
        }
        n5 = vector4.size();
        vector4.add(0, this.myHost);
        log.info((Object)("[MPD] Total of " + ++n5 + " reserved nodes"));
        if (n5 < n7) {
            vector4.remove(0);
            this.cancelReservation(string, vector4);
            ReservationResult reservationResult = new ReservationResult(null, 1, n5, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        int n10 = 0;
        for (int i = 0; i < n5; ++i) {
            vector2 = vector4.elementAt(i);
            int n11 = ((HostEntry)((Object)vector2)).getNumProcPerJob();
            log.debug((Object)("[MPD] host " + vector2 + " provides " + n11 + " process slot(s)"));
            if (this.isMyHost((HostEntry)((Object)vector2))) {
                --n11;
            }
            if (n11 > n) {
                n10 += n;
                continue;
            }
            n10 += n11;
        }
        log.debug((Object)("[MPD] total process slot(s) provided: " + n10));
        if (n10 < n6) {
            vector4.remove(0);
            this.cancelReservation(string, vector4);
            ReservationResult reservationResult = new ReservationResult(null, 2, n5, n10);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        ++n6;
        ++n;
        if (string2.startsWith("data")) {
            string2 = string2.replaceFirst("data", "");
        }
        if (string2.equalsIgnoreCase("spread")) {
            HostEntry hostEntry;
            int n12;
            Vector<ReservedHost> vector6 = new Vector<ReservedHost>();
            vector2 = new Vector<HostEntry>();
            int n13 = 0;
            int n14 = n5;
            int[] nArray = new int[n5];
            boolean bl = false;
            block5: do {
                for (n12 = 0; n12 < n14; ++n12) {
                    hostEntry = vector4.elementAt(n12);
                    if (n13 >= n6) {
                        bl = true;
                        continue block5;
                    }
                    int n15 = hostEntry.getNumProcPerJob();
                    if (nArray[n12] >= n15 || nArray[n12] >= n) continue;
                    ++n13;
                    int n16 = n12;
                    nArray[n16] = nArray[n16] + 1;
                }
            } while (!bl);
            for (n12 = 0; n12 < n14; ++n12) {
                hostEntry = vector4.elementAt(n12);
                if (nArray[n12] == 0) {
                    vector2.add(hostEntry);
                    log.info((Object)("[MPD] 'spread' alloc. Cancel reservation " + hostEntry.getIp()));
                    continue;
                }
                log.info((Object)("[MPD] 'spread' alloc. Reserve " + hostEntry.getIp()));
                object = new ReservedHost(hostEntry, nArray[n12]);
                vector6.add((ReservedHost)object);
            }
            this.cancelReservation(string, vector2);
            n12 = vector6.size();
            log.info((Object)("[MPD] spread alloc: final number of hosts reserved (including rank0): " + ++n12));
            ReservationResult reservationResult = new ReservationResult(vector6, 0, n12, 0);
            reservationResult.setMyHost(this.myHost);
            return reservationResult;
        }
        Vector<ReservedHost> vector7 = new Vector<ReservedHost>();
        vector2 = new Vector();
        int n17 = 0;
        int n18 = n5;
        int n19 = this.myHost.getNumProcPerJob();
        int n20 = n19 < n ? (n19 > n6 ? n6 : n19) : n;
        object = new ReservedHost(this.myHost, n20);
        vector7.add((ReservedHost)object);
        n17 += n20;
        for (n4 = 0; n4 < n18; ++n4) {
            HostEntry hostEntry = vector4.elementAt(n4);
            log.info((Object)("[MPD] 'concentrate' alloc. Reserve:" + hostEntry.getIp()));
            if (this.isMyHost(hostEntry)) continue;
            if (n17 >= n6) {
                vector2.add(hostEntry);
                continue;
            }
            n19 = hostEntry.getNumProcPerJob();
            n20 = n19 < n ? (n17 + n19 > n6 ? n6 - n17 : n19) : (n17 + n > n6 ? n6 - n17 : n);
            object = new ReservedHost(hostEntry, n20);
            vector7.add((ReservedHost)object);
            n17 += n20;
        }
        this.cancelReservation(string, vector2);
        n4 = vector7.size();
        log.info((Object)("[MPD] concentrate alloc: final number of hosts reserved (including rank0): " + ++n4));
        ReservationResult reservationResult = new ReservationResult(vector7, 0, n4, 0);
        reservationResult.setMyHost(this.myHost);
        return reservationResult;
    }

    @Override
    public void run() {
        if (!this.joinMpiGroup(this.superNode)) {
            System.err.println("** [MPD Error] : could not contact SuperNode at " + this.superNode.toString() + ". Exiting.");
            log.info((Object)("[MPD Error]: could not contact SuperNode at " + this.superNode.toString() + ". Exiting."));
            System.exit(1);
        }
        this.updateHostCache(this.superNode);
        MPD_Interface mPD_Interface = new MPD_Interface(this);
        mPD_Interface.start();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new PeerKeepAlive(this.superNode, this.myHost, this.diskCache), 0L, 180000L);
        Timer timer2 = new Timer();
        timer2.schedule((TimerTask)new PeerUpdateList(this.superNode, this.myHost, this.hostCache), 0L, 300000L);
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(log);
        P2PMPI_MPD p2PMPI_MPD = new P2PMPI_MPD(p2PMPI_ConfigFile.getMPDPort(), p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getFTPort(), p2PMPI_ConfigFile.getMinPort(), p2PMPI_ConfigFile.getMaxPort(), file.toString(), p2PMPI_ConfigFile.getProperties(), p2PMPI_ConfigFile.getHostDeny(), p2PMPI_ConfigFile.getHostAllow(), p2PMPI_ConfigFile.getNumProcPerJob(), p2PMPI_ConfigFile.getRSPort(), p2PMPI_ConfigFile.getNumCPU(), p2PMPI_ConfigFile.getSuperNode(), p2PMPI_ConfigFile.getPeerCacheFile(), p2PMPI_ConfigFile.getDiskCacheDir(), p2PMPI_ConfigFile.getIface(), p2PMPI_ConfigFile.getExternalIP());
        p2PMPI_MPD.start();
    }
}

