/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.ft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RemoteData {
    private URL url;
    private byte[] data = null;
    private String mimeType = null;
    private byte[] mybytearray;

    RemoteData(String address) throws MalformedURLException, IOException {
        this.url = new URL(address);
    }

    public void setMimeType(String address) throws MalformedURLException, IOException {
        URLConnection conn = this.url.openConnection();
        this.mimeType = conn.getContentType();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean setContentandWriteToFile(String filename) throws MalformedURLException, IOException {
        File file = new File(filename);
        URLConnection conn = this.url.openConnection();
        boolean documentSet = true;
        int buffersize = 0x1400000;
        int bytesRead = 0;
        boolean current = false;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            do {
                try {
                    System.gc();
                    this.mybytearray = new byte[buffersize];
                }
                catch (OutOfMemoryError e) {
                    System.out.println("** [FT] Not enough memory when trying to allocate " + buffersize + " bytes.");
                }
                InputStream input = conn.getInputStream();
                bytesRead = input.read(this.mybytearray, 0, buffersize);
                if (bytesRead == -1) continue;
                fos.write(this.mybytearray, 0, bytesRead);
            } while (bytesRead != -1);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return documentSet;
    }

    public String getMD5Sum() {
        if (this.data == null) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(this.data);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("** [Error] MD5sum is not implemented by the JVM.");
        }
        BigInteger md5sum = new BigInteger(1, md.digest());
        return md5sum.toString(16);
    }

    public static void main(String[] args) throws MalformedURLException, IOException {
        RemoteData myinput = new RemoteData(args[0]);
    }
}

