/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.ft;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Vector;
import p2pmpi.common.DiskCache;
import p2pmpi.common.FileCharacteristics;
import p2pmpi.common.NetIface;
import p2pmpi.common.OsInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.ReservedPort;
import p2pmpi.common.StreamSaver;
import p2pmpi.ft.RemoteData;
import p2pmpi.message.FTMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.RequestQuitMessage;

public class FileTransferServer {
    private static int XFER_PROTOCOL_SWITCH_LIMIT = 0x1400000;
    private int serverPort;
    private int mpdPort;
    private String baseDir;
    private DiskCache diskCache = null;
    private static String hostIP = null;
    private static String osname = OsInfo.getName();
    private URI rank0URI;
    private Vector<FileCharacteristics> fileCharacteristicsVector;

    public FileTransferServer(int serverPort, int mpdPort, String dir, String diskCacheDir, String diskCacheSize) {
        this.serverPort = serverPort;
        this.mpdPort = mpdPort;
        this.baseDir = dir;
        this.diskCache = new DiskCache(dir, diskCacheDir, diskCacheSize);
        System.out.println("[FT] Service starting (port=" + serverPort + ", cache size=" + this.diskCache.getSize() + ", dir=" + this.diskCache.getDir() + ")");
    }

    private static void setLocalhostIP() {
        P2PMPI_ConfigFile conf = new P2PMPI_ConfigFile();
        NetIface extIf = new NetIface(conf.getIface(), conf.getExternalIP());
        hostIP = extIf.getExternalIfIpv4();
    }

    protected static String getLocalhostIP() {
        return hostIP;
    }

    private void sendMessage(Object message, URI destination) {
        OutputStream out = null;
        ObjectOutputStream oos = null;
        Socket soc = null;
        try {
            soc = new Socket(destination.getHost(), destination.getPort());
            out = soc.getOutputStream();
            oos = new ObjectOutputStream(out);
            oos.writeObject(message);
            oos.flush();
            oos.close();
            out.close();
            soc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long writeFileToSocket(String filename, long filesize, OutputStream os) throws Exception {
        int buffersize = 0xA00000;
        byte[] buffer = new byte[buffersize];
        long totalBytesRead = 0L;
        int bytesRead = 0;
        System.out.println("[FT] sending file " + filename + ", size=" + filesize);
        File myFile = new File(filename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(myFile);
        }
        catch (Exception e) {
            System.out.println("** [FT] Error trying to access file " + filename);
            e.printStackTrace();
            throw new Exception(e);
        }
        do {
            try {
                bytesRead = fis.read(buffer, 0, buffersize);
                if (-1 == bytesRead) continue;
                totalBytesRead += (long)bytesRead;
                os.write(buffer, 0, bytesRead);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (totalBytesRead < filesize && -1 != bytesRead);
        System.out.println("[FT] done sending file " + filename + ", total sent" + totalBytesRead);
        try {
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalBytesRead;
    }

    public void start() {
        FileTransferServer.setLocalhostIP();
        ServerSocket servSocket = null;
        Socket socket = null;
        try {
            servSocket = new ServerSocket(this.serverPort);
        }
        catch (Exception e) {
            System.err.println("** [Error] FT: Can't bind port.");
            e.printStackTrace();
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    socket = servSocket.accept();
                    FileTransfer ft = new FileTransfer(socket);
                    ft.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        File tmpDir = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile();
        FileTransferServer ftServer = new FileTransferServer(ppConf.getFTPort(), ppConf.getMPDPort(), tmpDir.toString(), ppConf.getDiskCacheDir(), ppConf.getDiskCacheSize());
        ftServer.start();
        System.out.println("Starting FT ...");
    }

    static /* synthetic */ int access$000(FileTransferServer x0) {
        return x0.mpdPort;
    }

    static /* synthetic */ URI access$102(FileTransferServer x0, URI x1) {
        x0.rank0URI = x1;
        return x0.rank0URI;
    }

    static /* synthetic */ Vector access$202(FileTransferServer x0, Vector x1) {
        x0.fileCharacteristicsVector = x1;
        return x0.fileCharacteristicsVector;
    }

    static /* synthetic */ Vector access$200(FileTransferServer x0) {
        return x0.fileCharacteristicsVector;
    }

    static /* synthetic */ int access$300() {
        return XFER_PROTOCOL_SWITCH_LIMIT;
    }

    static /* synthetic */ int access$400(FileTransferServer x0) {
        return x0.serverPort;
    }

    static /* synthetic */ void access$500(FileTransferServer x0, Object x1, URI x2) {
        x0.sendMessage(x1, x2);
    }

    static /* synthetic */ String access$600(FileTransferServer x0) {
        return x0.baseDir;
    }

    static /* synthetic */ DiskCache access$700(FileTransferServer x0) {
        return x0.diskCache;
    }

    static /* synthetic */ long access$800(FileTransferServer x0, String x1, long x2, OutputStream x3) throws Exception {
        return x0.writeFileToSocket(x1, x2, x3);
    }

    static /* synthetic */ URI access$100(FileTransferServer x0) {
        return x0.rank0URI;
    }

    public class FileTransfer
    extends Thread {
        Socket socket;

        public FileTransfer(Socket socket) {
            this.socket = socket;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block61: {
                block60: {
                    localMPDURI = null;
                    in = null;
                    ois = null;
                    oMsg = null;
                    replyURI = null;
                    ftMsg = null;
                    doneMsg = null;
                    onlyFileNameList = null;
                    jarDep = "";
                    myRank = 0;
                    try {
                        localMPDURI = new URI("tcp://127.0.0.1:" + FileTransferServer.access$000(FileTransferServer.this));
                    }
                    catch (URISyntaxException e) {
                        System.out.println("[FT] internal error: malformed URI: " + localMPDURI.toString());
                    }
                    conf = new P2PMPI_ConfigFile();
                    try {
                        in = this.socket.getInputStream();
                        ois = new ObjectInputStream(in);
                        oMsg = ois.readObject();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    if (!(oMsg instanceof RequestQuitMessage)) break block60;
                    System.exit(0);
                    break block61;
                }
                if (!(oMsg instanceof FTMessage)) break block61;
                ftMsg = (FTMessage)oMsg;
                switch (ftMsg.getCmd()) {
                    case 4: {
                        System.out.println("[FT] received FTMessage with FT_REGISTER");
                        try {
                            replyURI = new URI("tcp://" + FileTransferServer.getLocalhostIP() + ":" + conf.getFTPort());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        numPeers = ftMsg.size();
                        FileTransferServer.access$102(FileTransferServer.this, ftMsg.getRank0URI());
                        FileTransferServer.access$202(FileTransferServer.this, ftMsg.getFileCharacteristicsVector());
                        numFile = FileTransferServer.access$200(FileTransferServer.this).size();
                        fullFileNameList = new String[numFile];
                        onlyFileNameList = new String[numFile];
                        for (i = 0; i < numFile; ++i) {
                            fullFileNameList[i] = ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileName();
                            onlyFileNameList[i] = ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getOnlyFileName();
                        }
                        DataTransferThroughNewChannel = false;
                        for (i = 0; i < numFile; ++i) {
                            if (!((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).isToBeCached()) continue;
                            DataTransferThroughNewChannel = true;
                            break;
                        }
                        if (!DataTransferThroughNewChannel) {
                            totalFileSize = 0L;
                            for (i = 0; i < numFile; ++i) {
                                if (((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileName().startsWith("http://") || (totalFileSize += ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileSize()) <= (long)FileTransferServer.access$300()) continue;
                                DataTransferThroughNewChannel = true;
                                break;
                            }
                        }
                        if (!DataTransferThroughNewChannel) {
                            okRemoteTransfer = true;
                            ftMsgDataContained = new FTMessage(17, ftMsg.getID());
                            ftMsgDataContained.setOnlyFileNameList(onlyFileNameList);
                            try {
                                ftMsgDataContained.setFileContent(fullFileNameList);
                            }
                            catch (Exception e) {
                                System.out.println("[FT] failed loading files for transfer. Send a failure notice to MPD.");
                                failMsg = new MPDMessage(7, ftMsg.getID());
                                failMsg.setURI(FileTransferServer.getLocalhostIP(), FileTransferServer.access$400(FileTransferServer.this));
                                failMsg.setErrorMessage(e.getMessage());
                                FileTransferServer.access$500(FileTransferServer.this, failMsg, localMPDURI);
                                System.out.println("[FT] failed loading files for transfer. Send a failure notice to rank0:" + ftMsg.getRank0URI().toString());
                                FileTransferServer.access$500(FileTransferServer.this, failMsg, ftMsg.getRank0URI());
                                okRemoteTransfer = false;
                            }
                            if (!okRemoteTransfer) break;
                            for (i = 0; i < numPeers; ++i) {
                                ftMsgDataContained.setKey(ftMsg.getKey(i));
                                destination = ftMsg.getURI(i);
                                System.out.println("[FT] constructing message for peer " + i + ": rank " + ftMsg.getKey(i) + " URI:" + ftMsg.getURI(i));
                                FileTransferServer.access$500(FileTransferServer.this, ftMsgDataContained, destination);
                            }
                            break;
                        }
                        ftMsg.setCmd(15);
                        ftMsg.setReplyURI(replyURI);
                        for (i = 0; i < numPeers; ++i) {
                            ftMsg.setKey(ftMsg.getKey(i));
                            destination = ftMsg.getURI(i);
                            System.out.println("[FT] constructing Request Port message for peer " + i + ": rank " + ftMsg.getKey(i) + " URI:" + ftMsg.getURI(i));
                            FileTransferServer.access$500(FileTransferServer.this, ftMsg, destination);
                        }
                        break;
                    }
                    case 17: {
                        appDir = new File(FileTransferServer.access$600(FileTransferServer.this), ftMsg.getID() + "--" + ftMsg.getKey());
                        appDir.mkdirs();
                        onlyFileNameList = ftMsg.getOnlyFileNameList();
                        for (i = 0; i < onlyFileNameList.length; ++i) {
                            if (onlyFileNameList[i].endsWith(".jar")) {
                                jarDep = jarDep + File.pathSeparator + onlyFileNameList[i];
                            }
                            if (onlyFileNameList[i].startsWith("http://")) {
                                parts = onlyFileNameList[i].split(File.separator);
                                try {
                                    remoteFile = new RemoteData(onlyFileNameList[i]);
                                    if (remoteFile.setContentandWriteToFile(appDir + File.separator + parts[parts.length - 1])) continue;
                                    System.err.println("** [Error] could not fetch contents hosted at " + onlyFileNameList[i]);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    failMsg = new MPDMessage(7, ftMsg.getID());
                                    failMsg.setURI(FileTransferServer.getLocalhostIP(), FileTransferServer.access$400(FileTransferServer.this));
                                    failMsg.setErrorMessage(e.getMessage());
                                    FileTransferServer.access$500(FileTransferServer.this, failMsg, ftMsg.getRank0URI());
                                }
                                continue;
                            }
                            appFile = new File(appDir, onlyFileNameList[i]);
                            try {
                                fileOut = new FileOutputStream(appFile);
                                fileOut.write(ftMsg.getFileContent(i));
                                fileOut.flush();
                                fileOut.close();
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (jarDep.equals("")) {
                            jarDep = "_";
                        }
                        System.out.println("[FT] Done transfer file for ID = " + ftMsg.getID() + ". Going to send a MPDMessage FT_DONE to localhost (myRank=" + myRank);
                        doneMsg = new MPDMessage(6, ftMsg.getID());
                        myRank = ftMsg.getKey();
                        doneMsg.setKey(myRank);
                        doneMsg.setRunDir(appDir);
                        doneMsg.setJars(jarDep);
                        FileTransferServer.access$500(FileTransferServer.this, doneMsg, localMPDURI);
                        System.out.println("[FT] Done notify my local MPD " + localMPDURI.toString());
                        break;
                    }
                    case 15: {
                        System.out.println("[FT] received FTMessage with FT_REQUESTPORT");
                        cacheIsChanged = false;
                        FileTransferServer.access$202(FileTransferServer.this, ftMsg.getFileCharacteristicsVector());
                        numFile = FileTransferServer.access$200(FileTransferServer.this).size();
                        minPort = conf.getMinPort();
                        maxPort = conf.getMaxPort();
                        portToTransferData = new ReservedPort(minPort, maxPort);
                        servsock = portToTransferData.getPort();
                        try {
                            replyURI = new URI("tcp://" + FileTransferServer.getLocalhostIP() + ":" + portToTransferData.getPortNumber());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.print("[FT] status of files marked cached [");
                        notToBeSent = new boolean[numFile];
                        Arrays.fill(notToBeSent, false);
                        sizeReqInCache = 0L;
                        for (j = 0; j < numFile; ++j) {
                            if (!((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(j)).isToBeCached()) continue;
                            System.out.print(((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(j)).getOnlyFileName());
                            sizeReqInCache += ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(j)).getFileSize();
                            currentMd5 = ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(j)).getMd5sum();
                            matchingFiles = FileTransferServer.access$700(FileTransferServer.this).searchByMd5(currentMd5);
                            if (!matchingFiles.isEmpty()) {
                                notToBeSent[j] = true;
                                System.out.print("(^) ");
                                continue;
                            }
                            System.out.print("(_) ");
                        }
                        System.out.println("] ^:already present, _:not yet cached");
                        cacheFit = false;
                        if (sizeReqInCache <= FileTransferServer.access$700(FileTransferServer.this).getSize()) {
                            cacheFit = true;
                        } else {
                            System.out.println("[FT] All files can't be cached so copied only to execution directory for the successful execution.Size Required in Cache is " + sizeReqInCache + " bytes But the cache " + "size is only " + FileTransferServer.access$700(FileTransferServer.this).getSize() + " bytes");
                        }
                        appDir = new File(FileTransferServer.access$600(FileTransferServer.this), ftMsg.getID() + "--" + ftMsg.getKey());
                        appDir.mkdirs();
                        ftMsgWithDataTransferPort = new FTMessage(16, ftMsg.getID());
                        ftMsgWithDataTransferPort.setKey(0);
                        ftMsgWithDataTransferPort.setReplyURI(replyURI);
                        ftMsgWithDataTransferPort.setBooleanSent(notToBeSent);
                        destination = null;
                        try {
                            destination = ftMsg.getReplyURI();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println("[FT] Sending FT_0 to which socket data should be transferred");
                        FileTransferServer.access$500(FileTransferServer.this, ftMsgWithDataTransferPort, destination);
                        soc = null;
                        is = null;
                        try {
                            soc = servsock.accept();
                            is = soc.getInputStream();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println("[FT] Accepted connection : " + soc);
                        bos = null;
                        fos = null;
                        for (i = 0; i < numFile; ++i) {
                            f = (FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i);
                            if (!f.getOnlyFileName().startsWith("http://")) ** GOTO lbl218
                            parts = f.getOnlyFileName().split(File.separator);
                            try {
                                remoteFile = new RemoteData(f.getOnlyFileName());
                                if (!remoteFile.setContentandWriteToFile(appDir + File.separator + parts[parts.length - 1])) {
                                    System.err.println("** [Error] could not fetch contents hosted at " + f.getOnlyFileName());
                                }
                                ** GOTO lbl230
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                failMsg = new MPDMessage(7, ftMsg.getID());
                                failMsg.setURI(FileTransferServer.getLocalhostIP(), FileTransferServer.access$400(FileTransferServer.this));
                                failMsg.setErrorMessage(e.getMessage());
                                FileTransferServer.access$500(FileTransferServer.this, failMsg, ftMsg.getRank0URI());
                            }
                            ** GOTO lbl230
lbl218:
                            // 1 sources

                            if (cacheFit) {
                                if (!notToBeSent[i]) {
                                    v0 = cached = f.isToBeCached() != false && FileTransferServer.access$700(FileTransferServer.this).writeToLRU(is, f.getOnlyFileName(), f.getFileSize()) != false;
                                    if (cached) {
                                        cacheIsChanged = true;
                                    }
                                    if (!cached && (bytesRead = (sv = new StreamSaver()).saveNetworkInputStream(appDir, f.getOnlyFileName(), f.getFileSize(), is)) != f.getFileSize()) {
                                        System.out.println("[FT] internal error for file " + f.getOnlyFileName() + ": advertized=" + f.getFileSize() + ", read=" + bytesRead);
                                    }
                                }
                            } else {
                                sv = new StreamSaver();
                                bytesRead = sv.saveNetworkInputStream(appDir, f.getOnlyFileName(), f.getFileSize(), is);
                                if (bytesRead != f.getFileSize()) {
                                    System.out.println("[FT] internal error for file " + f.getOnlyFileName() + ": advertized=" + f.getFileSize() + ", read=" + bytesRead);
                                }
                            }
lbl230:
                            // 7 sources

                            if (!f.getOnlyFileName().endsWith(".jar")) continue;
                            jarDep = jarDep + File.pathSeparator + f.getOnlyFileName();
                        }
                        if (cacheFit && (returnvalue = FileTransferServer.access$700(FileTransferServer.this).publishFiles(appDir, FileTransferServer.access$200(FileTransferServer.this))) == -1) {
                            System.out.println("[Error] Data in Disk Cache could not be reflected (linked or copied, depending on the OS) to working directory.");
                        }
                        try {
                            soc.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (jarDep.equals("")) {
                            jarDep = "_";
                        }
                        System.out.println("[FT] Done transfer file for ID = " + ftMsg.getID() + ". Going to send a MPDMessage FT_DONE to localhost (myRank=" + myRank);
                        doneMsg = new MPDMessage(6, ftMsg.getID());
                        myRank = ftMsg.getKey();
                        doneMsg.setKey(myRank);
                        doneMsg.setRunDir(appDir);
                        doneMsg.setJars(jarDep);
                        doneMsg.setCacheIsChanged(cacheIsChanged);
                        FileTransferServer.access$500(FileTransferServer.this, doneMsg, localMPDURI);
                        System.out.println("[FT] Done notify my local MPD " + localMPDURI.toString());
                        break;
                    }
                    case 16: {
                        sock = null;
                        os = null;
                        uri = ftMsg.getReplyURI();
                        ip = uri.getHost();
                        port = uri.getPort();
                        numFile = FileTransferServer.access$200(FileTransferServer.this).size();
                        notToBeSent = ftMsg.getBooleanSent();
                        System.out.println("[FT] received FTMessage with FT_ASSIGNEDPORT. Start sending to " + uri);
                        try {
                            sock = new Socket(ip, port);
                            os = sock.getOutputStream();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        for (i = 0; i < numFile; ++i) {
                            if (((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileName().startsWith("http://")) continue;
                            try {
                                if (notToBeSent[i]) continue;
                                FileTransferServer.access$800(FileTransferServer.this, ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileName(), ((FileCharacteristics)FileTransferServer.access$200(FileTransferServer.this).elementAt(i)).getFileSize(), os);
                                continue;
                            }
                            catch (Exception e) {
                                failMsg = new MPDMessage(7, ftMsg.getID());
                                failMsg.setURI(FileTransferServer.getLocalhostIP(), FileTransferServer.access$400(FileTransferServer.this));
                                failMsg.setErrorMessage(e.getMessage());
                                FileTransferServer.access$500(FileTransferServer.this, failMsg, localMPDURI);
                                System.out.println("[FT] failed loading files for transfer. Send a failure notice to rank0:" + ftMsg.getRank0URI().toString());
                                FileTransferServer.access$500(FileTransferServer.this, failMsg, FileTransferServer.access$100(FileTransferServer.this));
                            }
                        }
                        System.out.println("[FT] all files sent throught socket");
                        try {
                            sock.close();
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        System.err.println("** [Error] FTMessage: Unknown Command.");
                    }
                }
            }
        }
    }
}

