/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.fd;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.GossipConfig;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.fd.BRR;
import p2pmpi.fd.DBRR;
import p2pmpi.fd.GossipDetector;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.GossipPingReplyMessage;
import p2pmpi.message.RequestQuitMessage;

public class GossipDetectorServer {
    protected static Logger logGos;
    private int serverPort;
    private int mpdPort;
    protected Timer timer;
    Hashtable<String, Vector<GossipDetector>> hashtable;

    public GossipDetectorServer(int n, int n2) {
        this.serverPort = n;
        this.mpdPort = n2;
        this.hashtable = new Hashtable();
        this.timer = new Timer();
        logGos = Logger.getLogger((String)"MPD");
        logGos.info((Object)"[GossipDetectorServer] is online ...");
    }

    public void start() {
        this.timer.schedule((TimerTask)new CheckService(), 0L, (long)GossipConfig.t_checkalive);
        ServerSocket serverSocket = null;
        Socket socket = null;
        Object object = null;
        Vector<GossipDetector> vector = null;
        try {
            serverSocket = new ServerSocket(this.serverPort);
        }
        catch (Exception exception) {
            System.out.println("FD : Can't bind port (" + this.serverPort + ")");
            exception.printStackTrace();
            System.exit(1);
        }
        block10: while (true) {
            try {
                while (true) {
                    InputStream inputStream;
                    ObjectInputStream objectInputStream;
                    if ((object = (objectInputStream = new ObjectInputStream(inputStream = (socket = serverSocket.accept()).getInputStream())).readObject()) instanceof RequestQuitMessage) {
                        logGos.info((Object)"[GossipServer]: shutdown");
                        System.exit(0);
                    }
                    GossipMessage gossipMessage = (GossipMessage)object;
                    block2 : switch (gossipMessage.getCommand()) {
                        case 0: {
                            String string = gossipMessage.getGossipID();
                            vector = this.hashtable.get(string);
                            String string2 = gossipMessage.getGossipProtocol();
                            logGos.debug((Object)("[GossipServer] register detector hashID=" + string + " (rank=" + gossipMessage.getMyRank() + ",protocol=" + string2 + ")"));
                            GossipDetector gossipDetector = string2.equalsIgnoreCase("BRR") ? new BRR(gossipMessage.getMyRank(), string, gossipMessage.getMPIPort(), gossipMessage.getURIList(), this.mpdPort, gossipMessage.getMPIRank(), gossipMessage.getTGossip(), gossipMessage.getTMargin(), gossipMessage.getTDiff(), gossipMessage.getTStamp(), gossipMessage.getTHang()) : new DBRR(gossipMessage.getMyRank(), string, gossipMessage.getMPIPort(), gossipMessage.getURIList(), this.mpdPort, gossipMessage.getMPIRank(), gossipMessage.getTGossip(), gossipMessage.getTMargin(), gossipMessage.getTDiff(), gossipMessage.getTStamp(), gossipMessage.getTHang());
                            if (vector == null) {
                                vector = new Vector();
                                vector.addElement(gossipDetector);
                                this.hashtable.put(string, vector);
                            } else {
                                logGos.debug((Object)"[GossipServer] register a detector same hashID second time");
                                vector.addElement(gossipDetector);
                            }
                            new Thread(gossipDetector).start();
                            break;
                        }
                        case 1: {
                            GossipDetector gossipDetector;
                            String string = gossipMessage.getGossipID();
                            int n = gossipMessage.getToRank();
                            vector = this.hashtable.get(string);
                            if (vector == null) continue block10;
                            int n2 = vector.size();
                            int n3 = 0;
                            while (true) {
                                if (n3 >= n2) continue block10;
                                gossipDetector = vector.elementAt(n3);
                                if (gossipDetector.getMyRank() == n) {
                                    gossipDetector.merge(gossipMessage.getHeartBeatList());
                                    break block2;
                                }
                                ++n3;
                            }
                        }
                        case 14: {
                            GossipDetector gossipDetector;
                            long l = -1L;
                            String string = gossipMessage.getGossipID();
                            int n = gossipMessage.getToRank();
                            vector = this.hashtable.get(string);
                            if (vector != null) {
                                int n4 = vector.size();
                                for (int i = 0; i < n4; ++i) {
                                    gossipDetector = vector.elementAt(i);
                                    if (gossipDetector.getMyRank() != n) continue;
                                    l = gossipDetector.getCurrentHeartBeat();
                                    break;
                                }
                            }
                            OutputStream outputStream = socket.getOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                            GossipPingReplyMessage gossipPingReplyMessage = new GossipPingReplyMessage(l);
                            objectOutputStream.writeObject(gossipPingReplyMessage);
                            objectOutputStream.flush();
                            logGos.info((Object)("[GossipServer] reply to suspicion from " + n + " by sending " + l));
                            break;
                        }
                        case 2: {
                            GossipDetector gossipDetector;
                            String string = gossipMessage.getGossipID();
                            int n = gossipMessage.getMyRank();
                            vector = this.hashtable.get(string);
                            logGos.info((Object)("[GossipServer] unregister request from app. hashID=" + string + " (rank=" + n + ")"));
                            if (vector != null) {
                                int n5 = vector.size();
                                for (int i = 0; i < n5; ++i) {
                                    gossipDetector = vector.elementAt(i);
                                    if (gossipDetector.getMyRank() != n) continue;
                                    gossipDetector.stop();
                                    vector.removeElementAt(i);
                                    break;
                                }
                            }
                            if (vector.size() != 0) continue block10;
                            this.hashtable.remove(string);
                            break;
                        }
                        default: {
                            logGos.debug((Object)"[GossipServer] received an unknown message");
                        }
                    }
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        GossipDetectorServer gossipDetectorServer = new GossipDetectorServer(p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getMPDPort());
        gossipDetectorServer.start();
    }

    public class CheckService
    extends TimerTask {
        public void run() {
            Enumeration<String> enumeration = GossipDetectorServer.this.hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Vector<GossipDetector> vector = GossipDetectorServer.this.hashtable.get(string);
                if (vector == null) continue;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    GossipDetector gossipDetector = vector.elementAt(i);
                    if (gossipDetector.isAlive()) continue;
                    gossipDetector.stop();
                    vector.removeElementAt(i);
                    n = vector.size();
                    --i;
                }
                if (vector.size() != 0) continue;
                GossipDetectorServer.this.hashtable.remove(string);
            }
        }
    }
}

