/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.File;
import java.net.URI;
import org.apache.log4j.Logger;
import p2pmpi.common.GenericConfigFile;

public class P2PMPI_ConfigFile
extends GenericConfigFile {
    static String numCPU = "NUM_CPU";
    static String mpdPort = "MPD_PORT";
    static String ftPort = "FT_PORT";
    static String fdPort = "FD_PORT";
    static String jxtaMinPort = "MIN_PORT";
    static String jxtaMaxPort = "MAX_PORT";
    static String tmpDir = "TMP_DIR";
    static String externalIP = "EXTERNAL_IP";
    static String hostDeny = "HOST_DENY";
    static String hostAllow = "HOST_ALLOW";
    static String t_gossip = "T_GOSSIP";
    static String t_margin = "T_MAX_STARTUP";
    static String gossipProtocol = "GOSSIP_PROTOCOL";
    static String t_hang = "T_MAX_HANG";
    static String numProcPerJob = "MAX_PROCESSES_PER_JOB";
    static String maxJob = "MAX_JOBS";
    static String rsPort = "RS_PORT";
    static String iFace = "IFACE";
    static String peerCache = "PEER_CACHE";
    static String diskCacheDir = "DISK_CACHE_DIR";
    static String diskCacheSize = "DISK_CACHE_SIZE";
    static int t_gossip_default = 500;
    static int t_hang_default = 0;
    static String supernode = "SUPERNODE";
    static String visuproxy = "VISU_PROXY";
    Logger logger = null;

    public P2PMPI_ConfigFile(String fileName) {
        super(fileName);
    }

    public P2PMPI_ConfigFile(String fileName, Logger logger) {
        super(fileName);
        this.logger = logger;
    }

    public P2PMPI_ConfigFile() {
        String conffilename = System.getProperty("P2PMPI_CONF_FILE");
        String envPath = System.getProperty("P2PMPI_HOME");
        if (envPath == null || envPath.equals("")) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        File configFile = null;
        if (conffilename == null || conffilename.equals("")) {
            conffilename = "P2P-MPI.conf";
            configFile = new File(envPath, conffilename);
        } else {
            configFile = new File(conffilename);
        }
        try {
            if (configFile.isFile()) {
                super.setFileName(configFile.toString());
            } else {
                System.err.println("[Error] cannot access configuration file:" + conffilename + ". Exiting.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public P2PMPI_ConfigFile(Logger logger) {
        this.logger = logger;
        String conffilename = System.getProperty("P2PMPI_CONF_FILE");
        String envPath = System.getProperty("P2PMPI_HOME");
        if (envPath == null || envPath.equals("")) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        File configFile = null;
        if (conffilename == null || conffilename.equals("")) {
            conffilename = "P2P-MPI.conf";
            configFile = new File(envPath, conffilename);
        } else {
            configFile = new File(conffilename);
        }
        try {
            if (configFile.isFile()) {
                super.setFileName(configFile.toString());
            } else {
                System.err.println("[Error] cannot access configuration file:" + conffilename + ". Exiting.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public URI getSuperNode() {
        try {
            return new URI(this.getProperty(supernode));
        }
        catch (Exception e) {
            return null;
        }
    }

    public URI getVisuProxy() {
        try {
            return new URI(this.getProperty(visuproxy));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getGossipProtocol() {
        String protocol = this.getProperty(gossipProtocol);
        if (protocol == null) {
            return "DBRR";
        }
        if (!protocol.equalsIgnoreCase("DBRR") && !protocol.equalsIgnoreCase("BRR")) {
            return "DBRR";
        }
        return protocol;
    }

    public int getNumCPU() {
        int nCPU;
        try {
            nCPU = Integer.parseInt(this.getProperty(numCPU));
        }
        catch (Exception e) {
            return 1;
        }
        if (nCPU <= 1) {
            return 1;
        }
        return nCPU;
    }

    public int getTGossip() {
        try {
            int t = Integer.parseInt(this.getProperty(t_gossip));
            if (t < t_gossip_default) {
                return t_gossip_default;
            }
            return Integer.parseInt(this.getProperty(t_gossip));
        }
        catch (Exception e) {
            return t_gossip_default;
        }
    }

    public int getTHang() {
        try {
            return Integer.parseInt(this.getProperty(t_hang));
        }
        catch (Exception e) {
            return t_hang_default;
        }
    }

    public int getFTPort() {
        return Integer.parseInt(this.getProperty(ftPort));
    }

    public int getFDPort() {
        return Integer.parseInt(this.getProperty(fdPort));
    }

    public int getMPDPort() {
        return Integer.parseInt(this.getProperty(mpdPort));
    }

    public int getMinPort() {
        return Integer.parseInt(this.getProperty(jxtaMinPort));
    }

    public int getMaxPort() {
        return Integer.parseInt(this.getProperty(jxtaMaxPort));
    }

    public int getMaxJob() {
        return Integer.parseInt(this.getProperty(maxJob, this.logger));
    }

    public int getNumProcPerJob() {
        String nppj = this.getProperty(numProcPerJob, this.logger);
        if (nppj == null) {
            return 1;
        }
        return Integer.parseInt(nppj);
    }

    public String getTempDirectory() {
        return this.getProperty(tmpDir);
    }

    public String getExternalIP() {
        return this.getProperty(externalIP);
    }

    public String getHostDeny() {
        return this.getProperty(hostDeny);
    }

    public String getHostAllow() {
        return this.getProperty(hostAllow);
    }

    public int getRSPort() {
        return Integer.parseInt(this.getProperty(rsPort));
    }

    public String getIface() {
        return this.getProperty(iFace);
    }

    public String getPeerCacheFile() {
        return this.getProperty(peerCache);
    }

    public String getDiskCacheDir() {
        return this.getProperty(diskCacheDir);
    }

    public String getDiskCacheSize() {
        return this.getProperty(diskCacheSize);
    }
}

