/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.GenericConfigFile;
import p2pmpi.common.HostEntry;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.p2p.message.QuitMessage;
import p2pmpi.p2p.message.RegisterMessage;
import p2pmpi.p2p.message.UnregisterMessage;
import p2pmpi.p2p.message.UpdateListMessage;
import p2pmpi.tools.SupernodeHostCacheDisplay;

public class VisuProxy
extends Thread {
    private static String[] options = new String[]{"-h", "--help", null, "Display this help message.", "-u", "--updateFreq", "n", "Set update frequency to every n seconds."};
    private static final String portPropName = "VisuProxyListenPort";
    private static final String proxyConfFile = "P2P-RDV.conf";
    private static int listenPort;
    private static int updateFreq;
    private URI supernodeUri = null;
    protected Vector<Client> clientList = null;
    protected Vector<HostEntry> peerList = null;
    protected static Logger log;

    public VisuProxy() {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        this.supernodeUri = p2PMPI_ConfigFile.getSuperNode();
        this.clientList = new Vector();
        log = Logger.getLogger((String)"VISU");
    }

    public VisuProxy(int n) {
        updateFreq = Math.max(5, n);
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        this.supernodeUri = p2PMPI_ConfigFile.getSuperNode();
        this.clientList = new Vector();
        log = Logger.getLogger((String)"VISU");
    }

    private boolean sendUpdate(String string, int n, Object object) {
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        Socket socket = null;
        try {
            StatQueryMessage statQueryMessage = new StatQueryMessage();
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, 5000);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Client getClient(String string) {
        for (int i = 0; i < this.clientList.size(); ++i) {
            if (!this.clientList.get((int)i).id.equals(string)) continue;
            return this.clientList.get(i);
        }
        return null;
    }

    public void run() {
        Object object;
        File file = new File(System.getProperty("P2PMPI_HOME"), proxyConfFile);
        GenericConfigFile genericConfigFile = new GenericConfigFile(file.toString());
        String string = genericConfigFile.getProperty(portPropName);
        if (string == null) {
            System.err.println("[Error] can not find a valid port under property \"VisuProxyListenPort\" in configuration file P2P-RDV.conf. Exiting.");
            System.exit(1);
        }
        listenPort = Integer.parseInt(string);
        ServerSocket serverSocket = null;
        try {
            object = "Listening on port " + listenPort;
            System.out.println((String)object);
            log.info((Object)("[VisuProxy] " + (String)object));
            serverSocket = new ServerSocket(listenPort);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(((File)object).toString());
        URI uRI = p2PMPI_ConfigFile.getSuperNode();
        System.out.println("Visu Proxy starting connection thread with supernode...");
        ContactSupernodeThread contactSupernodeThread = new ContactSupernodeThread(uRI);
        contactSupernodeThread.setName("Connection with Supernode thread");
        contactSupernodeThread.start();
        while (true) {
            try {
                Socket socket = serverSocket.accept();
                VisuProxyThread visuProxyThread = new VisuProxyThread(serverSocket, socket);
                visuProxyThread.setName("VisuProxy Listening thread");
                visuProxyThread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            System.gc();
        }
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    private static void usage() {
        System.out.println("usage: runVisuProxy [OPTION...]");
        for (int i = 0; i < options.length; i += 4) {
            System.out.print(options[i] + "| " + options[i + 1] + "\t");
            if (options[i + 2] != null) {
                System.out.print(options[i + 2]);
            }
            System.out.println("\t" + options[i + 3]);
        }
    }

    private static String parseArgs(String[] stringArray, int n) {
        int n2 = n * 4;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(options[n2]) && !stringArray[i].equals(options[n2 + 1])) continue;
            if (options[n2 + 2] != null) {
                if (stringArray.length >= i + 2) {
                    return stringArray[i + 1];
                }
                System.out.println("command line parse error: " + options[n2] + " or " + options[n2 + 1] + " requires a parameter.");
                System.exit(1);
                continue;
            }
            return new String("");
        }
        return null;
    }

    public static void main(String[] stringArray) {
        VisuProxy visuProxy = null;
        if (stringArray.length > 0) {
            String string;
            String string2 = null;
            string2 = VisuProxy.parseArgs(stringArray, 0);
            if (string2 != null) {
                VisuProxy.usage();
                System.exit(0);
            }
            if ((string = VisuProxy.parseArgs(stringArray, 1)) != null) {
                if (!string.equals("")) {
                    System.out.println("Visu Proxy running (update every " + string + "s)");
                    visuProxy = new VisuProxy(Integer.parseInt(string));
                }
            } else {
                System.out.println("Bad command line arguments.");
                VisuProxy.usage();
                System.exit(1);
            }
        } else {
            System.out.println("Visu Proxy running ...");
            visuProxy = new VisuProxy();
        }
        System.out.println("Visu Proxy starting listening thread ...");
        visuProxy.start();
    }

    static {
        updateFreq = 30;
    }

    public class ContactSupernodeThread
    extends Thread {
        URI supernodeUri = null;

        public ContactSupernodeThread(URI uRI) {
            this.supernodeUri = uRI;
        }

        public int notifyListToClients() {
            int n = 0;
            if (VisuProxy.this.clientList == null) {
                return 0;
            }
            for (Client client : VisuProxy.this.clientList) {
                if (!client.notifyList()) continue;
                ++n;
            }
            return n;
        }

        public void run() {
            Vector<HostEntry> vector = null;
            while (true) {
                if ((vector = SupernodeHostCacheDisplay.query(this.supernodeUri.getHost(), this.supernodeUri.getPort())) == null) {
                    log.error((Object)("[VisuProxy] Could not query SuperNode at " + this.supernodeUri.toString() + ". Exiting."));
                    System.exit(1);
                }
                if (VisuProxy.this.peerList == null || vector.hashCode() != VisuProxy.this.peerList.hashCode()) {
                    VisuProxy.this.peerList = vector;
                    this.notifyListToClients();
                }
                try {
                    Thread.sleep(updateFreq * 1000);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class VisuProxyThread
    extends Thread {
        ServerSocket serverSocket = null;
        Socket socket = null;

        VisuProxyThread(ServerSocket serverSocket, Socket socket) {
            this.serverSocket = serverSocket;
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            ObjectInputStream objectInputStream = null;
            Object var4_4 = null;
            try {
                inputStream = this.socket.getInputStream();
                outputStream = this.socket.getOutputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                return;
            }
            if (object instanceof RegisterMessage) {
                HostEntry hostEntry = ((RegisterMessage)object).getHostEntry();
                String string = hostEntry.getIp();
                int n = ((RegisterMessage)object).getAnswerPort();
                log.info((Object)("[VisuProxy] register from " + string + "(answer on port " + n + ")"));
                Client client = new Client(string, hostEntry, n);
                Vector<Client> vector = VisuProxy.this.clientList;
                synchronized (vector) {
                    VisuProxy.this.clientList.add(client);
                }
                client.notifyList();
            } else if (object instanceof UnregisterMessage) {
                HostEntry hostEntry = ((UnregisterMessage)object).getHostEntry();
                log.info((Object)("[VisuProxy] unregister from " + hostEntry.getIp()));
                Client client = VisuProxy.this.getClient(hostEntry.getIp());
                if (client == null) {
                    log.error((Object)("[VisuProxy] cannot find client with id=" + hostEntry.getIp()));
                } else {
                    Boolean bl;
                    Vector<Client> vector = VisuProxy.this.clientList;
                    synchronized (vector) {
                        bl = client.removeClient();
                    }
                    if (bl.booleanValue()) {
                        log.debug((Object)("[VisuProxy] removing " + hostEntry.getIp() + " from clientList (#records=" + VisuProxy.this.clientList.size()));
                    } else {
                        log.debug((Object)"[VisuProxy] could not remove client.");
                    }
                }
            } else if (object instanceof QuitMessage) {
                log.info((Object)("[VisuProxy] instructed to quit. Message from " + ((QuitMessage)object).getSrc()));
                System.exit(0);
            }
        }
    }

    private class Client {
        public String id;
        int answerPort;
        HostEntry hostEntry;
        private long lastSeen;
        private long firstSeen;

        public Client(String string, HostEntry hostEntry, int n) {
            this.id = string;
            this.answerPort = n;
            this.hostEntry = hostEntry;
            this.lastSeen = this.firstSeen = System.currentTimeMillis();
        }

        public String getIp() {
            return this.hostEntry.getIp();
        }

        public int getAnswerPort() {
            return this.answerPort;
        }

        public String getId() {
            return this.id;
        }

        public boolean removeClient() {
            Iterator<Client> iterator = VisuProxy.this.clientList.iterator();
            while (iterator.hasNext()) {
                Client client = iterator.next();
                String string = client.getId();
                if (!this.id.equals(string)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public boolean notifyList() {
            boolean bl = false;
            if (VisuProxy.this.clientList != null) {
                UpdateListMessage updateListMessage = new UpdateListMessage(VisuProxy.this.peerList);
                bl = VisuProxy.this.sendUpdate(this.getIp(), this.getAnswerPort(), updateListMessage);
            }
            return bl;
        }
    }
}

