/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import p2pmpi.common.HostEntry;
import p2pmpi.p2p.message.UpdateListMessage;
import p2pmpi.visu.StatQuery;

public class ProxyNotificationListener
extends Thread {
    private static int listenPort;
    private static ServerSocket listenServerSocket;
    protected StatQuery attachedQuery;

    public ProxyNotificationListener(StatQuery statQuery, ServerSocket serverSocket) {
        this.attachedQuery = statQuery;
        listenServerSocket = serverSocket;
        listenPort = serverSocket.getLocalPort();
    }

    public void run() {
        System.out.println("Thread Listening on port " + listenPort);
        try {
            while (true) {
                Socket socket = listenServerSocket.accept();
                ProcessThread processThread = new ProcessThread(listenServerSocket, socket);
                processThread.start();
            }
        }
        catch (Exception exception) {
            try {
                listenServerSocket.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            System.exit(1);
            return;
        }
    }

    public class ProcessThread
    extends Thread {
        ServerSocket serverSocket = null;
        Socket socket = null;

        ProcessThread(ServerSocket serverSocket, Socket socket) {
            this.serverSocket = serverSocket;
            this.socket = socket;
        }

        public void run() {
            Object object;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            Object var3_3 = null;
            try {
                inputStream = this.socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                return;
            }
            if (object instanceof UpdateListMessage) {
                Vector<HostEntry> vector = ((UpdateListMessage)object).getHostList();
                ProxyNotificationListener.this.attachedQuery.setPeerList(vector);
            } else {
                System.err.println("[Notification Listener] unknown message type received. Ignoring.");
            }
        }
    }
}

