/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.p2p;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.Vector;
import p2pmpi.common.HostEntry;
import p2pmpi.p2p.PingRTT;
import p2pmpi.p2p.message.PeerReplyMessage;
import p2pmpi.p2p.message.PeerRequestMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerUpdateList
extends TimerTask {
    URI superNode;
    HostEntry myHost;
    HashMap<String, HostEntry> hostCache;

    public PeerUpdateList(URI uRI, HostEntry hostEntry, HashMap<String, HostEntry> hashMap) {
        this.superNode = uRI;
        this.myHost = hostEntry;
        this.hostCache = hashMap;
    }

    @Override
    public void run() {
        try {
            Socket socket = new Socket(this.superNode.getHost(), this.superNode.getPort());
            PeerRequestMessage peerRequestMessage = new PeerRequestMessage();
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(peerRequestMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            PeerReplyMessage peerReplyMessage = (PeerReplyMessage)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
            Vector<HostEntry> vector = peerReplyMessage.getHostList();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                PingRTT pingRTT;
                HostEntry hostEntry = vector.elementAt(i);
                if (hostEntry.toString().equals(this.myHost.toString())) continue;
                String string = hostEntry.toString();
                if (!this.hostCache.containsKey(string)) {
                    pingRTT = new PingRTT(hostEntry.getIp(), hostEntry.getMpdPort());
                    n2 = pingRTT.ping();
                    hostEntry.setRtt(n2);
                    hostEntry.setAlive(true);
                    hostEntry.setLastUpdate();
                    this.hostCache.put(string, hostEntry);
                    continue;
                }
                if (this.hostCache.get(string).getLastUpdate() > 300000L) {
                    pingRTT = new PingRTT(hostEntry.getIp(), hostEntry.getMpdPort());
                    n2 = pingRTT.ping();
                    this.hostCache.get(string).setRtt(n2);
                    this.hostCache.get(string).setLastUpdate();
                }
                this.hostCache.get(string).setAlive(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

