/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Random;
import java.util.Vector;
import p2pmpi.common.Getopt;
import p2pmpi.common.HashGenerator;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.NetIface;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FTMessage;
import p2pmpi.message.FinalizedConfirmMessage;
import p2pmpi.message.FinalizedMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.RSMessage;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPIClient;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.internal.MessageHandler;

public class MPI {
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype STRING;
    public static Datatype OBJECT;
    public static Datatype BYTE2;
    public static Datatype CHAR2;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Datatype PACKED;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static int UNEQUAL;
    public static int SIMILAR;
    public static int IDENT;
    public static int UNDEFINED;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op BAND;
    public static Op MAXLOC;
    public static Op MINLOC;
    public static IntraComm COMM_WORLD;
    protected static RankTable rankTable;
    protected static MapRankTable mapRankTable;
    protected static String myHash;
    protected static int fdPort;
    protected static int mpdPort;
    protected static int rsPort;
    protected static int ftPort;
    protected static int myRank;
    protected static MessageHandler msgHandle;
    protected static Random mpiRandom;
    private static String hostIP;
    private static int t_sent;

    private static void setLocalhostIP() {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        String string = p2PMPI_ConfigFile.getExternalIP();
        if (string == null) {
            String string2 = p2PMPI_ConfigFile.getIface();
            NetIface netIface = new NetIface(string2);
            hostIP = netIface.getExternalIfIpv4();
        } else {
            hostIP = string;
        }
    }

    protected static String getLocalhostIP() {
        return hostIP;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] Init(String[] stringArray) {
        String[] stringArray2 = null;
        String string = null;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        MPIMessage mPIMessage = null;
        URI uRI = null;
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        mpdPort = p2PMPI_ConfigFile.getMPDPort();
        ftPort = p2PMPI_ConfigFile.getFTPort();
        rsPort = p2PMPI_ConfigFile.getRSPort();
        fdPort = p2PMPI_ConfigFile.getFDPort();
        MPI.setLocalhostIP();
        int n = p2PMPI_ConfigFile.getMinPort();
        int n2 = p2PMPI_ConfigFile.getMaxPort();
        int n3 = 0;
        String string2 = System.getProperty("mode");
        ServerSocket serverSocket = null;
        if (string2.equals("server")) {
            Serializable serializable;
            int n4;
            Object iOException;
            String[] stringArray3;
            String[] stringArray4;
            Object object;
            void var35_51;
            Serializable serializable2;
            Object object3;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = -1;
            int n12 = -1;
            int n13 = 1;
            String string3 = null;
            String string4 = null;
            boolean bl = true;
            String string5 = "must be followed by a positive integer number";
            Getopt getopt = new Getopt("P2P-MPI", stringArray, "w:n:r:l:a:o");
            getopt.setOpterr(false);
            while ((n10 = getopt.getopt()) != -1) {
                switch (n10) {
                    case 119: {
                        String string6 = getopt.getOptarg();
                        try {
                            n12 = Integer.parseInt(string6);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -w  " + string5);
                            System.exit(1);
                        }
                        if (n12 >= -1) break;
                        System.err.println("** [Error] -w  " + string5);
                        System.exit(1);
                        break;
                    }
                    case 110: {
                        String string6 = getopt.getOptarg();
                        try {
                            n11 = Integer.parseInt(string6);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -n  " + string5);
                            System.exit(1);
                        }
                        if (n11 >= 1) break;
                        System.err.println("** [Error] -n  " + string5);
                        System.exit(1);
                        break;
                    }
                    case 114: {
                        String string6 = getopt.getOptarg();
                        try {
                            n13 = Integer.parseInt(string6);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -r  " + string5);
                            System.exit(1);
                        }
                        if (n13 >= 1) break;
                        System.err.println("** [Error] -r  " + string5);
                        System.exit(1);
                        break;
                    }
                    case 108: {
                        String string6 = getopt.getOptarg();
                        string4 = new String(string6);
                        break;
                    }
                    case 97: {
                        String string6 = getopt.getOptarg();
                        string3 = new String(string6);
                        if (!string3.equalsIgnoreCase("spread") && !string3.equalsIgnoreCase("concentrate")) {
                            System.err.println("** [Error] -a must be follow by \"spread\" or \"concentrate\"");
                            System.exit(1);
                        }
                    }
                    case 111: {
                        bl = false;
                    }
                }
            }
            Vector<String> vector = new Vector<String>();
            for (n9 = getopt.getOptind(); n9 < stringArray.length; ++n9) {
                vector.addElement(stringArray[n9]);
            }
            string = new String((String)vector.elementAt(0));
            n9 = vector.size();
            stringArray2 = new String[n9 - 1];
            for (n8 = 0; n8 < n9 - 1; ++n8) {
                stringArray2[n8] = new String((String)vector.elementAt(n8 + 1));
                string = string + " " + stringArray2[n8];
            }
            n8 = n13;
            int n14 = (n11 - 1) * n13;
            Random random = new Random();
            for (n7 = n6 = random.nextInt(n2 - n) + n; n7 <= n2; ++n7) {
                try {
                    serverSocket = new ServerSocket(n7);
                    n3 = n7;
                    break;
                }
                catch (Exception exception) {
                    serverSocket = null;
                    continue;
                }
            }
            if (serverSocket == null) {
                for (n7 = n; n7 <= n2; ++n7) {
                    try {
                        serverSocket = new ServerSocket(n7);
                        n3 = n7;
                        break;
                    }
                    catch (Exception exception) {
                        serverSocket = null;
                        continue;
                    }
                }
                if (serverSocket == null) {
                    System.err.println("No available ports in the range allowed [" + n + " - " + n2 + "] to run this application");
                    System.exit(1);
                }
            }
            myHash = HashGenerator.gen();
            mpiRandom = new Random(Long.parseLong(myHash));
            try {
                uRI = new URI("tcp://" + MPI.getLocalhostIP() + ":" + n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n11 == 1) {
                rankTable = new RankTable();
                rankTable.addProcess(0, uRI, fdPort);
                mapRankTable = new MapRankTable();
                mapRankTable.addMap(0, 0);
                AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
                appRegisterMessage.setID(myHash + "--0");
                appRegisterMessage.setRunCmd(string);
                appRegisterMessage.setIPRank0(MPI.getLocalhostIP());
                appRegisterMessage.setRunDir("");
                appRegisterMessage.setRank(0);
                appRegisterMessage.setPort(n3);
                appRegisterMessage.setMPISize(n11);
                appRegisterMessage.setRealSize(rankTable.size());
                appRegisterMessage.setRankTable(rankTable);
                try {
                    socket = new Socket("127.0.0.1", mpdPort);
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(appRegisterMessage);
                    objectOutputStream.flush();
                    inputStream = socket.getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    object3 = (PingReplyMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    objectOutputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Please make sure that MPD is running.");
                    System.exit(1);
                }
                msgHandle = new MessageHandler(serverSocket, n11, rankTable, myHash, mpdPort, fdPort);
                msgHandle.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
                object3 = new Thread(msgHandle);
                ((Thread)object3).setDaemon(true);
                ((Thread)object3).start();
                COMM_WORLD = new IntraComm(msgHandle, rankTable, 0, 0, n11, mapRankTable);
                return stringArray2;
            }
            if (n12 < 0) {
                n12 = n14 * 3;
            }
            MPDMessage mPDMessage = new MPDMessage(7, myHash);
            mPDMessage.setOptionN(n11 - 1);
            mPDMessage.setOptionR(n13);
            mPDMessage.setMinPeers(n8);
            mPDMessage.setMaxPeers(n14);
            mPDMessage.setWaitTime(n12);
            mPDMessage.setIP(MPI.getLocalhostIP(), n3);
            mPDMessage.setRunCmd(string);
            mPDMessage.setAllocationMode(string3);
            System.out.println("Searching nodes for a maximum of " + n12 + " seconds ...");
            object3 = null;
            try {
                object3 = new Socket("127.0.0.1", mpdPort);
                outputStream = ((Socket)object3).getOutputStream();
                inputStream = ((Socket)object3).getInputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(mPDMessage);
                objectOutputStream.flush();
                objectInputStream = new ObjectInputStream(inputStream);
                serializable2 = (FoundNodeMessage)objectInputStream.readObject();
                boolean n5 = ((FoundNodeMessage)serializable2).isEnough();
                int n15 = ((FoundNodeMessage)serializable2).getNumFoundNode();
                int n16 = ((FoundNodeMessage)serializable2).getNumSlotAvailable();
                objectInputStream.close();
                objectOutputStream.close();
                inputStream.close();
                outputStream.close();
                ((Socket)object3).close();
                if (!n5) {
                    if (n16 == 0) {
                        System.err.println("** [Error] Not enough hosts (found only " + n15 + ").");
                    } else {
                        System.err.println("** [Error] Not enough hosts (found only " + n15 + " nodes that can provide only " + n16 + " slots).");
                    }
                    System.err.println("**         You may try to search longer with -w option.");
                    System.exit(1);
                }
                if (n15 < n14 + 1) {
                    System.out.println("** [Warning] Found only " + n15 + " host(s).");
                    System.out.println("**           Several processes will be executed on a same host.");
                }
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot connect to local MPD (127.0.0.1:" + mpdPort + ").");
                System.err.println("**         Make sure you have run \"mpiboot\"");
                System.exit(1);
            }
            System.out.println("Waiting reply from other nodes..");
            socket = null;
            serializable2 = null;
            boolean bl2 = false;
            URI[] uRIArray = new URI[n14];
            int[] nArray = new int[n14];
            try {
                serverSocket.setSoTimeout(120000);
            }
            catch (Exception socketTimeoutException) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            while (true) {
                try {
                    socket = serverSocket.accept();
                    inputStream = socket.getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    serializable2 = (MPDMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (SocketTimeoutException classNotFoundException) {
                    System.err.println("** [Error] No reply from at least one of the hosts.");
                    System.err.println("**         Check no firewall blocks port " + serverSocket.getLocalPort());
                    System.exit(1);
                }
                catch (IOException exception) {
                    continue;
                }
                catch (ClassNotFoundException exception) {
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                switch (((MPDMessage)serializable2).getCmd()) {
                    case 9: {
                        System.out.println("======== got ACCEPT reply  ==========");
                        System.out.println(" FT socket : " + ((MPDMessage)serializable2).getHost() + ":" + ((MPDMessage)serializable2).getFTPort());
                        System.out.println(" Key : " + ((MPDMessage)serializable2).getRank());
                        System.out.println("=====================================");
                        try {
                            uRIArray[var35_51] = new URI("tcp://" + ((MPDMessage)serializable2).getHost() + ":" + ((MPDMessage)serializable2).getFTPort());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nArray[var35_51] = ((MPDMessage)serializable2).getRank();
                        ++var35_51;
                        break;
                    }
                    default: {
                        System.out.println("Unknown command");
                    }
                }
                if (var35_51 >= n14) break;
            }
            Vector<Object> iOException2 = new Vector<Object>();
            if (string4 == null) {
                object = new String((String)vector.elementAt(0));
                stringArray4 = new File(System.getProperty("user.dir"), (String)object);
                object = new String(stringArray4.toString() + ".class");
                iOException2.addElement(object);
            } else {
                object = new File(string4);
                try {
                    String fTMessage;
                    stringArray4 = new BufferedReader(new FileReader((File)object));
                    while ((fTMessage = stringArray4.readLine()) != null) {
                        stringArray3 = new File(fTMessage);
                        if (!stringArray3.exists()) {
                            System.err.println("** [Error] File : " + fTMessage + " in " + string4 + " does not exist");
                            System.exit(1);
                        }
                        iOException2.addElement(fTMessage);
                    }
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Could not read file " + string4);
                    System.exit(1);
                }
            }
            int n17 = iOException2.size();
            stringArray4 = new String[n17];
            for (int i = 0; i < n17; ++i) {
                stringArray4[i] = new String((String)iOException2.elementAt(i));
            }
            FTMessage fTMessage = new FTMessage(4, myHash);
            fTMessage.setKeys(nArray);
            fTMessage.setURIs(uRIArray);
            fTMessage.setFileNames(stringArray4);
            fTMessage.setSize((int)var35_51);
            System.out.print("Transfering files ... [ ");
            stringArray3 = fTMessage.getOnlyFileNameList();
            for (int n18 = 0; n18 < stringArray3.length; ++n18) {
                System.out.print(stringArray3[n18] + " ");
            }
            System.out.println("]");
            try {
                object3 = new Socket("127.0.0.1", ftPort);
                outputStream = ((Socket)object3).getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(fTMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                ((Socket)object3).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Waiting for processes to acknowledge file transfer ...");
            rankTable = new RankTable();
            rankTable.addProcess(0, uRI, fdPort);
            mapRankTable = new MapRankTable();
            mapRankTable.addMap(0, 0);
            int n18 = 0;
            try {
                serverSocket.setSoTimeout((int)(var35_51 * 5000));
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            boolean bl3 = false;
            while (true) {
                try {
                    while (true) {
                        System.out.println("Wait for SYN message ...");
                        socket = serverSocket.accept();
                        inputStream = socket.getInputStream();
                        objectInputStream = new ObjectInputStream(inputStream);
                        iOException = objectInputStream.readObject();
                        if (iOException instanceof MPIMessage) {
                            mPIMessage = (MPIMessage)iOException;
                            objectInputStream.close();
                            inputStream.close();
                            socket.close();
                            break;
                        }
                        if (!(iOException instanceof OutputMessage)) continue;
                        OutputMessage blArray = (OutputMessage)iOException;
                        System.out.println(">>>>" + blArray.getOutput());
                        objectInputStream.close();
                        inputStream.close();
                        socket.close();
                    }
                }
                catch (SocketTimeoutException classNotFoundException) {
                    System.err.println("** [Error] Not enough peers to form an execution platform.");
                    System.err.println("**         At least one of the requested hosts is behind a firewall.");
                    System.exit(1);
                }
                catch (IOException n20) {
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                if (mPIMessage.getCmd() != 11) continue;
                System.out.println("Contruct Table");
                System.out.println("SYN:" + mPIMessage.getRank() + ":" + mPIMessage.getURI());
                rankTable.addProcess(mPIMessage.getRank(), mPIMessage.getURI(), mPIMessage.getFDPort());
                mapRankTable.addMap(mPIMessage.getRank(), ++n18);
                if (n18 >= var35_51) break;
            }
            bl3 = true;
            System.out.println("Check Receive all peers");
            if (!bl3) {
                iOException = new boolean[n11];
                int n19 = rankTable.size();
                for (n4 = 0; n4 < n11; ++n4) {
                    iOException[n4] = false;
                }
                for (n4 = 0; n4 < n19; ++n4) {
                    iOException[MPI.rankTable.getRank((int)n4)] = true;
                }
                for (n4 = 0; n4 < n11; ++n4) {
                    if (iOException[n4] != false) continue;
                    System.err.println("*** Not enough peer to form an execution platform. ***");
                    System.exit(1);
                }
            }
            int n20 = rankTable.size();
            boolean[] blArray = new boolean[n11];
            for (n4 = 0; n4 < n11; ++n4) {
                blArray[n4] = false;
            }
            System.out.println("==================================");
            for (n4 = 0; n4 < n20; ++n4) {
                int n21 = rankTable.getRank(n4);
                if (!blArray[n21]) {
                    System.out.println("[Master of Rank " + n21 + "]: IP = " + rankTable.getHost(n4));
                    blArray[n21] = true;
                    continue;
                }
                System.out.println("Rank " + n21 + ": IP = " + rankTable.getHost(n4));
            }
            System.out.println("==================================");
            long l = System.currentTimeMillis();
            for (int i = 1; i < n20; ++i) {
                mPIMessage = new MPIMessage(12);
                mPIMessage.setCommTable(rankTable);
                mPIMessage.setRank(rankTable.getRank(i));
                mPIMessage.setRankInList(i);
                mPIMessage.setSize(n11);
                mPIMessage.setTGossip(p2PMPI_ConfigFile.getTGossip());
                mPIMessage.setTHang(p2PMPI_ConfigFile.getTHang());
                mPIMessage.setTMargin(t_sent * rankTable.size());
                System.out.println("Using protocol = " + p2PMPI_ConfigFile.getGossipProtocol());
                mPIMessage.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
                mPIMessage.setTDiff((int)(System.currentTimeMillis() - l));
                try {
                    System.out.println("Send a List to:" + rankTable.getHost(i) + ":" + rankTable.getPort(i));
                    socket = new Socket(rankTable.getHost(i), rankTable.getPort(i));
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(mPIMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            msgHandle = new MessageHandler(serverSocket, n11, rankTable, myHash, mpdPort, fdPort);
            msgHandle.setTGossip(p2PMPI_ConfigFile.getTGossip());
            msgHandle.setTMargin(t_sent * rankTable.size());
            msgHandle.setTHang(p2PMPI_ConfigFile.getTHang());
            msgHandle.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
            Thread thread = new Thread(msgHandle);
            thread.setDaemon(true);
            thread.start();
            COMM_WORLD = new IntraComm(msgHandle, rankTable, 0, 0, n11, mapRankTable);
            AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
            appRegisterMessage.setID(myHash + "--0");
            appRegisterMessage.setRunCmd(string);
            appRegisterMessage.setIPRank0(MPI.getLocalhostIP());
            appRegisterMessage.setRunDir(System.getProperty("user.dir"));
            appRegisterMessage.setRank(0);
            appRegisterMessage.setPort(n3);
            appRegisterMessage.setMPISize(n11);
            appRegisterMessage.setRealSize(rankTable.size());
            appRegisterMessage.setRankTable(rankTable);
            try {
                socket = new Socket("127.0.0.1", mpdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appRegisterMessage);
                objectOutputStream.flush();
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                serializable = (PingReplyMessage)objectInputStream.readObject();
                objectInputStream.close();
                objectOutputStream.close();
                outputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Please make sure that MPD is running.");
                System.exit(1);
            }
            System.out.println("Create an gossip instance !!");
            serializable = new GossipMessage(0, myHash);
            ((GossipMessage)serializable).setMyRank(0);
            ((GossipMessage)serializable).setMPIRank(0);
            ((GossipMessage)serializable).setMPIPort(n3);
            ((GossipMessage)serializable).setURIList(rankTable.getFDURIs());
            ((GossipMessage)serializable).setTGossip(p2PMPI_ConfigFile.getTGossip());
            ((GossipMessage)serializable).setTHang(p2PMPI_ConfigFile.getTHang());
            ((GossipMessage)serializable).setTMargin(t_sent * rankTable.size());
            ((GossipMessage)serializable).setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
            ((GossipMessage)serializable).setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - l));
            try {
                socket = new Socket("127.0.0.1", fdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Fault Detection Service is not running");
                System.exit(1);
            }
            System.out.println("* Program is executing ...");
        } else {
            MPIClient mPIClient = new MPIClient(n, n2);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = new String(stringArray[i]);
            }
        }
        RSMessage rSMessage = new RSMessage(7, myHash);
        try {
            socket = new Socket("127.0.0.1", rsPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(rSMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.err.println("** [Error] Reservation Service is not running");
            System.exit(1);
        }
        COMM_WORLD.Barrier();
        return stringArray2;
    }

    public static int Rand() {
        return mpiRandom.nextInt();
    }

    public static int Rand(int n) {
        return mpiRandom.nextInt(n);
    }

    public static void Finalize() {
        int n;
        Serializable serializable;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        COMM_WORLD.Barrier();
        if (rankTable.size() == 1) {
            if (msgHandle != null) {
                msgHandle.shutdown();
            }
            try {
                AppUnregisterMessage appUnregisterMessage = new AppUnregisterMessage(myHash, myRank);
                socket = new Socket("127.0.0.1", mpdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appUnregisterMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.out.println("MPD Service is not running");
            }
            return;
        }
        if (msgHandle.getRankInList() == 0) {
            msgHandle.meTerminated();
            while (!msgHandle.isAllTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            serializable = new FinalizedConfirmMessage();
            n = rankTable.size();
            for (int i = 1; i < n; ++i) {
                if (!rankTable.isAlive(i)) continue;
                try {
                    socket = new Socket(rankTable.getHost(i), rankTable.getPort(i));
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            serializable = new FinalizedMessage(msgHandle.getRankInList());
            try {
                socket = new Socket(rankTable.getHost(0), rankTable.getPort(0));
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!msgHandle.isTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        try {
            serializable = new GossipMessage(2, myHash);
            n = msgHandle.getRankInList();
            ((GossipMessage)serializable).setMyRank(n);
            socket = new Socket("127.0.0.1", fdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Fault Detection Service is not running");
        }
        try {
            serializable = new AppUnregisterMessage(myHash, myRank);
            socket = new Socket("127.0.0.1", mpdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("MPD Service is not running");
        }
        int n2 = msgHandle.getMessageBufferSize();
        if (n2 != 0) {
            System.err.println("** [rank " + msgHandle.getRank() + "] Warning : there was " + n2 + " message(s) left in reception buffer. **");
        }
        if (msgHandle != null) {
            msgHandle.shutdown();
        }
    }

    public static double Wtime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double Wtick() {
        double d = 1.0E-4;
        double d2 = 0.0;
        if (d2 == 0.0) {
            d2 = System.currentTimeMillis();
            d2 = (double)System.currentTimeMillis() - d2;
            for (int i = 0; i < 10; ++i) {
                double d3 = System.currentTimeMillis();
                d3 = (double)System.currentTimeMillis() - d3;
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            d2 = d2 > 0.0 ? d2 : 1.0E-5;
        }
        return d2 / 1000.0;
    }

    public static String Get_processor_name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        myHash = null;
        msgHandle = null;
        hostIP = null;
        t_sent = 1000;
        BYTE = new Datatype(1);
        CHAR = new Datatype(2);
        SHORT = new Datatype(3);
        BOOLEAN = new Datatype(4);
        INT = new Datatype(5);
        LONG = new Datatype(6);
        FLOAT = new Datatype(7);
        DOUBLE = new Datatype(8);
        PACKED = new Datatype(9);
        STRING = new Datatype(10);
        OBJECT = new Datatype(11);
        BYTE2 = BYTE.Contiguous(2);
        CHAR2 = CHAR.Contiguous(2);
        SHORT2 = SHORT.Contiguous(2);
        INT2 = INT.Contiguous(2);
        LONG2 = LONG.Contiguous(2);
        FLOAT2 = FLOAT.Contiguous(2);
        DOUBLE2 = DOUBLE.Contiguous(2);
        ANY_SOURCE = Tag.MPI_ANYSOURCE;
        ANY_TAG = Tag.MPI_ANYTAG;
        UNDEFINED = -3;
        UNEQUAL = 0;
        SIMILAR = 1;
        IDENT = 2;
        MAX = new Op(1);
        MIN = new Op(2);
        SUM = new Op(3);
        PROD = new Op(4);
        BAND = new Op(6);
        MAXLOC = new Op(12);
        MINLOC = new Op(11);
    }
}

