/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.message;

import java.io.Serializable;
import java.util.Vector;
import p2pmpi.common.OsInfo;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.Version;

public class StatInfoMessage
implements Serializable {
    private static final long serialVersionUID = 2000033L;
    private Vector<ProcessInfo> procInfo;
    String mpdVer;
    String ip;
    int mpdPort;
    String hostname;
    String osname;
    String arch;
    String cpuname;
    String cpufreq;
    String mem;

    public StatInfoMessage(String string, int n) {
        this.ip = string;
        this.mpdPort = n;
        this.mpdVer = Version.MAINVERSION + "." + Version.SUBVERSION;
        this.procInfo = new Vector();
        this.osname = System.getProperty("os.name");
        this.arch = System.getProperty("os.arch");
        String[] stringArray = OsInfo.cpuInfo();
        String[] stringArray2 = OsInfo.memInfo();
        if (stringArray2 != null) {
            this.mem = stringArray2[0];
        }
        if (stringArray == null) {
            this.cpuname = "N/A";
            this.cpufreq = "N/A";
        } else {
            this.cpuname = stringArray[0];
            this.cpufreq = stringArray[1];
        }
    }

    public StatInfoMessage(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.ip = string;
        this.mpdPort = n;
        this.mpdVer = string2;
        this.procInfo = null;
        this.osname = string3;
        this.arch = string4;
        this.cpuname = string5;
        this.cpufreq = string6;
        this.mem = string7;
    }

    public void addInfo(ProcessInfo processInfo) {
        this.procInfo.addElement(processInfo);
    }

    public ProcessInfo getInfo(int n) {
        return this.procInfo.elementAt(n);
    }

    public int size() {
        if (this.procInfo != null) {
            return this.procInfo.size();
        }
        return 0;
    }

    public String getIp() {
        return this.ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getMpdVer() {
        return this.mpdVer;
    }

    public int getMpdPort() {
        return this.mpdPort;
    }

    public String getOsName() {
        return this.osname;
    }

    public String getArch() {
        return this.arch;
    }

    public String getCpuName() {
        return this.cpuname;
    }

    public String getCpuFreq() {
        return this.cpufreq;
    }

    public String getMem() {
        return this.mem;
    }
}

