/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import com.touchgraph.graphlayout.interaction.TGAbstractMousePausedUI;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;
import p2pmpi.visu.NetMap;
import p2pmpi.visu.PeerNode;

public class PeerNodeHintUI
extends TGAbstractMousePausedUI {
    NetMap tgLinkBrowser;
    boolean mousePressed;
    MouseAdapter hintML;
    PeerNode hintNode;
    JTextPane tpHint;
    JInternalFrame intfHint;
    JScrollPane spHint;
    int hintWidth = 0;
    int hintHeight = 0;

    public PeerNodeHintUI(NetMap netMap) {
        super(netMap.getTGPanel());
        this.tgLinkBrowser = netMap;
        this.mousePressed = false;
        this.hintNode = null;
        this.hintML = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PeerNodeHintUI.this.mousePressed = true;
                PeerNodeHintUI.this.hideHint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PeerNodeHintUI.this.mousePressed = false;
            }
        };
        this.tpHint = new JTextPane();
        this.tpHint.setEditable(false);
        this.tpHint.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            }
        });
        this.spHint = new JScrollPane(this.tpHint);
        this.spHint.setVerticalScrollBarPolicy(20);
        this.intfHint = new JInternalFrame();
        this.intfHint.setResizable(true);
        this.intfHint.setClosable(true);
        this.intfHint.setDefaultCloseOperation(1);
        this.intfHint.getContentPane().setLayout(new BorderLayout());
        this.intfHint.getContentPane().add(this.spHint);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                PeerNodeHintUI.this.cancelPause();
            }
        };
        this.tpHint.addMouseListener(mouseAdapter);
        this.intfHint.addMouseListener(mouseAdapter);
    }

    public void showHint(PeerNode peerNode) {
        if (this.intfHint.isVisible() || peerNode.getHint().trim().equals("")) {
            return;
        }
        this.intfHint.setTitle(peerNode.getLabel());
        this.hintNode = peerNode;
        this.hintWidth = peerNode.getHintWidth();
        if (peerNode.getHintIsHTML()) {
            this.tpHint.setEditorKit(new HTMLEditorKit());
        } else {
            this.tpHint.setEditorKit(new StyledEditorKit());
        }
        this.tpHint.setText(peerNode.getHint());
        int n = (int)peerNode.drawx;
        int n2 = (int)peerNode.drawy;
        this.spHint.getVerticalScrollBar().setVisible(false);
        this.hintHeight = peerNode.getHintHeight();
        if (this.hintHeight < PeerNode.MINIMUM_HINT_HEIGHT) {
            this.tpHint.setSize(new Dimension(this.hintWidth - 16, 10));
            this.hintHeight = this.tpHint.getPreferredScrollableViewportSize().height + 40;
        }
        int n3 = 0;
        int n4 = this.tgPanel.getSize().height;
        int n5 = peerNode.getHeight() / 2;
        if (n2 > n4 / 2 || n2 - n5 > this.hintHeight) {
            this.hintHeight = Math.min(n2 - n5, this.hintHeight);
            n3 = n2 - this.hintHeight - n5;
        } else {
            this.hintHeight = Math.min(n4 - n2 - n5, this.hintHeight);
            n3 = n2 + n5;
        }
        int n6 = n - this.hintWidth / 2;
        n6 = Math.max(Math.min(n6, this.tgPanel.getWidth() - this.hintWidth), 0);
        this.intfHint.setSize(new Dimension(this.hintWidth, this.hintHeight));
        this.intfHint.setLocation(n6, n3);
        this.intfHint.setVisible(true);
    }

    public void hideHint() {
        this.intfHint.setVisible(false);
    }

    public void preActivate() {
        this.hideHint();
        this.tgPanel.addMouseListener(this.hintML);
        this.tgPanel.add(this.intfHint);
    }

    public void postDeactivate() {
        this.tgPanel.removeMouseListener(this.hintML);
        this.tgPanel.remove(this.intfHint);
    }

    public void mousePaused(MouseEvent mouseEvent) {
        PeerNode peerNode = (PeerNode)this.tgPanel.getMouseOverN();
        if (peerNode != null && !this.mousePressed) {
            if (this.hintNode != peerNode) {
                this.hideHint();
            }
            this.showHint(peerNode);
        } else {
            this.hideHint();
        }
        this.tgPanel.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mousePressed = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.intfHint.isVisible()) {
            this.hideHint();
            this.tgPanel.repaint();
        }
    }
}

