/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.tools;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Vector;
import p2pmpi.common.HostEntry;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.p2p.message.PeerReplyMessage;
import p2pmpi.p2p.message.PeerRequestMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupernodeHostCacheDisplay {
    private static String dateTranslate(long l) {
        long l2 = l;
        int n = (int)(l / 84600000L);
        int n2 = (int)((l2 -= (long)(n * 84600000)) / 3600000L);
        int n3 = (int)((l2 -= (long)(n2 * 3600000)) / 60000L);
        int n4 = (int)((l2 -= (long)(n3 * 60000)) / 1000L);
        int n5 = (int)(l2 -= (long)(n4 * 1000));
        return n + "D " + n2 + ":" + n3 + ":" + n4 + ":" + n5;
    }

    public static void display(Vector<HostEntry> vector) {
        System.out.println("Host\t\tMPD Port\tLast update");
        if (vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            HostEntry hostEntry = vector.elementAt(i);
            System.out.println(hostEntry.getIp() + "\t" + hostEntry.getMpdPort() + "\t\t" + SupernodeHostCacheDisplay.dateTranslate(hostEntry.getLastUpdate()));
        }
        System.out.println("\n\nTotal : " + n + " MPD known.");
    }

    public static Vector<HostEntry> query(String string, int n) {
        Vector<HostEntry> vector = null;
        try {
            PeerRequestMessage peerRequestMessage = new PeerRequestMessage();
            Socket socket = new Socket(string, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(peerRequestMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            PeerReplyMessage peerReplyMessage = (PeerReplyMessage)objectInputStream.readObject();
            vector = peerReplyMessage.getHostList();
            objectInputStream.close();
            objectOutputStream.close();
            outputStream.close();
            inputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.err.println("[Error] querying Supernode : " + exception.toString());
            return null;
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("P2PMPI_HOME");
        if (string == null) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set.");
            System.exit(1);
        }
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        URI uRI = p2PMPI_ConfigFile.getSuperNode();
        Vector<HostEntry> vector = null;
        vector = SupernodeHostCacheDisplay.query(uRI.getHost(), uRI.getPort());
        if (vector != null) {
            SupernodeHostCacheDisplay.display(vector);
        } else {
            System.err.println("Could not query SuperNode at " + uRI.getHost() + ":" + uRI.getPort());
            System.exit(1);
        }
    }
}

