/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.tools;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;

public class MPDInfo {
    public static void main(String[] stringArray) {
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile();
        int n = p2PMPI_ConfigFile.getMPDPort();
        System.out.println("Trying to connect to 127.0.0.1:" + n + "...");
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            StatQueryMessage statQueryMessage = new StatQueryMessage();
            objectOutputStream.writeObject(statQueryMessage);
            objectOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            StatInfoMessage statInfoMessage = (StatInfoMessage)objectInputStream.readObject();
            System.out.println("========================================================");
            System.out.println("   Gatekeeper (mpd " + statInfoMessage.getMpdVer() + ") up and running.");
            int n2 = statInfoMessage.size();
            if (n2 == 0) {
                System.out.println("   No application running.");
            } else {
                for (int i = 0; i < n2; ++i) {
                    System.out.println("--------------------------------------------------------");
                    System.out.println("   Application Name : " + statInfoMessage.getInfo(i).getRunCmd());
                    System.out.println("   MPI Rank   : " + statInfoMessage.getInfo(i).getRank());
                    System.out.println("   Local Port : " + statInfoMessage.getInfo(i).getPort());
                    System.out.println("   Rank 0 IP  : " + statInfoMessage.getInfo(i).getIpRank0());
                }
            }
            System.out.println("========================================================");
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("=================================================================");
            System.out.println("  Could not connect to local gatekeeper. Have you run 'mpiboot' ?");
            System.out.println("=================================================================");
            System.exit(1);
        }
    }
}

