/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.rdv;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import net.jxta.exception.PeerGroupException;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import org.apache.log4j.Logger;
import p2pmpi.common.GenericConfigFile;
import p2pmpi.common.NameGenerator;
import p2pmpi.message.RDVPeerInfoMessage;
import p2pmpi.message.RequestQuitMessage;
import p2pmpi.rdv.RDVPlatformGenerator;

public class RDV
implements RendezvousListener {
    static PeerGroup netPeerGroup = null;
    RendezVousService rendezvous = null;
    private static String TCP_PRE = "tcp://";
    private static String HTTP_PRE = "http://";
    private static String ADDR_SEP = ":";
    private static Logger log;

    public static void main(String[] stringArray) {
        RDV rDV = new RDV();
        rDV.startJxta();
    }

    public boolean recursiveRemove(File file) {
        try {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.recursiveRemove(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            if (!file.delete()) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void startJxta() {
        Object object;
        log = Logger.getLogger((String)"RDV");
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-RDV.conf");
        log.debug((Object)("Read config file = " + file.toString()));
        GenericConfigFile genericConfigFile = new GenericConfigFile(file.toString());
        int n = Integer.parseInt(genericConfigFile.getProperty("InternalPort"));
        String string = NameGenerator.getUniqueName("RDV");
        RDVPlatformGenerator rDVPlatformGenerator = new RDVPlatformGenerator(string, genericConfigFile.getProperties());
        rDVPlatformGenerator.generatePlatform();
        try {
            netPeerGroup = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException peerGroupException) {
            System.out.println("** [Error] fatal error : group creation failure.");
            peerGroupException.printStackTrace();
            System.exit(1);
        }
        this.rendezvous = netPeerGroup.getRendezVousService();
        this.rendezvous.addListener((RendezvousListener)this);
        this.rendezvous.startRendezVous();
        log.info((Object)("I'm using NetPeerGroup = " + netPeerGroup.getPeerGroupName()));
        log.info((Object)("Group ID = " + netPeerGroup.getPeerGroupID().toString()));
        log.info((Object)("Peer name = " + netPeerGroup.getPeerName()));
        log.info((Object)("Peer ID = " + netPeerGroup.getPeerID().toString()));
        log.info((Object)"Rendezvous is online");
        ServerSocket serverSocket = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        Socket socket = null;
        Object object2 = null;
        try {
            serverSocket = new ServerSocket(n);
            while (!((object2 = (objectInputStream = new ObjectInputStream(inputStream = (socket = serverSocket.accept()).getInputStream())).readObject()) instanceof RequestQuitMessage)) {
                if (object2 instanceof RDVPeerInfoMessage) {
                    object = this.rendezvous.getConnectedPeerIDs();
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        System.out.println("PeerID = " + ((PeerID)((Vector)object).elementAt(i)).toString());
                    }
                    continue;
                }
                objectInputStream.close();
                inputStream.close();
                socket.close();
            }
            objectInputStream.close();
            inputStream.close();
            socket.close();
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rendezvous.removeListener((RendezvousListener)this);
        this.rendezvous.stopRendezVous();
        netPeerGroup.stopApp();
        log.debug((Object)"Quit JXTA NetPeerGroup");
        object = System.getProperty("JXTA_HOME");
        System.gc();
        this.recursiveRemove(new File((String)object));
        log.debug((Object)"Remove running directory");
        System.exit(0);
    }

    public void rendezvousEvent(RendezvousEvent rendezvousEvent) {
        String string = rendezvousEvent.getPeer();
        switch (rendezvousEvent.getType()) {
            case 9: {
                log.info((Object)"became edge");
                break;
            }
            case 8: {
                log.info((Object)"became RDV");
                break;
            }
            case 2: {
                log.info((Object)("client connect: peer:" + string));
                break;
            }
            case 6: {
                log.info((Object)("client disconnect: peer: " + string));
                break;
            }
            case 7: {
                log.info((Object)("client failed: peer:" + string));
                break;
            }
            case 3: {
                log.info((Object)("client reconnect: peer:" + string));
                break;
            }
            case 4: {
                log.info((Object)("RDV disconnect: peer:" + string));
                break;
            }
            case 5: {
                log.info((Object)("RDV failed: peer:" + string));
                break;
            }
            case 1: {
                log.info((Object)("RDV reconnect: peer:" + string));
                break;
            }
            default: {
                log.info((Object)("Unknown RDV event from peer " + string));
            }
        }
    }
}

