/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.util.Vector;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.mpi.Comm;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.Group;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.internal.BinomialTree;
import p2pmpi.mpi.internal.MessageHandler;

public class IntraComm
extends Comm {
    private int systemTAG = 100000;

    public IntraComm(MessageHandler messageHandler, RankTable rankTable, int n, int n2, int n3, MapRankTable mapRankTable) {
        super(messageHandler, rankTable, n, n2, n3, mapRankTable);
    }

    public IntraComm(Group group) {
        super(group);
    }

    public IntraComm Create(Group group) {
        IntraComm intraComm = new IntraComm(group);
        return intraComm;
    }

    public void Barrier() {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        byte[] byArray = new byte[1];
        if (this.Rank() == 0) {
            int n;
            for (n = 1; n < this.Size(); ++n) {
                this.Recv(byArray, 0, 1, MPI.BYTE, n, this.systemTAG);
            }
            for (n = 1; n < this.Size(); ++n) {
                this.Send(byArray, 0, 1, MPI.BYTE, n, this.systemTAG);
            }
        } else {
            this.Send(byArray, 0, 1, MPI.BYTE, 0, this.systemTAG);
            this.Recv(byArray, 0, 1, MPI.BYTE, 0, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Bcast(Object object, int n, int n2, Datatype datatype, int n3) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.BcastBinomial(object, n, n2, datatype, n3);
    }

    private void BcastFlat(Object object, int n, int n2, Datatype datatype, int n3) {
        if (this.Rank() == n3) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i == n3) continue;
                this.Send(object, n, n2, datatype, i, this.systemTAG);
            }
        } else {
            this.Recv(object, n, n2, datatype, n3, this.systemTAG);
        }
        ++this.systemTAG;
    }

    private void BcastBinomial(Object object, int n, int n2, Datatype datatype, int n3) {
        int n4;
        int n5 = this.Size();
        BinomialTree binomialTree = new BinomialTree(n5);
        int n6 = binomialTree.getMaxDegree();
        int[] nArray = new int[n6 + 1];
        int n7 = this.Rank() - n3;
        if (n7 < 0) {
            n7 += this.Size();
        }
        if ((n4 = binomialTree.getParentChildrenInverse(n7, nArray)) != -1) {
            n4 = (n4 + n3) % n5;
            this.Recv(object, n, n2, datatype, n4, this.systemTAG);
        }
        int n8 = 0;
        while (nArray[n8] != -1) {
            this.Send(object, n, n2, datatype, (nArray[n8] + n3) % n5, this.systemTAG);
            ++n8;
        }
        ++this.systemTAG;
    }

    public void Reduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        if (op.isCommute()) {
            this.ReduceBinomial(object, n, object2, n2, n3, datatype, op, n4);
        } else {
            this.ReduceFlat(object, n, object2, n2, n3, datatype, op, n4);
        }
    }

    private void ReduceBinomial(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        int n5 = this.Size();
        BinomialTree binomialTree = new BinomialTree(n5);
        int n6 = binomialTree.getMaxDegree();
        int[] nArray = new int[n6 + 1];
        int n7 = this.Rank() - n4;
        if (n7 < 0) {
            n7 += this.Size();
        }
        int n8 = binomialTree.getParentChildren(n7, nArray);
        int n9 = datatype.getBaseType();
        if (n8 != -1) {
            n8 = (n8 + n4) % this.Size();
        }
        int n10 = nArray.length;
        for (int i = 0; i < n10 && nArray[i] != -1; ++i) {
            nArray[i] = (nArray[i] + n4) % this.Size();
        }
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        int n11 = datatype.getDisplacementSequence().length;
        switch (n9) {
            case 1: {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n11 * n3];
                byte[] byArray3 = new byte[n11 * n3];
                System.arraycopy(byArray, n, byArray2, 0, n11 * n3);
                objectArray = byArray2;
                objectArray2 = byArray3;
                break;
            }
            case 2: {
                char[] cArray = (char[])object;
                char[] cArray2 = new char[n11 * n3];
                char[] cArray3 = new char[n11 * n3];
                System.arraycopy(cArray, n, cArray2, 0, n11 * n3);
                objectArray = cArray2;
                objectArray2 = cArray3;
                break;
            }
            case 3: {
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n11 * n3];
                short[] sArray3 = new short[n11 * n3];
                System.arraycopy(sArray, n, sArray2, 0, n11 * n3);
                objectArray = sArray2;
                objectArray2 = sArray3;
                break;
            }
            case 5: {
                int[] nArray2 = (int[])object;
                int[] nArray3 = new int[n11 * n3];
                int[] nArray4 = new int[n11 * n3];
                System.arraycopy(nArray2, n, nArray3, 0, n11 * n3);
                objectArray = nArray3;
                objectArray2 = nArray4;
                break;
            }
            case 6: {
                long[] lArray = (long[])object;
                long[] lArray2 = new long[n11 * n3];
                long[] lArray3 = new long[n11 * n3];
                System.arraycopy(lArray, n, lArray2, 0, n11 * n3);
                objectArray = lArray2;
                objectArray2 = lArray3;
                break;
            }
            case 7: {
                float[] fArray = (float[])object;
                float[] fArray2 = new float[n11 * n3];
                float[] fArray3 = new float[n11 * n3];
                System.arraycopy(fArray, n, fArray2, 0, n11 * n3);
                objectArray = fArray2;
                objectArray2 = fArray3;
                break;
            }
            case 8: {
                double[] dArray = (double[])object;
                double[] dArray2 = new double[n11 * n3];
                double[] dArray3 = new double[n11 * n3];
                System.arraycopy(dArray, n, dArray2, 0, n11 * n3);
                objectArray = dArray2;
                objectArray2 = dArray3;
            }
        }
        int n12 = 0;
        while (nArray[n12] != -1) {
            this.Recv(objectArray2, 0, n3, datatype, nArray[n12], this.systemTAG);
            op.Call(objectArray2, 0, objectArray, 0, n3, datatype);
            ++n12;
        }
        if (n8 != -1) {
            this.Send(objectArray, 0, n3, datatype, n8, this.systemTAG);
        } else {
            this.copyBuffer(objectArray, 0, object2, n2, n3, datatype);
        }
        ++this.systemTAG;
    }

    private void ReduceFlat(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) {
        if (this.Rank() != n4) {
            this.Send(object, n, n3, datatype, n4, this.systemTAG);
        } else {
            int n5 = datatype.getBaseType();
            switch (n5) {
                case 1: {
                    byte[] byArray = (byte[])object;
                    byte[] byArray2 = (byte[])object2;
                    byte[] byArray3 = new byte[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n6;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(byArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(byArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                n6 = 0;
                                while (n6 < n3) {
                                    byArray2[n6] = byArray3[n6];
                                    ++i;
                                }
                                continue;
                            }
                            op.Call(byArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n6 = 0; n6 < n3; ++n6) {
                                byArray2[n6] = byArray[n6];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 2: {
                    char[] cArray = (char[])object;
                    char[] cArray2 = (char[])object2;
                    char[] cArray3 = new char[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n7;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(cArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(cArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n7 = 0; n7 < n3; ++n7) {
                                    cArray2[n7] = cArray3[n7];
                                }
                                continue;
                            }
                            op.Call(cArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n7 = 0; n7 < n3; ++n7) {
                                cArray2[n7] = cArray[n7];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 3: {
                    short[] sArray = (short[])object;
                    short[] sArray2 = (short[])object2;
                    short[] sArray3 = new short[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n8;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(sArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(sArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n8 = 0; n8 < n3; ++n8) {
                                    sArray2[n8] = sArray3[n8];
                                }
                                continue;
                            }
                            op.Call(sArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n8 = 0; n8 < n3; ++n8) {
                                sArray2[n8] = sArray[n8];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 5: {
                    int[] nArray = (int[])object;
                    int[] nArray2 = (int[])object2;
                    int[] nArray3 = new int[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n9;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(nArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(nArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n9 = 0; n9 < n3; ++n9) {
                                    nArray2[n9] = nArray3[n9];
                                }
                                continue;
                            }
                            op.Call(nArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n9 = 0; n9 < n3; ++n9) {
                                nArray2[n9] = nArray[n9];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 6: {
                    long[] lArray = (long[])object;
                    long[] lArray2 = (long[])object2;
                    long[] lArray3 = new long[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n10;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(lArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(lArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n10 = 0; n10 < n3; ++n10) {
                                    lArray2[n10] = lArray3[n10];
                                }
                                continue;
                            }
                            op.Call(lArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n10 = 0; n10 < n3; ++n10) {
                                lArray2[n10] = lArray[n10];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 7: {
                    float[] fArray = (float[])object;
                    float[] fArray2 = (float[])object2;
                    float[] fArray3 = new float[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n11;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(fArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(fArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n11 = 0; n11 < n3; ++n11) {
                                    fArray2[n11] = fArray3[n11];
                                }
                                continue;
                            }
                            op.Call(fArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n11 = 0; n11 < n3; ++n11) {
                                fArray2[n11] = fArray[n11];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
                case 8: {
                    double[] dArray = (double[])object;
                    double[] dArray2 = (double[])object2;
                    double[] dArray3 = new double[n3 * datatype.Extent()];
                    for (int i = 0; i < this.Size(); ++i) {
                        int n12;
                        if (i != n4) {
                            if (op.isCommute()) {
                                this.Recv(dArray3, 0, n3, datatype, i, this.systemTAG);
                            } else {
                                this.Recv(dArray3, 0, n3, datatype, i, this.systemTAG);
                            }
                            if (i == 0) {
                                for (n12 = 0; n12 < n3; ++n12) {
                                    dArray2[n12] = dArray3[n12];
                                }
                                continue;
                            }
                            op.Call(dArray3, 0, object2, n2, n3, datatype);
                            continue;
                        }
                        if (i == 0) {
                            for (n12 = 0; n12 < n3; ++n12) {
                                dArray2[n12] = dArray[n12];
                            }
                            continue;
                        }
                        op.Call(object, 0, object2, n2, n3, datatype);
                    }
                    break;
                }
            }
        }
        ++this.systemTAG;
    }

    public void Allreduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce(object, n, object2, n2, n3, datatype, op, 0);
        this.Bcast(object2, n2, n3, datatype, 0);
    }

    public void Alltoallv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallvAsynRotate(object, n, nArray, nArray2, datatype, object2, n2, nArray3, nArray4, datatype2);
    }

    private void AlltoallvPairWiseSyn(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        int n3 = this.Rank();
        int n4 = this.Size();
        for (int i = 1; i < n4; ++i) {
            int n5 = n3 ^ i;
            this.Send(object, n + nArray2[n5], nArray[n5], datatype, n5, this.systemTAG);
            this.Recv(object2, n2 + nArray4[n5], nArray3[n5], datatype2, n5, this.systemTAG);
        }
        this.copyBuffer(object, n + nArray2[n3], object2, n2 + nArray4[n3], nArray3[n3], datatype2);
    }

    private void AlltoallvAsynRotate(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        int n3;
        int n4 = this.Rank();
        int n5 = this.Size();
        for (n3 = 1; n3 < n5; ++n3) {
            int n6 = (n4 + n3) % n5;
            this.Send(object, n + nArray2[n6], nArray[n6], datatype, n6, this.systemTAG);
        }
        for (int i = 1; i < n5; ++i) {
            n3 = (n5 + (n4 - i)) % n5;
            this.Recv(object2, n2 + nArray4[n3], nArray3[n3], datatype2, n3, this.systemTAG);
        }
        this.copyBuffer(object, n + nArray2[n4], object2, n2 + nArray4[n4], nArray3[n4], datatype2);
    }

    private void AlltoallvAsyn(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        int n3;
        int n4 = this.Rank();
        for (n3 = 0; n3 < this.Size(); ++n3) {
            if (n3 == n4) continue;
            this.Send(object, n + nArray2[n3], nArray[n3], datatype, n3, this.systemTAG);
        }
        for (n3 = 0; n3 < this.Size(); ++n3) {
            if (n3 == n4) continue;
            this.Recv(object2, n2 + nArray4[n3], nArray3[n3], datatype2, n3, this.systemTAG);
        }
        this.copyBuffer(object, n + nArray2[n4], object2, n2 + nArray4[n4], nArray3[n4], datatype2);
    }

    private void AlltoallvLinear(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.Size(); ++i) {
            for (int j = 0; j < this.Size(); ++j) {
                if (i == this.Rank()) {
                    if (j == this.Rank()) {
                        this.copyBuffer(object, n + nArray2[n3], object2, n2 + nArray4[n4], nArray3[n3], datatype2);
                    } else {
                        this.Send(object, n + nArray2[n3], nArray[n3], datatype, j, this.systemTAG);
                    }
                } else if (j == this.Rank()) {
                    this.Recv(object2, n2 + nArray4[n4], nArray3[n4], datatype2, i, this.systemTAG);
                }
                ++n3;
            }
            ++n4;
            n3 = 0;
        }
    }

    public void Alltoall(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AlltoallAsynRotate(object, n, n2, datatype, object2, n3, n4, datatype2);
    }

    private void AlltoallPairWiseAsyn(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5;
        int n6;
        int n7 = this.Rank();
        int n8 = this.Size();
        for (n6 = 1; n6 < n8; ++n6) {
            n5 = n7 ^ n6;
            this.Send(object, n + n2 * n5, n2, datatype, n5, this.systemTAG);
        }
        for (n6 = 1; n6 < n8; ++n6) {
            n5 = n7 ^ n6;
            this.Recv(object2, n3 + n4 * n5, n4, datatype2, n5, this.systemTAG);
        }
        this.copyBuffer(object, n + n7 * n2, object2, n3 + n7 * n4, n4, datatype2);
    }

    private void AlltoallPairWiseSyn(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5 = this.Rank();
        int n6 = this.Size();
        for (int i = 1; i < n6; ++i) {
            int n7 = n5 ^ i;
            this.Send(object, n + n2 * n7, n2, datatype, n7, this.systemTAG);
            this.Recv(object2, n3 + n4 * n7, n4, datatype2, n7, this.systemTAG);
        }
        this.copyBuffer(object, n + n5 * n2, object2, n3 + n5 * n4, n2, datatype);
    }

    private void AlltoallAsynRotate(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5;
        int n6 = this.Rank();
        int n7 = this.Size();
        for (n5 = 1; n5 < n7; ++n5) {
            int n8 = (n6 + n5) % n7;
            int n9 = n8 * n2;
            this.Send(object, n + n9, n2, datatype, n8, this.systemTAG);
        }
        for (int i = 1; i < n7; ++i) {
            n5 = (n7 + (n6 - i)) % n7;
            int n10 = n5 * n4;
            this.Recv(object2, n3 + n10, n4, datatype2, n5, this.systemTAG);
        }
        this.copyBuffer(object, n + n6 * n2, object2, n3 + n6 * n4, n4, datatype2);
    }

    private void AlltoallAsyn(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.Rank();
        for (n5 = 0; n5 < this.Size(); ++n5) {
            if (n5 != n8) {
                this.Send(object, n + n6, n2, datatype, n5, this.systemTAG);
            }
            n6 += n2;
        }
        for (n5 = 0; n5 < this.Size(); ++n5) {
            if (n5 != n8) {
                this.Recv(object2, n3 + n7, n4, datatype2, n5, this.systemTAG);
            }
            n7 += n4;
        }
        this.copyBuffer(object, n + n8 * n2, object2, n3 + n8 * n4, n4, datatype2);
    }

    private void AlltoallLinear(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.Size(); ++i) {
            for (int j = 0; j < this.Size(); ++j) {
                if (i == this.Rank()) {
                    if (j == this.Rank()) {
                        this.copyBuffer(object, n + n5, object2, n3 + n6, n4, datatype2);
                    } else {
                        this.Send(object, n + n5, n2, datatype, j, this.systemTAG);
                    }
                } else if (j == this.Rank()) {
                    this.Recv(object2, n3 + n6, n4, datatype2, i, this.systemTAG);
                }
                n5 += n2;
            }
            n6 += n4;
            n5 = 0;
        }
    }

    public void Gather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GatherFlatTree(object, n, n2, datatype, object2, n3, n4, datatype2, n5);
    }

    private void GatherFlatTree(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        if (this.Rank() == n5) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i != n5) {
                    this.Recv(object2, n3 + i * n4, n4, datatype2, i, this.systemTAG);
                    continue;
                }
                this.copyBuffer(object, n, object2, n3 + n5 * n4, n4, datatype2);
            }
        } else {
            this.Send(object, n, n2, datatype, n5, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Gatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.GathervFlatTree(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2, n4);
    }

    private void GathervFlatTree(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2, int n4) {
        if (this.Rank() == n4) {
            for (int i = 0; i < this.Size(); ++i) {
                if (i != n4) {
                    this.Recv(object2, n3 + nArray2[i], nArray[i], datatype2, i, this.systemTAG);
                    continue;
                }
                this.copyBuffer(object, n, object2, n3 + nArray2[i], nArray[i], datatype2);
            }
        } else {
            this.Send(object, n, n2, datatype, n4, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Allgather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGatherSimple(object, n, n2, datatype, object2, n3, n4, datatype2);
    }

    private void AllGatherSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) {
        this.Gather(object, n, n2, datatype, object2, n3, n4, datatype2, 0);
        this.Bcast(object2, n3, n4 * this.Size(), datatype2, 0);
    }

    public void Allgatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.AllGathervSimple(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2);
    }

    private void AllGathervSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2) {
        this.Gatherv(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2, 0);
        int n4 = nArray2[nArray2.length - 1] + nArray[nArray.length - 1];
        this.Bcast(object2, n3, n4, datatype2, 0);
    }

    public void Scatter(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScatterSimple(object, n, n2, datatype, object2, n3, n4, datatype2, n5);
    }

    private void ScatterSimple(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) {
        int n6 = this.Size();
        if (this.Rank() == n5) {
            for (int i = 0; i < n6; ++i) {
                if (i != n5) {
                    this.Send(object, n + i * n2, n2, datatype, i, this.systemTAG);
                    continue;
                }
                this.copyBuffer(object, n + i * n2, object2, n3, n4, datatype2);
            }
        } else {
            this.Recv(object2, n3, n4, datatype2, n5, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Scatterv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int n3, Datatype datatype2, int n4) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.ScattervSimple(object, n, nArray, nArray2, datatype, object2, n2, n3, datatype2, n4);
    }

    private void ScattervSimple(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int n3, Datatype datatype2, int n4) {
        int n5 = this.Size();
        if (this.Rank() == n4) {
            for (int i = 0; i < n5; ++i) {
                if (i != n4) {
                    this.Send(object, n + nArray2[i], nArray[i], datatype, i, this.systemTAG);
                    continue;
                }
                this.copyBuffer(object, n + nArray2[i], object2, n2, n3, datatype2);
            }
        } else {
            this.Recv(object2, n2, n3, datatype2, n4, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public void Reduce_scatter(Object object, int n, Object object2, int n2, int[] nArray, Datatype datatype, Op op) {
        if (this.Rank() == MPI.UNDEFINED) {
            return;
        }
        this.Reduce_scatterSimple(object, n, object2, n2, nArray, datatype, op);
    }

    private void Reduce_scatterSimple(Object object, int n, Object object2, int n2, int[] nArray, Datatype datatype, Op op) {
        int n3 = this.Size();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 += nArray[i];
        }
        int[] nArray2 = new int[n3];
        nArray2[0] = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            nArray2[i + 1] = nArray2[i] + nArray[i];
        }
        Object[] objectArray = null;
        switch (datatype.getBaseType()) {
            case 1: {
                byte[] byArray;
                objectArray = byArray = new byte[n4];
                break;
            }
            case 2: {
                char[] cArray = new char[n4];
                objectArray = cArray;
                break;
            }
            case 3: {
                short[] sArray = new short[n4];
                objectArray = sArray;
                break;
            }
            case 5: {
                int[] nArray3 = new int[n4];
                objectArray = nArray3;
                break;
            }
            case 6: {
                long[] lArray = new long[n4];
                objectArray = lArray;
                break;
            }
            case 7: {
                float[] fArray = new float[n4];
                objectArray = fArray;
                break;
            }
            case 8: {
                double[] dArray = new double[n4];
                objectArray = dArray;
            }
        }
        this.Reduce(object, 0, objectArray, 0, n4, datatype, op, 0);
        this.Scatterv(objectArray, 0, nArray, nArray2, datatype, object2, 0, nArray[this.Rank()], datatype, 0);
    }

    public void Scan(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) {
        if (this.Rank() == 0) {
            this.copyBuffer(object, n, object2, n2, n3, datatype);
        } else {
            this.Recv(object2, n2, n3, datatype, this.Rank() - 1, this.systemTAG);
            op.Call(object, n, object2, n2, n3, datatype);
        }
        if (this.Rank() < this.Size() - 1) {
            this.Send(object2, n2, n3, datatype, this.Rank() + 1, this.systemTAG);
        }
        ++this.systemTAG;
    }

    public IntraComm Split(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = this.Size();
        int[] nArray = new int[]{n4, n5};
        int[] nArray2 = new int[2 * n6];
        this.Allgather(nArray, 0, 2, MPI.INT, nArray2, 0, 2, MPI.INT);
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < n6; ++i) {
            if (nArray2[2 * i] != n4) continue;
            int[] nArray3 = new int[]{nArray2[2 * i + 1], i};
            vector.add(nArray3);
        }
        Vector<int[]> vector2 = new Vector<int[]>();
        int n7 = vector.size();
        while (n7 != 0) {
            int[] nArray4 = (int[])vector.elementAt(0);
            int n8 = 0;
            for (n3 = 1; n3 < n7; ++n3) {
                if (nArray4[0] <= ((int[])vector.elementAt(n3))[0]) continue;
                n8 = n3;
                nArray4 = (int[])vector.elementAt(n3);
            }
            vector2.add(nArray4);
            vector.remove(n8);
            n7 = vector.size();
        }
        int n9 = vector2.size();
        int[] nArray5 = new int[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            nArray5[n3] = ((int[])vector2.elementAt(n3))[1];
        }
        Group group = this.Group().Incl(nArray5);
        return this.Create(group);
    }
}

