/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.socket.JxtaServerSocket;
import org.apache.log4j.Logger;
import p2pmpi.common.OsInfo;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.PlatformGenerator;
import p2pmpi.mpd.MPDAdv;
import p2pmpi.mpd.PipeAdvertisementPublisher;

public abstract class P2PMPI_MPDPeer
extends Thread {
    protected static final String P2P_MPI_GROUPNAME = "P2P-MPI";
    protected int mpdPort;
    protected static Logger log;
    protected PeerGroupAdvertisement mpiAdv = null;
    protected PeerGroup netpg = null;
    protected PeerGroup mpipg = null;
    protected DiscoveryService discovery = null;
    protected RendezVousService rendezvous = null;
    protected PipeService pipes = null;
    protected static final String groupURL = "jxta:uuid-A251B53298C043D29A9AF52E4094351F02";
    protected File runPath = null;
    protected String tmpDir = null;
    protected PipeAdvertisementPublisher pipePublisher = null;
    protected PipeAdvertisement pipeAdv = null;
    protected String peerName = null;
    protected int jxtaPort;
    protected int processID;
    protected final int connectNumTry = 240;
    protected final int connectSleep = 1000;
    protected JxtaServerSocket requestListenerSocket = null;
    protected InetAddress myIPAddress = null;

    public abstract void run();

    public void stopApp() {
        if (this.requestListenerSocket != null) {
            try {
                this.requestListenerSocket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.rendezvous != null) {
            this.rendezvous.stopRendezVous();
        }
        if (this.mpipg != null) {
            this.mpipg.stopApp();
        }
        if (this.netpg != null) {
            this.netpg.stopApp();
        }
    }

    protected boolean joinMpiGroup(int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
        int n5;
        int n6 = 240;
        RendezVousService rendezVousService = this.netpg.getRendezVousService();
        boolean bl3 = false;
        while (n6-- > 0) {
            if (!rendezVousService.isConnectedToRendezVous()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            log.info((Object)"Connected to RDV in NetPG");
            bl3 = true;
            break;
        }
        if (!bl3) {
            log.info((Object)"Cannot connect to RDV");
            return false;
        }
        log.debug((Object)"Attempting to Discover the P2P-MPI group");
        DiscoveryService discoveryService = this.netpg.getDiscoveryService();
        Enumeration enumeration = null;
        boolean bl4 = false;
        for (n5 = 0; n5 < n; ++n5) {
            try {
                enumeration = discoveryService.getLocalAdvertisements(1, "Name", P2P_MPI_GROUPNAME);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    bl4 = true;
                    break;
                }
                discoveryService.getRemoteAdvertisements(null, 1, "Name", P2P_MPI_GROUPNAME, 1, null);
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (IOException iOException) {
                log.error((Object)iOException.toString());
                return false;
            }
        }
        if (!bl4) {
            if (!bl) {
                log.info((Object)"P2P-MPI Group cannot be found;");
                return false;
            }
            try {
                ModuleImplAdvertisement moduleImplAdvertisement = this.netpg.getAllPurposePeerGroupImplAdvertisement();
                this.mpipg = this.netpg.newGroup(this.mkGroupID(), (Advertisement)moduleImplAdvertisement, P2P_MPI_GROUPNAME, "P2P-MPI> The new trend of MPI on P2P platform");
                this.mpiAdv = this.mpipg.getPeerGroupAdvertisement();
                log.debug((Object)this.mpiAdv.toString());
                this.discovery = this.mpipg.getDiscoveryService();
                this.pipes = this.mpipg.getPipeService();
                this.rendezvous = this.mpipg.getRendezVousService();
                this.rendezvous.startRendezVous();
                this.rendezvous.setAutoStart(true);
                log.info((Object)"Done. Create an advertisement.");
                return true;
            }
            catch (Exception exception) {
                log.error((Object)exception.toString());
                return false;
            }
        }
        try {
            this.mpiAdv = (PeerGroupAdvertisement)enumeration.nextElement();
            this.mpipg = this.netpg.newGroup((Advertisement)this.mpiAdv);
            log.info((Object)"Found P2P-MPI PeerGroup Advertisement: Join Existing Group");
            this.discovery = this.mpipg.getDiscoveryService();
            this.pipes = this.mpipg.getPipeService();
            this.rendezvous = this.mpipg.getRendezVousService();
        }
        catch (Exception exception) {
            try {
                ModuleImplAdvertisement moduleImplAdvertisement = this.netpg.getAllPurposePeerGroupImplAdvertisement();
                this.mpipg = this.netpg.newGroup(this.mkGroupID(), (Advertisement)moduleImplAdvertisement, P2P_MPI_GROUPNAME, "P2P-MPI> The new trend of MPI on P2P platform");
                this.mpiAdv = this.mpipg.getPeerGroupAdvertisement();
                log.debug((Object)this.mpiAdv.toString());
                this.discovery = this.mpipg.getDiscoveryService();
                this.pipes = this.mpipg.getPipeService();
                this.rendezvous = this.mpipg.getRendezVousService();
                log.info((Object)"Done. Create an advertisement");
            }
            catch (Exception exception2) {
                log.error((Object)exception2.toString());
                return false;
            }
        }
        if (bl2) {
            bl3 = false;
            for (n5 = 0; n5 < n3; ++n5) {
                if (!this.rendezvous.isConnectedToRendezVous()) {
                    try {
                        Thread.sleep(n4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.rendezvous.startRendezVous();
            }
        }
        this.rendezvous.setAutoStart(true);
        return true;
    }

    protected PeerGroupID mkGroupID() throws Exception {
        return (PeerGroupID)IDFactory.fromURI((URI)new URI("urn", groupURL, null));
    }

    protected boolean createJXTAPlatform(int n, Properties properties) {
        try {
            this.runPath = new File(this.tmpDir, this.peerName);
            PlatformGenerator platformGenerator = new PlatformGenerator(this.peerName, this.runPath.toString(), n, properties);
            if (!platformGenerator.generatePlatform()) {
                log.error((Object)"Create JXTA platform");
                return false;
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.toString());
            return false;
        }
        return true;
    }

    protected boolean createPipe(PeerGroup peerGroup, String string, boolean bl) {
        try {
            this.pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            this.pipeAdv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)peerGroup.getPeerGroupID()));
            this.pipeAdv.setName("P2P-MPI:" + string + ":" + this.peerName);
            this.pipeAdv.setType("JxtaUnicast");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        try {
            if (bl) {
                this.pipePublisher = new PipeAdvertisementPublisher(this.discovery, this.pipeAdv);
                new Thread(this.pipePublisher).start();
            } else {
                this.discovery.publish((Advertisement)this.pipeAdv, 31536000000L, 1209600000L);
                this.discovery.remotePublish((Advertisement)this.pipeAdv, 1209600000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected MPDAdv createMPDAdv(PeerGroup peerGroup) {
        MPDAdv mPDAdv = null;
        mPDAdv = (MPDAdv)AdvertisementFactory.newAdvertisement((String)MPDAdv.getAdvertisementType());
        mPDAdv.setOS(System.getProperty("os.name"));
        mPDAdv.setarch(System.getProperty("os.arch"));
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        try {
            this.myIPAddress = InetAddress.getLocalHost();
            mPDAdv.setName(this.myIPAddress.getHostName());
            mPDAdv.setIP(InetAddress.getByName(this.myIPAddress.getHostName()).getHostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (p2PMPI_ConfigFile.getExternalIP() != null) {
            log.info((Object)("** Setting my IP to " + p2PMPI_ConfigFile.getExternalIP() + " (from config file)."));
            mPDAdv.setIP(p2PMPI_ConfigFile.getExternalIP());
            try {
                this.myIPAddress = InetAddress.getByName(p2PMPI_ConfigFile.getExternalIP());
            }
            catch (UnknownHostException unknownHostException) {
                log.info((Object)"** [Error] External IP in P2P-MPI.conf is invalid");
                System.exit(1);
            }
        }
        mPDAdv.setMPDPort(p2PMPI_ConfigFile.getMPDPort());
        log.info((Object)("Set MPD PORT FOR VISU = " + p2PMPI_ConfigFile.getMPDPort()));
        mPDAdv.setFDPort(p2PMPI_ConfigFile.getFDPort());
        mPDAdv.setFTPort(p2PMPI_ConfigFile.getFTPort());
        String[] stringArray = OsInfo.cpuInfo();
        String[] stringArray2 = OsInfo.memInfo();
        if (stringArray == null) {
            mPDAdv.setCpuName("N/A");
            mPDAdv.setCpuFreq("N/A");
        } else {
            mPDAdv.setCpuName(stringArray[0]);
            mPDAdv.setCpuFreq(stringArray[1]);
        }
        if (stringArray2 == null) {
            mPDAdv.setMem("N/A");
        } else {
            mPDAdv.setMem(stringArray2[0]);
        }
        return mPDAdv;
    }
}

