/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaServerSocket;
import net.jxta.socket.JxtaSocket;
import org.apache.log4j.Logger;
import p2pmpi.common.NameGenerator;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.P2PMPI_Messenger;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.ProcessTable;
import p2pmpi.common.Version;
import p2pmpi.message.AuthAcceptMessage;
import p2pmpi.message.AuthDenyMessage;
import p2pmpi.message.AuthMessage;
import p2pmpi.message.AuthRequestMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.AppInfo;
import p2pmpi.mpd.MPDAdv;
import p2pmpi.mpd.MPD_Interface;
import p2pmpi.mpd.P2PMPI_MPDPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PMPI_MPD
extends P2PMPI_MPDPeer {
    int jxtaMinPort;
    int jxtaMaxPort;
    int jxtaCurrentPort;
    int ftPort;
    int fdPort;
    int numCPU;
    String externalIP;
    String usingIP;
    String[] hostDeny;
    String hostAllow;
    Properties confProps;
    Hashtable<String, AppInfo> hashTable;
    long startBOOT = System.currentTimeMillis();
    long stopBOOT;
    protected ProcessTable procTab = null;
    protected int numtaskSimul;
    String p2pMpiPrivate = null;

    private String[] parseHostDenyList(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        log.info((Object)("Deny List specified in config. file:" + string));
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = stringArray[i].trim();
                URI uRI = new URI(string2);
                stringArray2[n] = new String(string2);
                log.info((Object)("- Requests from " + stringArray2[n] + " will be ignored."));
                ++n;
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                log.info((Object)(" [Error] " + stringArray[i] + " is not a valid URI in configuration file."));
            }
        }
        log.info((Object)("Deny List parsed: " + stringArray2.length + " hosts or networks."));
        return stringArray2;
    }

    public P2PMPI_MPD(int n, int n2, int n3, int n4, int n5, String string, Properties properties, String string2, String string3, String string4, int n6, int n7) {
        log = Logger.getLogger((String)"MPD");
        this.mpdPort = n;
        this.fdPort = n2;
        this.ftPort = n3;
        this.jxtaMinPort = n4;
        this.jxtaMaxPort = n5;
        this.confProps = properties;
        this.numCPU = n7;
        this.externalIP = string2;
        if (string2 == null) {
            try {
                this.usingIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage());
                System.exit(1);
            }
        } else {
            this.usingIP = new String(string2);
        }
        this.hostAllow = string4;
        this.hostDeny = this.parseHostDenyList(string3);
        this.numtaskSimul = n6;
        this.jxtaCurrentPort = n4;
        this.tmpDir = new String(string);
        this.procTab = new ProcessTable();
        this.p2pMpiPrivate = System.getProperty("P2P_MPI_PRIVATE");
        this.hashTable = new Hashtable();
        log.info((Object)"********************** Starting MPD ***************************");
    }

    protected synchronized String getUniquePeerName(String string) {
        return new String(NameGenerator.getUniqueName(string));
    }

    protected synchronized int getJxtaPort() {
        ServerSocket serverSocket = null;
        for (int i = 0; i < 2; ++i) {
            for (int j = this.jxtaCurrentPort; j <= this.jxtaMaxPort; ++j) {
                try {
                    serverSocket = new ServerSocket(j);
                    serverSocket.close();
                    this.jxtaCurrentPort = j + 1;
                    return j;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            this.jxtaCurrentPort = this.jxtaMinPort;
        }
        return -1;
    }

    protected synchronized void requestPeer(PipeAdvertisement pipeAdvertisement, MPDMessage mPDMessage) {
        try {
            log.debug((Object)"--------Call REQUEST PEER WORKER-----------");
            log.debug((Object)pipeAdvertisement.toString());
            log.debug((Object)"-------------------------------------------");
            P2PMPI_Messenger p2PMPI_Messenger = new P2PMPI_Messenger(this.mpipg, pipeAdvertisement, mPDMessage, 5);
            p2PMPI_Messenger.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int isPeerOnline(PipeAdvertisement pipeAdvertisement) {
        int n = 3;
        JxtaSocket jxtaSocket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        AuthRequestMessage authRequestMessage = new AuthRequestMessage(this.usingIP);
        while (n-- > 0) {
            try {
                jxtaSocket = new JxtaSocket(this.mpipg, null, pipeAdvertisement, 2000, true);
                outputStream = jxtaSocket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(authRequestMessage);
                objectOutputStream.flush();
                inputStream = jxtaSocket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (object instanceof AuthAcceptMessage) {
                    int n2 = ((AuthAcceptMessage)object).getSlot();
                    log.debug((Object)("[isPeerOnline] Authentication ACCEPT from " + ((AuthAcceptMessage)object).getIP() + " using " + n2));
                    return n2;
                }
                if (object instanceof AuthDenyMessage) {
                    log.debug((Object)("[isPeerOnline] Authentication DENY from " + ((AuthDenyMessage)object).getIP()));
                    log.debug((Object)("Reason : " + ((AuthDenyMessage)object).getMessage()));
                    return 0;
                }
                log.debug((Object)"[isPeerOnline] unknown return message.");
            }
            catch (Exception exception) {
                log.debug((Object)("[isPeerOnline] can't get authentication back from peer :" + exception.toString()));
            }
        }
        return 0;
    }

    protected Vector<PipeAdvertisement> searchMPD(int n, int n2, int n3) {
        long l;
        int n4 = 0;
        int n5 = 10;
        Vector<PipeAdvertisement> vector = new Vector<PipeAdvertisement>();
        log.info((Object)("Searching For Advertisements [Min = " + n + ", Max = " + n2 + ", Wait = " + n3 + "]"));
        long l2 = System.currentTimeMillis();
        do {
            try {
                n4 = 0;
                Enumeration enumeration = this.discovery.getLocalAdvertisements(2, "Name", "P2P-MPI:MPD2" + Version.MAINVERSION + "*");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    vector.removeAllElements();
                    while (enumeration.hasMoreElements()) {
                        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)enumeration.nextElement();
                        if (!pipeAdvertisement.getName().equals(this.pipeAdv.getName())) {
                            if (this.isPeerOnline(pipeAdvertisement) == 0) continue;
                            vector.addElement(pipeAdvertisement);
                            ++n4;
                        }
                        if (n4 < n2) continue;
                        return vector;
                    }
                }
                log.debug((Object)("Found>" + n4 + " ads"));
                this.discovery.getRemoteAdvertisements(null, 2, "Name", "P2P-MPI:MPD2" + Version.MAINVERSION + "*", n2 + n5, null);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while ((int)(((l = System.currentTimeMillis()) - l2) / 1000L) < n3);
        vector.addElement(this.pipeAdv);
        return vector;
    }

    @Override
    public void run() {
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "noname";
        }
        this.peerName = NameGenerator.getUniqueName("P2P-MPD");
        int n = this.getJxtaPort();
        if (!this.createJXTAPlatform(n, this.confProps)) {
            log.fatal((Object)"Fatal Error: Can't create JXTA Platform");
            return;
        }
        System.setProperty("JXTA_HOME", this.runPath.toString());
        log.info((Object)"Creating netPG");
        try {
            this.netpg = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException peerGroupException) {
            log.debug((Object)peerGroupException.getMessage());
            return;
        }
        this.joinMpiGroup(10, 500, true, 60, 1000, true);
        if (!this.createPipe(this.mpipg, "MPD2" + Version.MAINVERSION + "." + Version.SUBVERSION, true)) {
            log.fatal((Object)"MPD Pipe Creation failed");
            return;
        }
        log.debug((Object)"============= Pipe Adv ==================");
        log.debug((Object)this.pipeAdv.toString());
        log.debug((Object)"=========================================");
        log.info((Object)">>> Creating MPD advertisement.");
        MPDAdv mPDAdv = this.createMPDAdv(this.mpipg);
        DiscoveryService discoveryService = this.mpipg.getDiscoveryService();
        try {
            discoveryService.publish((Advertisement)mPDAdv);
            discoveryService.remotePublish((Advertisement)mPDAdv);
        }
        catch (IOException iOException) {
            log.info((Object)iOException.toString());
        }
        log.debug((Object)mPDAdv.toString());
        MPD_Interface mPD_Interface = new MPD_Interface(this);
        mPD_Interface.start();
        log.info((Object)"MPD is Ready");
        this.requestListenerSocket = null;
        Socket socket = null;
        try {
            this.requestListenerSocket = new JxtaServerSocket(this.mpipg, this.pipeAdv, 50);
            this.requestListenerSocket.setSoTimeout(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.stopBOOT = System.currentTimeMillis();
        log.debug((Object)("BOOT TIME = " + (this.stopBOOT - this.startBOOT)));
        while (true) {
            try {
                log.debug((Object)"Waiting for a request");
                socket = this.requestListenerSocket.accept();
                P2PMPI_MPDThread p2PMPI_MPDThread = new P2PMPI_MPDThread(socket);
                p2PMPI_MPDThread.start();
            }
            catch (Exception exception) {
                break;
            }
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        File file2 = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        P2PMPI_MPD p2PMPI_MPD = new P2PMPI_MPD(p2PMPI_ConfigFile.getMPDPort(), p2PMPI_ConfigFile.getFDPort(), p2PMPI_ConfigFile.getFTPort(), p2PMPI_ConfigFile.getMinPort(), p2PMPI_ConfigFile.getMaxPort(), file2.toString(), p2PMPI_ConfigFile.getProperties(), p2PMPI_ConfigFile.getExternalIP(), p2PMPI_ConfigFile.getHostDeny(), p2PMPI_ConfigFile.getHostAllow(), p2PMPI_ConfigFile.getNumTaskSimul(), p2PMPI_ConfigFile.getNumCPU());
        p2PMPI_MPD.start();
    }

    public class P2PMPI_MPDThread
    extends Thread {
        Socket jxtaSocket = null;

        public P2PMPI_MPDThread(Socket socket) {
            this.jxtaSocket = socket;
        }

        private boolean isAllowed(String string, String[] stringArray) {
            if (stringArray == null) {
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(stringArray[i])) continue;
                P2PMPI_MPDPeer.log.info((Object)(" [Denied] " + string + " is not allowed (from configuration file)."));
                P2PMPI_MPDPeer.log.info((Object)"==============================================");
                return false;
            }
            return true;
        }

        public void run() {
            block32: {
                Object object;
                ObjectOutputStream objectOutputStream;
                ObjectInputStream objectInputStream;
                OutputStream outputStream;
                InputStream inputStream;
                block31: {
                    inputStream = null;
                    outputStream = null;
                    objectInputStream = null;
                    objectOutputStream = null;
                    try {
                        inputStream = this.jxtaSocket.getInputStream();
                        outputStream = this.jxtaSocket.getOutputStream();
                        objectInputStream = new ObjectInputStream(inputStream);
                        object = objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    if (!(object instanceof MPDMessage)) break block31;
                    MPDMessage mPDMessage = (MPDMessage)object;
                    block10 : switch (mPDMessage.getCmd()) {
                        case 8: {
                            try {
                                objectInputStream.close();
                                inputStream.close();
                                this.jxtaSocket.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            URI uRI = mPDMessage.getIP();
                            String string = mPDMessage.getID();
                            String string2 = mPDMessage.getRunCmd();
                            int n = mPDMessage.getRank();
                            MPDMessage mPDMessage2 = null;
                            P2PMPI_MPDPeer.log.info((Object)"======= I have a peer request message =======");
                            P2PMPI_MPDPeer.log.info((Object)(" ID     = " + string));
                            P2PMPI_MPDPeer.log.info((Object)(" myRank = " + n));
                            P2PMPI_MPDPeer.log.info((Object)(" URI    = " + uRI.getHost() + ":" + uRI.getPort()));
                            P2PMPI_MPDPeer.log.info((Object)(" runCmd = " + string2));
                            P2PMPI_MPDPeer.log.info((Object)"==============================================");
                            AppInfo appInfo = new AppInfo();
                            appInfo.setRunCmd(string2);
                            appInfo.setRank0(uRI);
                            String string3 = string + "--" + n;
                            P2PMPI_MPD.this.hashTable.put(string3, appInfo);
                            mPDMessage2 = new MPDMessage(9, string);
                            mPDMessage2.setFTPort(P2PMPI_MPD.this.ftPort);
                            mPDMessage2.setFDPort(P2PMPI_MPD.this.fdPort);
                            mPDMessage2.setRank(n);
                            mPDMessage2.setMyHost(P2PMPI_MPD.this.usingIP);
                            Socket socket = null;
                            for (int i = 0; i < 10; ++i) {
                                try {
                                    socket = new Socket(uRI.getHost(), uRI.getPort());
                                    outputStream = socket.getOutputStream();
                                    objectOutputStream = new ObjectOutputStream(outputStream);
                                    objectOutputStream.writeObject(mPDMessage2);
                                    objectOutputStream.flush();
                                    objectOutputStream.close();
                                    outputStream.close();
                                    socket.close();
                                    break block10;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                            }
                            break block32;
                        }
                        default: {
                            try {
                                objectInputStream.close();
                                inputStream.close();
                                this.jxtaSocket.close();
                                break;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    break block32;
                }
                if (object instanceof AuthRequestMessage) {
                    String string = ((AuthRequestMessage)object).getIP();
                    P2PMPI_MPDPeer.log.info((Object)("[MPD-JXTASocket]: received authentication request from :" + string));
                    AuthMessage authMessage = !this.isAllowed(string, P2PMPI_MPD.this.hostDeny) ? new AuthDenyMessage(P2PMPI_MPD.this.usingIP, "your IP is not allow on my server") : new AuthAcceptMessage(P2PMPI_MPD.this.usingIP, 1);
                    try {
                        int n = P2PMPI_MPD.this.procTab.size();
                        if (n < P2PMPI_MPD.this.numtaskSimul || P2PMPI_MPD.this.numtaskSimul == 0) {
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            objectOutputStream.writeObject(authMessage);
                            P2PMPI_MPDPeer.log.info((Object)"[MPD-JXTASocket]: accepting job request (sending an ack to ping)");
                            objectOutputStream.flush();
                            objectOutputStream.close();
                            outputStream.close();
                        } else {
                            objectOutputStream = new ObjectOutputStream(outputStream);
                            authMessage = new AuthDenyMessage(P2PMPI_MPD.this.usingIP, "Sorry, max number of running reached");
                            objectOutputStream.writeObject(authMessage);
                            P2PMPI_MPDPeer.log.info((Object)("[MPD-JXTASocket]: max number of running tasks reached (" + n + "). Ignore job request."));
                        }
                        objectInputStream.close();
                        inputStream.close();
                        this.jxtaSocket.close();
                    }
                    catch (Exception exception) {
                        P2PMPI_MPDPeer.log.debug((Object)("AuthRequest Exception : " + exception.toString()));
                    }
                } else if (object instanceof StatQueryMessage) {
                    Serializable serializable;
                    StatInfoMessage statInfoMessage = new StatInfoMessage();
                    Enumeration enumeration = P2PMPI_MPD.this.procTab.elements();
                    while (enumeration.hasMoreElements()) {
                        serializable = (ProcessInfo)enumeration.nextElement();
                        if (((ProcessInfo)serializable).getRank() != 0) continue;
                        statInfoMessage.addInfo((ProcessInfo)serializable);
                    }
                    serializable = null;
                    try {
                        serializable = InetAddress.getLocalHost();
                        String string = ((InetAddress)serializable).getHostName() + "/" + InetAddress.getByName(((InetAddress)serializable).getHostName()).getHostAddress();
                        statInfoMessage.setHostname(string);
                    }
                    catch (Exception exception) {
                        P2PMPI_MPDPeer.log.error((Object)"GAZ : Could not figure out hostname");
                        System.exit(1);
                    }
                    try {
                        objectOutputStream = new ObjectOutputStream(outputStream);
                        objectOutputStream.writeObject(statInfoMessage);
                        P2PMPI_MPDPeer.log.debug((Object)"GAZ : Sending visualization information ...");
                        objectOutputStream.flush();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        objectOutputStream.close();
                        outputStream.close();
                        objectInputStream.close();
                        inputStream.close();
                        this.jxtaSocket.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    try {
                        objectInputStream.close();
                        inputStream.close();
                        this.jxtaSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

