/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import p2pmpi.visu.P2PMPI_Visu;
import p2pmpi.visu.PeerNode;

class MyTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Name", "IP", "OS", "Domain", "Task", "Status"};
    private Vector data;

    public MyTableModel(P2PMPI_Visu p2PMPI_Visu) {
        this.data = p2PMPI_Visu.peers;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        PeerNode peerNode = (PeerNode)this.data.get(n);
        switch (n2) {
            case 0: {
                String string = peerNode.getHostName();
                int n3 = string.indexOf(".");
                String string2 = n3 > 0 && n3 < string.length() ? string.substring(0, n3) : string;
                return string2;
            }
            case 1: {
                return peerNode.getIP();
            }
            case 2: {
                return peerNode.getOSname();
            }
            case 3: {
                return peerNode.getDomainName();
            }
            case 4: {
                if (peerNode.Tasks.size() == 0) {
                    return "None";
                }
                String string = "";
                for (int i = 0; i < peerNode.Tasks.size(); ++i) {
                    string = peerNode.Tasks.get(i).getCmd() + ", " + string;
                }
                return string;
            }
            case 5: {
                return peerNode.getStatus();
            }
        }
        return "null";
    }

    public String toString() {
        String string = "\n\n** Disponibility Table **\n\n=========================================================================================\n";
        string = string + "Name\t\tIP\t\tOS\tDomain\t\tTask\tStatus";
        string = string + "\n___________________________________________________________________________________________\n";
        for (int i = 0; i < this.getRowCount(); ++i) {
            string = string + "\n";
            for (int j = 0; j < this.getColumnCount(); ++j) {
                string = j == 0 && ((String)this.getValueAt(i, j)).length() < 8 ? string + this.getValueAt(i, j) + "     \t" : string + this.getValueAt(i, j) + "\t";
            }
        }
        return string;
    }

    public void clear() {
        int n = this.data.size();
        this.data.removeAllElements();
        this.fireTableRowsUpdated(0, n - 1);
    }
}

