/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.rdv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Properties;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Configurator;
import net.jxta.ext.config.HttpTransport;
import net.jxta.ext.config.MulticastAddress;
import net.jxta.ext.config.TcpTransport;
import net.jxta.ext.config.TcpTransportAddress;
import net.jxta.ext.config.Trace;
import net.jxta.ext.config.Transport;
import org.apache.log4j.Logger;

public class RDVPlatformGenerator {
    private static final String JXTA_HOME = "JXTA_HOME";
    private static String TCP_PRE = "tcp://";
    private static String HTTP_PRE = "http://";
    private static String TCPADDRESS = "0.0.0.0";
    private static final String ADDR_SEP = ":";
    private static final String USER_NAME = "ulp";
    private static final String USER_PASSWD = "strasbourg";
    private String peerName = null;
    private File jxtaHome = null;
    private Properties confProps = null;
    private String IsRendezvous = "IsRendezvous";
    private String IsRelay = "IsRelay";
    private String UseRelay = "UseRelay";
    private String TcpPort = "TcpPort";
    private String HttpPort = "HttpPort";
    private String RendezvousIP = "Rendezvous_";
    private String RelayIP = "Relay_";
    private static Logger log;

    public RDVPlatformGenerator(String string, Properties properties) {
        this.peerName = string;
        this.confProps = properties;
        log = Logger.getLogger((String)"RDV");
        log.info((Object)("Generating PlatformConfig of peerName = " + string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generatePlatform() {
        Object object;
        Comparable<URI> comparable;
        Object object2;
        Object object3;
        File file = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        this.jxtaHome = new File(file, this.peerName);
        File file2 = new File(this.jxtaHome, "PlatformConfig");
        log.debug((Object)"Starting generating PlatformConfig");
        try {
            System.setProperty(JXTA_HOME, this.jxtaHome.toString());
            log.debug((Object)"Starting configurator");
            object3 = new Configurator(file.toURI());
            object3.setName(this.peerName);
            object3.setSecurity(USER_NAME, USER_PASSWD);
            object3.setDescription("P2P-MPI");
            log.debug((Object)"Ending configurator");
            object3.setProxy(false);
            object3.clearTransports();
            object2 = new TcpTransportAddress();
            object3.setRendezVous(true);
            if (this.confProps.getProperty(this.TcpPort) == null) {
                log.error((Object)"TCP port setting in config file not found");
                return false;
            }
            log.debug((Object)("I am a rendezVous, using port " + this.confProps.getProperty(this.TcpPort)));
            try {
                comparable = new URI("tcp://0.0.0.0:" + this.confProps.getProperty(this.TcpPort));
                object2.setAddress(comparable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            comparable = new MulticastAddress();
            comparable.setMulticast(true);
            object2.addMulticastAddress((MulticastAddress)comparable);
            TcpTransport tcpTransport = new TcpTransport();
            tcpTransport.setAddress((Address)object2);
            tcpTransport.setIncoming(true);
            tcpTransport.setOutgoing(true);
            tcpTransport.setProxy(false);
            tcpTransport.setEnabled(true);
            object3.setTransport((Transport)tcpTransport);
            String string = this.confProps.getProperty(this.UseRelay, "no");
            if (this.confProps.getProperty(this.IsRelay, "no").equalsIgnoreCase("no")) {
                log.debug((Object)"I am not a Relay");
                object3.setRelay(false);
            } else {
                log.debug((Object)"I am a Relay");
                string = "yes";
                object3.setRelay(true);
            }
            object = new Address();
            HttpTransport httpTransport = new HttpTransport();
            httpTransport.setAddress(object);
            httpTransport.setIncoming(false);
            httpTransport.setOutgoing(false);
            httpTransport.setProxy(false);
            httpTransport.setEnabled(false);
            object3.addTransport((Transport)httpTransport);
            object3.setEndpointOutgoingQueueSize(256);
            object3.clearRendezVous();
            object3.clearRelays();
            URI uRI = null;
            int n = 1;
            String string2 = null;
            while ((string2 = this.confProps.getProperty(this.RendezvousIP + n)) != null) {
                log.debug((Object)("Add <<" + string2 + ">> as RDV"));
                try {
                    uRI = new URI(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                object3.addRendezVous(uRI);
                ++n;
            }
            URI uRI2 = null;
            n = 1;
            String string3 = null;
            while ((string3 = this.confProps.getProperty(this.RelayIP + n)) != null) {
                log.debug((Object)("Add <<" + string3 + ">> as Relay"));
                try {
                    uRI2 = new URI(string3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                object3.addRelay(uRI2);
                ++n;
            }
            object3.setTrace(Trace.ERROR);
            if (object3.save(file2)) {
                log.info((Object)"Successful : generated file");
            } else {
                log.info((Object)"Unsuccessful : generated file");
            }
            log.info((Object)("Starting RendezVous seed = " + object3.getRendezVousBootstrapAddress().toString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        log.debug((Object)("Start copy config.properties to " + this.jxtaHome.toString()));
        object3 = null;
        object2 = null;
        try {
            object3 = new FileInputStream(System.getProperty("P2P_MPI_PRIVATE")).getChannel();
            comparable = new File(this.jxtaHome, "config.properties");
            object2 = new FileOutputStream((File)comparable).getChannel();
            long l = ((FileChannel)object3).size();
            object = ((FileChannel)object3).map(FileChannel.MapMode.READ_ONLY, 0L, l);
            ((FileChannel)object2).write((ByteBuffer)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (object3 != null) {
                try {
                    ((AbstractInterruptibleChannel)object3).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (object2 != null) {
                try {
                    ((AbstractInterruptibleChannel)object2).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        log.debug((Object)("Done copy config.properties to " + this.jxtaHome.toString()));
        return true;
    }
}

