/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Random;
import java.util.Vector;
import p2pmpi.common.Getopt;
import p2pmpi.common.HashGenerator;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.OutputMessage;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.FTMessage;
import p2pmpi.message.FinalizedConfirmMessage;
import p2pmpi.message.FinalizedMessage;
import p2pmpi.message.FoundNodeMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.mpi.Datatype;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPIClient;
import p2pmpi.mpi.Op;
import p2pmpi.mpi.internal.MessageHandler;

public class MPI {
    public static Datatype BYTE;
    public static Datatype CHAR;
    public static Datatype SHORT;
    public static Datatype BOOLEAN;
    public static Datatype INT;
    public static Datatype LONG;
    public static Datatype FLOAT;
    public static Datatype DOUBLE;
    public static Datatype STRING;
    public static Datatype OBJECT;
    public static Datatype BYTE2;
    public static Datatype CHAR2;
    public static Datatype SHORT2;
    public static Datatype INT2;
    public static Datatype LONG2;
    public static Datatype FLOAT2;
    public static Datatype DOUBLE2;
    public static Datatype PACKED;
    public static int ANY_SOURCE;
    public static int ANY_TAG;
    public static int UNEQUAL;
    public static int SIMILAR;
    public static int IDENT;
    public static int UNDEFINED;
    public static Op MAX;
    public static Op MIN;
    public static Op SUM;
    public static Op PROD;
    public static Op BAND;
    public static Op MAXLOC;
    public static Op MINLOC;
    public static IntraComm COMM_WORLD;
    protected static RankTable rankTable;
    protected static MapRankTable mapRankTable;
    protected static String myHash;
    protected static int fdPort;
    protected static int mpdPort;
    protected static int myRank;
    protected static MessageHandler msgHandle;
    protected static Random mpiRandom;
    private static String hostIP;
    private static int t_sent;

    private static void setLocalhostIP() {
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        String string = p2PMPI_ConfigFile.getExternalIP();
        if (string == null) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                System.err.println("** [ Error] Could not figure out local hostname.");
                System.exit(-1);
            }
            hostIP = inetAddress.getHostAddress();
        } else {
            hostIP = string;
        }
    }

    protected static String getLocalhostIP() {
        return hostIP;
    }

    public static String[] Init(String[] stringArray) {
        String[] stringArray2 = null;
        String string = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        MPIMessage mPIMessage = null;
        URI uRI = null;
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        mpdPort = p2PMPI_ConfigFile.getMPDPort();
        int n = p2PMPI_ConfigFile.getFTPort();
        fdPort = p2PMPI_ConfigFile.getFDPort();
        MPI.setLocalhostIP();
        int n2 = p2PMPI_ConfigFile.getMinPort();
        int n3 = p2PMPI_ConfigFile.getMaxPort();
        int n4 = 0;
        String string2 = System.getProperty("mode");
        ServerSocket serverSocket = null;
        if (string2.equals("server")) {
            Serializable serializable;
            int n5;
            Object object;
            String[] stringArray3;
            String[] stringArray4;
            Object object2;
            int n6;
            Object object3;
            Object object4;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = -1;
            int n13 = -1;
            int n14 = 1;
            String string3 = null;
            boolean bl = true;
            Getopt getopt = new Getopt("P2P-MPI", stringArray, "w:n:r:l:o");
            getopt.setOpterr(false);
            while ((n11 = getopt.getopt()) != -1) {
                switch (n11) {
                    case 119: {
                        String string4 = getopt.getOptarg();
                        try {
                            n13 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -w must be follow by positive integer number");
                            System.exit(1);
                        }
                        if (n13 >= -1) break;
                        System.err.println("** [Error] -w must be follow by positive integer number");
                        System.exit(1);
                        break;
                    }
                    case 110: {
                        String string4 = getopt.getOptarg();
                        try {
                            n12 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -n must be follow by positive integer number");
                            System.exit(1);
                        }
                        if (n12 >= 1) break;
                        System.err.println("** [Error] -n must be follow by positive integer number");
                        System.exit(1);
                        break;
                    }
                    case 114: {
                        String string4 = getopt.getOptarg();
                        try {
                            n14 = Integer.parseInt(string4);
                        }
                        catch (Exception exception) {
                            System.err.println("** [Error] -r must be follow by positive integer number");
                            System.exit(1);
                        }
                        if (n14 >= 1) break;
                        System.err.println("** [Error] -r must be follow by positive integer number");
                        System.exit(1);
                        break;
                    }
                    case 108: {
                        String string4 = getopt.getOptarg();
                        string3 = new String(string4);
                        break;
                    }
                    case 111: {
                        bl = false;
                    }
                }
            }
            Vector<String> vector = new Vector<String>();
            for (n10 = getopt.getOptind(); n10 < stringArray.length; ++n10) {
                vector.addElement(stringArray[n10]);
            }
            string = new String((String)vector.elementAt(0));
            n10 = vector.size();
            stringArray2 = new String[n10 - 1];
            for (n9 = 0; n9 < n10 - 1; ++n9) {
                stringArray2[n9] = new String((String)vector.elementAt(n9 + 1));
                string = string + " " + stringArray2[n9];
            }
            n9 = n14;
            int n15 = (n12 - 1) * n14;
            Random random = new Random();
            for (n8 = n7 = random.nextInt(n3 - n2) + n2; n8 <= n3; ++n8) {
                try {
                    serverSocket = new ServerSocket(n8);
                    n4 = n8;
                    break;
                }
                catch (Exception exception) {
                    serverSocket = null;
                    continue;
                }
            }
            if (serverSocket == null) {
                for (n8 = n2; n8 <= n3; ++n8) {
                    try {
                        serverSocket = new ServerSocket(n8);
                        n4 = n8;
                        break;
                    }
                    catch (Exception exception) {
                        serverSocket = null;
                        continue;
                    }
                }
                if (serverSocket == null) {
                    System.err.println("No available ports in the range allowed [" + n2 + " - " + n3 + "] to run this application");
                    System.exit(1);
                }
            }
            myHash = HashGenerator.gen();
            mpiRandom = new Random(Long.parseLong(myHash));
            try {
                uRI = new URI("tcp://" + MPI.getLocalhostIP() + ":" + n4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n12 == 1) {
                rankTable = new RankTable();
                rankTable.addProcess(0, uRI, fdPort);
                mapRankTable = new MapRankTable();
                mapRankTable.addMap(0, 0);
                AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
                appRegisterMessage.setID(myHash + "--0");
                appRegisterMessage.setRunCmd(string);
                appRegisterMessage.setIPRank0(MPI.getLocalhostIP());
                appRegisterMessage.setRunDir("");
                appRegisterMessage.setRank(0);
                appRegisterMessage.setPort(n4);
                appRegisterMessage.setMPISize(n12);
                appRegisterMessage.setRealSize(rankTable.size());
                appRegisterMessage.setRankTable(rankTable);
                try {
                    object4 = new Socket("127.0.0.1", mpdPort);
                    outputStream = ((Socket)object4).getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(appRegisterMessage);
                    objectOutputStream.flush();
                    inputStream = ((Socket)object4).getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    PingReplyMessage pingReplyMessage = (PingReplyMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    objectOutputStream.close();
                    outputStream.close();
                    inputStream.close();
                    ((Socket)object4).close();
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Please make sure that MPD is running.");
                    System.exit(1);
                }
                msgHandle = new MessageHandler(serverSocket, n12, rankTable, myHash, mpdPort, fdPort);
                msgHandle.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
                object4 = new Thread(msgHandle);
                ((Thread)object4).setDaemon(true);
                ((Thread)object4).start();
                COMM_WORLD = new IntraComm(msgHandle, rankTable, 0, 0, n12, mapRankTable);
                return stringArray2;
            }
            if (n13 < 0) {
                n13 = n15 * 3;
            }
            MPDMessage mPDMessage = new MPDMessage(7, myHash);
            mPDMessage.setMinPeers(n9);
            mPDMessage.setMaxPeers(n15);
            mPDMessage.setWaitTime(n13);
            mPDMessage.setIP(MPI.getLocalhostIP(), n4);
            mPDMessage.setRunCmd(string);
            System.out.println("Searching nodes for a maximum of " + n13 + " seconds ...");
            object4 = null;
            try {
                object4 = new Socket("127.0.0.1", mpdPort);
                outputStream = ((Socket)object4).getOutputStream();
                inputStream = ((Socket)object4).getInputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(mPDMessage);
                objectOutputStream.flush();
                objectInputStream = new ObjectInputStream(inputStream);
                object3 = (FoundNodeMessage)objectInputStream.readObject();
                boolean bl2 = ((FoundNodeMessage)object3).isEnough();
                n6 = ((FoundNodeMessage)object3).getNumFoundNode();
                objectInputStream.close();
                objectOutputStream.close();
                inputStream.close();
                outputStream.close();
                ((Socket)object4).close();
                if (!bl2) {
                    System.err.println("** [Error] Not enough hosts (found only " + n6 + ").");
                    System.err.println("**         You may try to search longer with -w option.");
                    System.exit(1);
                }
                if (n6 < n15) {
                    System.out.println("** [Warning] Found only " + n6 + " host(s).");
                    System.out.println("**           Several processes will be executed on a same host.");
                }
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot connect to local MPD.");
                System.err.println("**         Make sure you run \"mpiboot\"");
                System.exit(1);
            }
            System.out.println("Waiting the reply from other nodes..");
            object3 = null;
            MPDMessage mPDMessage2 = null;
            n6 = 0;
            URI[] uRIArray = new URI[n15];
            int[] nArray = new int[n15];
            try {
                serverSocket.setSoTimeout(120000);
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            while (true) {
                try {
                    object3 = serverSocket.accept();
                    inputStream = ((Socket)object3).getInputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    mPDMessage2 = (MPDMessage)objectInputStream.readObject();
                    objectInputStream.close();
                    inputStream.close();
                    ((Socket)object3).close();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    System.err.println("** [Error] No reply from at least one of the hosts.");
                    System.err.println("**         Check no firewall blocks port " + serverSocket.getLocalPort());
                    System.exit(1);
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
                switch (mPDMessage2.getCmd()) {
                    case 9: {
                        System.out.println("======== got ACCEPT reply  ==========");
                        System.out.println(" FT socket : " + mPDMessage2.getHost() + ":" + mPDMessage2.getFTPort());
                        System.out.println(" Key : " + mPDMessage2.getRank());
                        System.out.println("=====================================");
                        try {
                            uRIArray[n6] = new URI("tcp://" + mPDMessage2.getHost() + ":" + mPDMessage2.getFTPort());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        nArray[n6] = mPDMessage2.getRank();
                        ++n6;
                        break;
                    }
                    default: {
                        System.out.println("Unknown command");
                    }
                }
                if (n6 >= n15) break;
            }
            Vector<Object> vector2 = new Vector<Object>();
            if (string3 == null) {
                object2 = new String((String)vector.elementAt(0));
                stringArray4 = new File(System.getProperty("user.dir"), (String)object2);
                object2 = new String(stringArray4.toString() + ".class");
                vector2.addElement(object2);
            } else {
                object2 = new File(string3);
                try {
                    String string5;
                    stringArray4 = new BufferedReader(new FileReader((File)object2));
                    while ((string5 = stringArray4.readLine()) != null) {
                        stringArray3 = new File(string5);
                        if (!stringArray3.exists()) {
                            System.err.println("** [Error] File : " + string5 + " in " + string3 + " does not exist");
                            System.exit(1);
                        }
                        vector2.addElement(string5);
                    }
                }
                catch (Exception exception) {
                    System.err.println("** [Error] Could not read file " + string3);
                    System.exit(1);
                }
            }
            int n16 = vector2.size();
            stringArray4 = new String[n16];
            for (int i = 0; i < n16; ++i) {
                stringArray4[i] = new String((String)vector2.elementAt(i));
            }
            FTMessage fTMessage = new FTMessage(4, myHash);
            fTMessage.setKeys(nArray);
            fTMessage.setURIs(uRIArray);
            fTMessage.setFileNames(stringArray4);
            fTMessage.setSize(n6);
            System.out.print("Transfering files ... [ ");
            stringArray3 = fTMessage.getOnlyFileNameList();
            for (int i = 0; i < stringArray3.length; ++i) {
                System.out.print(stringArray3[i] + " ");
            }
            System.out.println("]");
            try {
                object4 = new Socket("127.0.0.1", n);
                outputStream = ((Socket)object4).getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(fTMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                ((Socket)object4).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Waiting for processes to acknowledge file transfer ...");
            rankTable = new RankTable();
            rankTable.addProcess(0, uRI, fdPort);
            mapRankTable = new MapRankTable();
            mapRankTable.addMap(0, 0);
            int n17 = 0;
            try {
                serverSocket.setSoTimeout(n6 * 5000);
            }
            catch (Exception exception) {
                System.err.println("** [Error] Cannot set socket timeout.");
                System.exit(1);
            }
            boolean bl3 = false;
            while (true) {
                try {
                    while (true) {
                        System.out.println("Wait for SYN message ...");
                        object3 = serverSocket.accept();
                        inputStream = ((Socket)object3).getInputStream();
                        objectInputStream = new ObjectInputStream(inputStream);
                        object = objectInputStream.readObject();
                        if (object instanceof MPIMessage) {
                            mPIMessage = (MPIMessage)object;
                            objectInputStream.close();
                            inputStream.close();
                            ((Socket)object3).close();
                        } else if (object instanceof OutputMessage) {
                            OutputMessage outputMessage = (OutputMessage)object;
                            System.out.println(">>>>" + outputMessage.getOutput());
                            objectInputStream.close();
                            inputStream.close();
                            ((Socket)object3).close();
                            continue;
                        }
                        break;
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    System.err.println("** [Error] Not enough peers to form an execution platform.");
                    System.err.println("**         At least one of the requested hosts is behind a firewall.");
                    System.exit(1);
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                if (mPIMessage.getCmd() != 11) continue;
                System.out.println("SYN:" + mPIMessage.getRank() + ":" + mPIMessage.getURI());
                rankTable.addProcess(mPIMessage.getRank(), mPIMessage.getURI(), mPIMessage.getFDPort());
                mapRankTable.addMap(mPIMessage.getRank(), ++n17);
                if (n17 >= n6) break;
            }
            bl3 = true;
            if (!bl3) {
                object = new boolean[n12];
                int n18 = rankTable.size();
                for (n5 = 0; n5 < n12; ++n5) {
                    object[n5] = false;
                }
                for (n5 = 0; n5 < n18; ++n5) {
                    object[MPI.rankTable.getRank((int)n5)] = true;
                }
                for (n5 = 0; n5 < n12; ++n5) {
                    if (object[n5] != false) continue;
                    System.err.println("*** Not enough peer to form an execution platform. ***");
                    System.exit(1);
                }
            }
            int n19 = rankTable.size();
            boolean[] blArray = new boolean[n12];
            for (n5 = 0; n5 < n12; ++n5) {
                blArray[n5] = false;
            }
            System.out.println("==================================");
            for (n5 = 0; n5 < n19; ++n5) {
                int n20 = rankTable.getRank(n5);
                if (!blArray[n20]) {
                    System.out.println("[Master of Rank " + n20 + "]: IP = " + rankTable.getHost(n5));
                    blArray[n20] = true;
                    continue;
                }
                System.out.println("Rank " + n20 + ": IP = " + rankTable.getHost(n5));
            }
            System.out.println("==================================");
            long l = System.currentTimeMillis();
            for (int i = 1; i < n19; ++i) {
                mPIMessage = new MPIMessage(12);
                mPIMessage.setCommTable(rankTable);
                mPIMessage.setRank(rankTable.getRank(i));
                mPIMessage.setRankInList(i);
                mPIMessage.setSize(n12);
                mPIMessage.setTGossip(p2PMPI_ConfigFile.getTGossip());
                mPIMessage.setTHang(p2PMPI_ConfigFile.getTHang());
                mPIMessage.setTMargin(t_sent * rankTable.size());
                System.out.println("Using protocol = " + p2PMPI_ConfigFile.getGossipProtocol());
                mPIMessage.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
                mPIMessage.setTDiff((int)(System.currentTimeMillis() - l));
                try {
                    System.out.println("Send a List to:" + rankTable.getHost(i) + ":" + rankTable.getPort(i));
                    object3 = new Socket(rankTable.getHost(i), rankTable.getPort(i));
                    outputStream = ((Socket)object3).getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(mPIMessage);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                    ((Socket)object3).close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            msgHandle = new MessageHandler(serverSocket, n12, rankTable, myHash, mpdPort, fdPort);
            msgHandle.setTGossip(p2PMPI_ConfigFile.getTGossip());
            msgHandle.setTMargin(t_sent * rankTable.size());
            msgHandle.setTHang(p2PMPI_ConfigFile.getTHang());
            msgHandle.setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
            Thread thread = new Thread(msgHandle);
            thread.setDaemon(true);
            thread.start();
            COMM_WORLD = new IntraComm(msgHandle, rankTable, 0, 0, n12, mapRankTable);
            AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
            appRegisterMessage.setID(myHash + "--0");
            appRegisterMessage.setRunCmd(string);
            appRegisterMessage.setIPRank0(MPI.getLocalhostIP());
            appRegisterMessage.setRunDir(System.getProperty("user.dir"));
            appRegisterMessage.setRank(0);
            appRegisterMessage.setPort(n4);
            appRegisterMessage.setMPISize(n12);
            appRegisterMessage.setRealSize(rankTable.size());
            appRegisterMessage.setRankTable(rankTable);
            try {
                object3 = new Socket("127.0.0.1", mpdPort);
                outputStream = ((Socket)object3).getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appRegisterMessage);
                objectOutputStream.flush();
                inputStream = ((Socket)object3).getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                serializable = (PingReplyMessage)objectInputStream.readObject();
                objectInputStream.close();
                objectOutputStream.close();
                outputStream.close();
                inputStream.close();
                ((Socket)object3).close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Please make sure that MPD is running.");
                System.exit(1);
            }
            System.out.println("Create an gossip instance !!");
            serializable = new GossipMessage(0, myHash);
            ((GossipMessage)serializable).setMyRank(0);
            ((GossipMessage)serializable).setMPIRank(0);
            ((GossipMessage)serializable).setMPIPort(n4);
            ((GossipMessage)serializable).setURIList(rankTable.getFDURIs());
            ((GossipMessage)serializable).setTGossip(p2PMPI_ConfigFile.getTGossip());
            ((GossipMessage)serializable).setTHang(p2PMPI_ConfigFile.getTHang());
            ((GossipMessage)serializable).setTMargin(t_sent * rankTable.size());
            ((GossipMessage)serializable).setGossipProtocol(p2PMPI_ConfigFile.getGossipProtocol());
            ((GossipMessage)serializable).setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - l));
            try {
                object3 = new Socket("127.0.0.1", fdPort);
                outputStream = ((Socket)object3).getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                ((Socket)object3).close();
            }
            catch (Exception exception) {
                System.err.println("** [Error] Fault Detection Service is not running");
                System.exit(1);
            }
            System.out.println("Program is executing ...");
        } else {
            MPIClient mPIClient = new MPIClient(n2, n3);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = new String(stringArray[i]);
            }
        }
        return stringArray2;
    }

    public static int Rand() {
        return mpiRandom.nextInt();
    }

    public static int Rand(int n) {
        return mpiRandom.nextInt(n);
    }

    public static void Finalize() {
        int n;
        Serializable serializable;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        COMM_WORLD.Barrier();
        if (rankTable.size() == 1) {
            if (msgHandle != null) {
                msgHandle.shutdown();
            }
            try {
                AppUnregisterMessage appUnregisterMessage = new AppUnregisterMessage(myHash, myRank);
                socket = new Socket("127.0.0.1", mpdPort);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(appUnregisterMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                System.out.println("MPD Service is not running");
            }
            return;
        }
        if (msgHandle.getRankInList() == 0) {
            msgHandle.meTerminated();
            while (!msgHandle.isAllTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            serializable = new FinalizedConfirmMessage();
            n = rankTable.size();
            for (int i = 1; i < n; ++i) {
                if (!rankTable.isAlive(i)) continue;
                try {
                    socket = new Socket(rankTable.getHost(i), rankTable.getPort(i));
                    outputStream = socket.getOutputStream();
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.close();
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            serializable = new FinalizedMessage(msgHandle.getRankInList());
            try {
                socket = new Socket(rankTable.getHost(0), rankTable.getPort(0));
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (!msgHandle.isTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }
        try {
            serializable = new GossipMessage(2, myHash);
            n = msgHandle.getRankInList();
            ((GossipMessage)serializable).setMyRank(n);
            socket = new Socket("127.0.0.1", fdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Fault Detection Service is not running");
        }
        try {
            serializable = new AppUnregisterMessage(myHash, myRank);
            socket = new Socket("127.0.0.1", mpdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("MPD Service is not running");
        }
        int n2 = msgHandle.getMessageBufferSize();
        if (n2 != 0) {
            System.err.println("** [rank " + msgHandle.getRank() + "] Warning : there was " + n2 + " message(s) left in reception buffer. **");
        }
        if (msgHandle != null) {
            msgHandle.shutdown();
        }
    }

    public static double Wtime() {
        return (double)System.currentTimeMillis() / 1.0;
    }

    public static double Wtick() {
        double d = 1.0E-4;
        double d2 = 0.0;
        if (d2 == 0.0) {
            d2 = System.currentTimeMillis();
            d2 = (double)System.currentTimeMillis() - d2;
            for (int i = 0; i < 10; ++i) {
                double d3 = System.currentTimeMillis();
                d3 = (double)System.currentTimeMillis() - d3;
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            d2 = d2 > 0.0 ? d2 : 1.0E-5;
        }
        return 0.0;
    }

    public static String Get_processor_name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        myHash = null;
        msgHandle = null;
        hostIP = null;
        t_sent = 1000;
        BYTE = new Datatype(1);
        CHAR = new Datatype(2);
        SHORT = new Datatype(3);
        BOOLEAN = new Datatype(4);
        INT = new Datatype(5);
        LONG = new Datatype(6);
        FLOAT = new Datatype(7);
        DOUBLE = new Datatype(8);
        PACKED = new Datatype(9);
        STRING = new Datatype(10);
        OBJECT = new Datatype(11);
        BYTE2 = BYTE.Contiguous(2);
        CHAR2 = CHAR.Contiguous(2);
        SHORT2 = SHORT.Contiguous(2);
        INT2 = INT.Contiguous(2);
        LONG2 = LONG.Contiguous(2);
        FLOAT2 = FLOAT.Contiguous(2);
        DOUBLE2 = DOUBLE.Contiguous(2);
        ANY_SOURCE = Tag.MPI_ANYSOURCE;
        ANY_TAG = Tag.MPI_ANYTAG;
        UNDEFINED = -3;
        UNEQUAL = 0;
        SIMILAR = 1;
        IDENT = 2;
        MAX = new Op(1);
        MIN = new Op(2);
        SUM = new Op(3);
        PROD = new Op(4);
        BAND = new Op(6);
        MAXLOC = new Op(12);
        MINLOC = new Op(11);
    }
}

