/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.document.AdvertisementFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaSocket;
import p2pmpi.common.NameGenerator;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.common.P2PMPI_Messenger;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.RankTable;
import p2pmpi.common.Version;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.message.PingRequestMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.MPDAdv;
import p2pmpi.visu.Fenetre;
import p2pmpi.visu.P2PMPI_VisuPeer;
import p2pmpi.visu.PeerNode;
import p2pmpi.visu.StatQuery;
import p2pmpi.visu.Visu_Param;
import p2pmpi.visu.p2pNetMap;

public class P2PMPI_Visu
extends P2PMPI_VisuPeer {
    private static String[] options = new String[]{"-h", "--help", null, "Display this help message.", "-c", "--console", "r", "Run in console mode. Refresh every r seconds."};
    int peerDrawOption = 1;
    int peerOrderOption = 1;
    Properties confProps;
    Hashtable hashTable;
    public Vector<StatInfoMessage> infoMsgs;
    Vector<String> treatedAdvs;
    long startBOOT;
    long stopBOOT;
    public Vector<PeerNode> peers = new Vector();
    public Fenetre fen;
    public p2pNetMap jc2;
    public int echelle;
    Visu_Param v;
    public static boolean textMode = false;
    public static int refreshRate;
    public String currentTask;

    private static void usage() {
        System.out.println("usage: runVisu [OPTION...]");
        for (int i = 0; i < options.length; i += 4) {
            System.out.print(options[i] + "| " + options[i + 1] + "\t");
            if (options[i + 2] != null) {
                System.out.print(options[i + 2]);
            }
            System.out.println("\t" + options[i + 3]);
        }
    }

    private static String parseArgs(String[] stringArray, int n) {
        int n2 = n * 4;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(options[n2]) && !stringArray[i].equals(options[n2 + 1])) continue;
            if (options[n2 + 2] != null) {
                if (stringArray.length >= i + 2) {
                    return stringArray[i + 1];
                }
                System.out.println("command line parse error: " + options[n2] + " or " + options[n2 + 1] + " requires a parameter.");
                System.exit(1);
                continue;
            }
            return new String("");
        }
        return null;
    }

    public P2PMPI_Visu(String string, Properties properties) {
        this.startBOOT = System.currentTimeMillis();
        this.confProps = properties;
        this.tmpDir = new String(string);
        this.hashTable = new Hashtable();
        this.infoMsgs = new Vector();
        AdvertisementFactory.registerAdvertisementInstance((String)"jxta:P2PMPI:MPD-ADV", (AdvertisementFactory.Instantiator)new MPDAdv.Instantiator());
        this.treatedAdvs = new Vector();
        this.jc2 = new p2pNetMap(this);
    }

    protected synchronized String getUniquePeerName(String string) {
        return new String(NameGenerator.getUniqueName(string));
    }

    public void requestPeer(PipeAdvertisement pipeAdvertisement, StatQueryMessage statQueryMessage) {
        try {
            System.out.println("--------Call REQUEST PEER WORKER-----------");
            System.out.println(pipeAdvertisement.toString());
            System.out.println("-------------------------------------------");
            P2PMPI_Messenger p2PMPI_Messenger = new P2PMPI_Messenger(this.mpipg, pipeAdvertisement, statQueryMessage, 5);
            p2PMPI_Messenger.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isPeerOnline(PipeAdvertisement pipeAdvertisement) {
        int n = 2;
        JxtaSocket jxtaSocket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        PingRequestMessage pingRequestMessage = new PingRequestMessage();
        while (n-- > 0) {
            try {
                jxtaSocket = new JxtaSocket(this.mpipg, null, pipeAdvertisement, 3000, true);
                outputStream = jxtaSocket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(pingRequestMessage);
                objectOutputStream.flush();
                inputStream = jxtaSocket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                if (!(object instanceof PingReplyMessage)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    protected void searchMPD(int n) {
        this.treatedAdvs.clear();
        System.out.print("+");
        try {
            this.discovery.getRemoteAdvertisements(null, 2, "advType", "jxta:P2PMPI:MPD-ADV:" + Version.MAINVERSION + "*", n, (DiscoveryListener)new Listener(this));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PeerGroup getPG() {
        return this.mpipg;
    }

    public void fillPeers() {
        for (int i = 0; i < this.infoMsgs.size(); ++i) {
            StatInfoMessage statInfoMessage = this.infoMsgs.get(i);
            int n = statInfoMessage.size();
            if (n <= 0) continue;
            for (int j = 0; j < n; ++j) {
                ProcessInfo processInfo = statInfoMessage.getInfo(j);
                String string = processInfo.getRunCmd();
                RankTable rankTable = processInfo.getRankTable();
                for (int k = 0; k < rankTable.size(); ++k) {
                    int n2;
                    PeerNode peerNode = this.jc2.findNode(rankTable.getHost(k).trim());
                    if (peerNode == null) continue;
                    peerNode.setStatus("Working");
                    int n3 = -1;
                    for (int i2 = 0; i2 < peerNode.Tasks.size() && n3 == -1; ++i2) {
                        if (!string.trim().equals(peerNode.Tasks.get(i2).getCmd())) continue;
                        n3 = 1;
                        int n4 = -1;
                        for (n2 = 0; n2 < peerNode.Tasks.get((int)i2).Ranks.size() && n4 == -1; ++n2) {
                            if (peerNode.Tasks.get((int)i2).Ranks.get(n2).intValue() != rankTable.getRank(k)) continue;
                            peerNode.Tasks.get(i2).updateStatus(n2, rankTable.isAlive(k));
                            n4 = 1;
                        }
                        if (n4 != -1) continue;
                        peerNode.Tasks.get(i2).addRank(rankTable.getRank(k), rankTable.isAlive(k));
                    }
                    if (n3 == -1) {
                        n2 = 1;
                        if (processInfo.getMPISize() > 1) {
                            n2 = (processInfo.getRealSize() - 1) / (processInfo.getMPISize() - 1);
                        }
                        peerNode.newTask(string, rankTable.getRank(k), rankTable.isAlive(k), rankTable.size(), n2);
                    }
                    this.v.constructTaskData();
                }
                this.jc2.addComboTask(string);
            }
        }
    }

    public void refreshTables() {
        this.v.refreshTables();
    }

    public void run() {
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "noname";
        }
        this.peerName = NameGenerator.getUniqueName("P2P-MPD");
        if (!this.createJXTAPlatform(this.jxtaPort, this.confProps)) {
            System.err.println("** Error: Can't create JXTA Platform");
            return;
        }
        System.setProperty("JXTA_HOME", this.runPath.toString());
        System.out.print("* Trying to join the standard NetPeerGroup ... ");
        try {
            this.netpg = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException peerGroupException) {
            peerGroupException.printStackTrace();
            return;
        }
        System.out.println(" [ok]");
        System.out.print("* Connecting to rendezvous peer            ... ");
        this.joinMpiGroup(10, 500, true, 60, 1000, true);
        System.out.println(" [ok]");
        this.v = new Visu_Param(this);
        if (!textMode) {
            this.v.getJFrame().setVisible(true);
        } else {
            this.v.scan();
        }
        this.stopBOOT = System.currentTimeMillis();
        System.out.println("* Platform boot in " + (this.stopBOOT - this.startBOOT) / 1000L + " seconds.");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (stringArray.length > 0) {
            object2 = null;
            object2 = P2PMPI_Visu.parseArgs(stringArray, 0);
            if (object2 != null) {
                P2PMPI_Visu.usage();
                System.exit(0);
            }
            object = null;
            object = P2PMPI_Visu.parseArgs(stringArray, 1);
            if (object != null) {
                textMode = true;
                refreshRate = !((String)object).equals("") ? Integer.parseInt((String)object) : 30;
                System.out.println("Console mode (refresh every " + refreshRate + " seconds)");
            } else {
                System.out.println("Bad command line arguments.");
                P2PMPI_Visu.usage();
                System.exit(1);
            }
        }
        object2 = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        object = new File(System.getProperty("P2PMPI_HOME"), "tmp");
        System.out.println("* Read config file: " + ((File)object2).toString());
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(((File)object2).toString());
        P2PMPI_Visu p2PMPI_Visu = new P2PMPI_Visu(((File)object).toString(), p2PMPI_ConfigFile.getProperties());
        p2PMPI_Visu.start();
    }

    class Listener
    implements DiscoveryListener {
        P2PMPI_Visu parent;

        public Listener(P2PMPI_Visu p2PMPI_Visu2) {
            this.parent = p2PMPI_Visu2;
        }

        public void discoveryEvent(DiscoveryEvent discoveryEvent) {
            DiscoveryResponseMsg discoveryResponseMsg = discoveryEvent.getResponse();
            Enumeration enumeration = discoveryResponseMsg.getAdvertisements();
            while (enumeration.hasMoreElements()) {
                MPDAdv mPDAdv = (MPDAdv)((Object)enumeration.nextElement());
                if (P2PMPI_Visu.this.treatedAdvs.contains(mPDAdv.getName())) continue;
                P2PMPI_Visu.this.treatedAdvs.addElement(mPDAdv.getName());
                this.transferQuery(mPDAdv);
            }
        }

        public void transferQuery(MPDAdv mPDAdv) {
            StatQuery statQuery = new StatQuery(this.parent, mPDAdv, this.parent.getPG());
            statQuery.start();
        }
    }
}

